<?php $this->load->view('includes/head') ?>
<?php $this->load->view('includes/topbar') ?>
<?php $this->load->view('includes/header') ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<style type="text/css">
    textarea::placeholder {
        color: var(--main-color-new-theme) !important;
    }

    .form-select {
        color: #2e2e2e;
    }

    .asdfradio {
        --text: #414856;
        --radio: #7C96B2;
        --radio-checked: #0080A1;
        --radio-size: 20px;
        --width: 150px;
        --height: 140px;
        --border-radius: 10px;
        border-radius: var(--border-radius);
        color: var(--text);
        position: relative;
        padding: 6px 0px;
        display: grid;
        grid-template-columns: auto var(--radio-size);
        align-items: center;
        display: -webkit-inline-box;
    }

    .asdfradio label {
        cursor: pointer;
    }

    .asdfradio input[type="radio"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        position: relative;
        height: var(--radio-size);
        width: var(--radio-size);
        outline: none;
        margin: 0;
        cursor: pointer;
        border: 2px solid var(--radio);
        background: transparent;
        border-radius: 50%;
        display: grid;
        justify-self: end;
        justify-items: center;
        align-items: center;
        overflow: hidden;
        transition: border .5s ease;
    }

    .asdfradio input[type="radio"]::before,
    .asdfradio input[type="radio"]::after {
        content: "";
        display: flex;
        justify-self: center;
        border-radius: 50%;
    }

    .asdfradio input[type="radio"]::before {
        position: absolute;
        width: 100%;
        height: 100%;
        background: var(--background);
        z-index: 1;
        opacity: var(--opacity, 1);
    }

    .asdfradio input[type="radio"]::after {
        position: relative;
        width: calc(100% /2);
        height: calc(100% /2);
        background: var(--radio-checked);
        top: var(--y, 100%);
        transition: top 0.5s cubic-bezier(0.48, 1.97, 0.5, 0.63);
    }

    .asdfradio input[type="radio"]:checked {
        --radio: var(--radio-checked);
    }

    .asdfradio input[type="radio"]:checked::after {
        --y: 0%;
        animation: stretch-animate .3s ease-out .17s;
    }

    .asdfradio input[type="radio"]:checked::before {
        --opacity: 0;
    }

    .asdfradio input[type="radio"]:checked~input[type="radio"]::after {
        --y: -100%;
    }

    .asdfradio input[type="radio"]:not(:checked)::before {
        --opacity: 1;
        transition: opacity 0s linear .5s;
    }

    @keyframes stretch-animate {
        0% {
            transform: scale(1, 1);
        }

        28% {
            transform: scale(1.15, 0.85);
        }

        50% {
            transform: scale(0.9, 1.1);
        }

        100% {
            transform: scale(1, 1);
        }
    }

    .socials {
        position: fixed;
        display: block;
        left: 20px;
        bottom: 20px;
    }

    .socials>a {
        display: block;
        width: 30px;
        opacity: .2;
        transform: scale(var(--scale, 0.8));
        transition: transform 0.3s cubic-bezier(0.38, -0.12, 0.24, 1.91);
    }

    .socials>a:hover {
        --scale: 1;
    }

    .select2-container--default .select2-selection--single {
        border: 0px !important;
    }

    .CheckBox {
        height: 1.5em;
        width: 1.5em;
        vertical-align: bottom;
    }

    .text-size {
        font-size: 14px !important;
    }
</style>
<main id="main">
    <!-- ======= Coming Soon ======= -->
    <section>
        <div class="container-fluid">
            <center>
                <h2 style="font-weight: bold !important; font-size: 35px !important;">
                    Volunteer Registration Form<br />
                    <img src="<?= base_url('assets/img/border.png') ?>" class="img-fluid img-responsive" style="width: 20%;" />
                </h2>
            </center>
            <br />
            <div class="row mb-3">
                <div class="col-md-10 mx-auto d-block">
                    <?php

                    if ($this->session->flashdata('failure')) {
                        echo $this->session->flashdata('failure');
                    }
                    if ($this->session->flashdata('success')) {
                        echo $this->session->flashdata('success');
                    } ?>
                    <!-- <form action="<?= base_url('Forms/AddVolunteers') ?>" class="contact-form shadow-lg" method="post" enctype="multipart/form-data"> -->

                    <?php echo form_open_multipart('Forms/AddVolunteers', 'class="contact-form shadow-lg"'); ?>


                    <div class="row">
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Upload Photo</legend>
                                <div class="input-group">

                                    <input type="file" name="idcard" class="form-control border-0" />
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">First Name<span class="mandate">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-user"></i>
                                    <input type="text" class="form-control border-0" placeholder="First Name*" name="fname" id="fname" required />
                                </div>
                            </fieldset>
                        </div>

                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Last Name<span class="mandate">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-user"></i>
                                    <input type="text" class="form-control border-0" placeholder="Last Name*" name="lname" id="lname" required />
                                </div>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Email<span class="mandate">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-envelope"></i>
                                    <input type="email" class="form-control border-0" name="email" placeholder="Email*" required oninput="this.value = this.value.toLowerCase();" />
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Phone Number<span class="mandate">*</span></legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-phone"></i>
                                    <input type="text" class="form-control border-0" id="volunteerPhone"
                                        name="Phone" placeholder="Phone Number" required />
                                </div>
                            </fieldset>
                        </div>

                    </div>
                    <div class="row">
                        <span class="reg-form">For Emergency </span>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Name</legend>
                                <div class="input-group">
                                    <input type="text" class="form-control border-0" name="Emrg_Contact_Name" placeholder="Emergency Contact Name" />
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Contact Number</legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-phone"></i>
                                    <input type="text" class="form-control border-0" name="Emrg_Contact_Number" id="Emrg_Contact_Number" placeholder="Emergency Contact Number" />
                                </div>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Date of Birth</legend>
                                <div class="input-group">
                                    <labe class="fa fa-calendar" for="dob"></labe>
                                    <input type="text" name="dob" id="dob" class="form-control datepicker border-0" placeholder="MM/DD/YYYY" aria-label="dob" aria-describedby="basic-addon1" autocomplete="off">
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Select Gender</legend>
                                <div class="input-group">
                                    <div class="asdfradio">
                                        <label for="male">Male</label>
                                        <input id="male" type="radio" name="gender" value="MALE" checked="" style="margin-left:5px">
                                        <label for="female" style="margin-left:20px">Female</label>
                                        <input id="female" type="radio" name="gender" value="FEMALE" style="margin-left:5px">
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <fieldset class="border">
                                    <legend class="legend-inner float-none w-auto">Address</legend>
                                    <div class="input-group">

                                        <input type="text" class="form-control border-0" id="address" name="address" placeholder="Address" />
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">County</legend>
                                <div class="input-group">
                                    <input type="text" class="form-control border-0" id="county" name="county" placeholder="County" />
                                </div>
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">State</legend>
                                <div class="input-group">

                                    <select class="form-control select2 border-0 form-select" name="state" id="stateSelect">
                                        <option value="" selected disabled>Select State</option>
                                        <?php
                                        $GetState = GetState();
                                        $keys = array_column($GetState, 'refDataName');
                                        array_multisort($keys, SORT_ASC, $GetState);

                                        foreach ($GetState as $state) { ?>
                                            <option value="<?= @$state->refDataName ?>"><?= @$state->refDataName ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">City</legend>
                                <div class="input-group">
                                    <select class="form-control select2 border-0 form-select" name="city" id="city">
                                        <option value="" selected disabled>Select City</option>
                                    </select>
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-md-4">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Zipcode</legend>
                                <div class="input-group">
                                    <i class="fa fa2 fa-file"></i>
                                    <input type="text" class="form-control border-0" name="zipcode" placeholder="Zipcode" maxlength="6" />
                                </div>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Volunteer Area</legend>
                                <div class="input-group">
                                    <div class="row">


                                        <?php $VolunteerTypes = VolunteerTypes();

                                        foreach ($VolunteerTypes as $item) { ?>
                                            <div class="col-sm-4 mb-2 text-size">
                                                <input type="checkbox" name="VolunteerArea[]" class="CheckBox" value="<?= $item->refDataName; ?>">&nbsp;<b><?= $item->refDataName; ?></b>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">How many hours per week are you committed to volunteer?</legend>
                                <div class="input-group">
                                    <input type="number" class="form-control border-0" name="hours" placeholder="Hrs Per Week" />
                                </div>
                            </fieldset>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <fieldset class="border">
                                <legend class="legend-inner float-none w-auto">Notes</legend>
                                <div class="input-group">
                                    <textarea name="notes" class="form-control border-0" placeholder="Notes"></textarea>
                                </div>
                            </fieldset>
                        </div>
                    </div>


                    <!-- Modal T&C -->
                    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-scrollable">
                            <div class="modal-content">
                                <div class="modal-header" style="border-top:0">
                                    <h5 class="modal-title fw-bold text-center" id="exampleModalScrollableTitle">Chatwala VOLUNTEER CODE OF CONDUCT</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">

                                 <section>
										<p class="text-muted" style="font-style: italic;">
											[Terms & Conditions content will be provided by you.]
										</p>
										<p>
											Please share the rules, responsibilities, and agreement clauses that you want volunteers to accept before submitting the form.
										</p>
										<p>
											Example sections may include:
										<ul>
											<li>Volunteer responsibilities and conduct</li>
											<li>Event timings and dress code</li>
											<li>Liability disclaimer</li>
											<li>Photo/video permission</li>
											<li>Confidentiality agreement</li>
										</ul>
										</p>
										<p class="text-danger fw-bold"> Kindly provide this content to complete the final version of the volunteer form.</p>
										<div class="row">
											<div class="col-md-6">
												<span>Accepted: <span class="v_name fw-bold"></span></span>
											</div>
											<div class="col-md-6">
												<span>Date:<?= date('m/d/Y'); ?></span>
											</div>
										</div>
									</section>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-success px-3 py-2" id="accept" style="padding: 0px 9px;color: white;">Accept</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal T&C Close -->

                    <div class="row">
                        <div class="col-md-12">
                            <style type="text/css">
                                .tacbox {
                                    display: block;
                                    padding: 1em;
                                    border: 3px solid #ddd;
                                    background-color: #eee;
                                    max-width: 100%;
                                }

                                .tnc {
                                    height: 2em;
                                    width: 2em;
                                    vertical-align: middle;
                                }
                            </style>
                            <div class="tacbox">
                                <input id="TermConditions" type="checkbox" class="tnc TermConditions" required />
                                <label for="checkbox " class="TermConditions"><a href="javascript:void(0)" class="text-danger">Please Accept Our Terms and Conditions.</a></label>
                            </div>
                        </div>
                    </div>

                    <div class="submit-button-wrapper">
                        <input type="submit" value="SUBMIT" class="btn btn-success mx-3 mt-4" />
                        <input type="reset" value="CANCEL" class="btn btn-cancel mx-3 mt-4" style="background: gray;" />
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- End Coming Soon -->
</main>
<!-- End #main -->

<script type="text/javascript">
    $(document).ready(function() {
        // Listen for the click event on the "Accept" button
        $('#accept').click(function() {

            // Close the modal
            $('#exampleModal').modal('hide');
            // Check the checkbox
            $('.TermConditions').prop('checked', true);
        });

        // Listen for the change event of the checkbox
        $('.TermConditions').change(function() {
            var full_name = $("#fname").val() + ' ' + $("#lname").val();
            $(".v_name").text(full_name);
            // Check if the checkbox is checked
            if ($(this).is(':checked')) {
                $('.TermConditions').prop('checked', false);
                // Show the modal when the checkbox is checked
                $('#exampleModal').modal('show');
            }
        });
    });



    $(document).on('focus', '.datepicker', function() {
        $(this).datepicker({
            dateFormat: "mm/dd/yy",
            changeMonth: true,
            changeYear: true,
            yearRange: "-70:+0",
            maxDate: new Date(),
            onSelect: function(dateText) {
                console.log("Selected date:", dateText);
                console.log(dateText);
                $(this).val(dateText);
            },
            autocomplete: "off" // Turn off auto-suggestion
        });
    });




    function phone_formatting(ele, restore) {
        var new_number,
            selection_start = ele.selectionStart,
            selection_end = ele.selectionEnd,
            number = ele.value.replace(/\D/g, "");
        if (number.length > 2) {
            new_number = number.substring(0, 3) + "-";
            if (number.length === 4 || number.length === 5) {
                new_number += number.substr(3);
            } else if (number.length > 5) {
                new_number += number.substring(3, 6) + "-";
            }
            if (number.length > 6) {
                new_number += number.substring(6);
            }
        } else {
            new_number = number;
        }
        ele.value = new_number.length > 12 ? new_number.substring(12, 0) : new_number;
        document.getElementById("msg").innerHTML = "<p>Selection is: " + selection_end + " and length is: " + new_number.length + "</p>";

        if ((new_number.slice(-1) === "-" && restore === false && new_number.length === 8 && selection_end === 7) || (new_number.length === 4 && selection_end === 3)) {
            selection_start = new_number.length;
            selection_end = new_number.length;
        } else if (restore === "revert") {
            selection_start--;
            selection_end--;
        }
        ele.setSelectionRange(selection_start, selection_end);
    }

    function phone_number_check(field, e) {
        var key_code = e.keyCode,
            key_string = String.fromCharCode(key_code),
            press_delete = false,
            dash_key = 189,
            delete_key = [8, 46],
            direction_key = [33, 34, 35, 36, 37, 38, 39, 40],
            selection_end = field.selectionEnd;

        // delete key was pressed
        if (delete_key.indexOf(key_code) > -1) {
            press_delete = true;
        }

        // only force formatting is a number or delete key was pressed
        if (key_string.match(/^\d+$/) || press_delete) {
            phone_formatting(field, press_delete);
        }
        // do nothing for direction keys, keep their default actions
        else if (direction_key.indexOf(key_code) > -1) {
            // do nothing
        } else if (dash_key === key_code) {
            if (selection_end === field.value.length) {
                field.value = field.value.slice(0, -1);
            } else {
                field.value = field.value.substring(0, selection_end - 1) + field.value.substr(selection_end);
                field.selectionEnd = selection_end - 1;
            }
        }
        // all other non numerical key presses, remove their value
        else {
            e.preventDefault();
            //    field.value = field.value.replace(/[^0-9\-]/g,'')
            phone_formatting(field, "revert");
        }
    }

    // Attach event handler to the "volunteerPhone" input field
    document.getElementById("volunteerPhone").onkeyup = function(e) {
        phone_number_check(this, e);
    };

    // Attach event handler to the "Emrg_Contact_Number" input field
    document.getElementById("Emrg_Contact_Number").onkeyup = function(e) {
        phone_number_check(this, e);
    };



    $('#stateSelect').change(function() {

        var stateCode = $(this).val();
        $.ajax({
            url: "<?= base_url('Home/GetCity') ?>",
            type: "POST",
            // dataType: "json",
            data: {
                'stateCode': stateCode
            },
            success: function(data) {
                $("#city").html(data);
            }
        });

    });

    $('#stateSelect, #city, #VolunteerArea').select2()

    $(document).ready(function() {
        window.scrollTo({
            top: 215,
            behavior: "smooth"
        });
    });
</script>

<?php $this->load->view('includes/footer') ?>
<?php $this->load->view('includes/script') ?>