<!DOCTYPE html>
<html lang="en">

<head>
	<?php
	if (!empty($this->uri->segment('3'))) {
		$serviceName = str_replace("-", " ", $this->uri->segment('3'));
		$pujalistData = @getPujaList($serviceName, $this->uri->segment('2'));
	} else {
		$serviceName = 'Pooja List';
		$pujalistData = @getPujaList('', $this->uri->segment('2'));
	}

	$serviceNamePDF = @$pujalistData['serviceName'];
	if (empty($serviceNamePDF)) {
		$serviceNamePDF = 'Pooja List';
	}
	// $pujalist = []; 
	// var_dump($pujalistData);
	?>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $serviceName ?></title>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link rel="shortcut icon" href="<?= base_url('assets/img/android-chrome-192x192.png') ?>" type="image/x-icon">
	<style>
		#content {
			width: 100%;
			max-width: 600px;
			margin: 0 auto;
			padding: 20px;
			border: 1px solid #ddd;
			font-family: Arial, sans-serif;
		}

		h1 {
			color: #333;
		}

		p {
			line-height: 1.6;
		}

		button {
			display: block;
			margin: 20px;
			/* margin: 20px auto; */
			padding: 10px 20px;
			font-size: 16px;
			background-color: #9d0000;
			color: #fff;
			border: none;
			border-radius: 5px;
			cursor: pointer;
		}

		button:hover {
			background-color: #0056b3;
		}
	</style>
	<style type="text/css">
		.pujalist td,
		.pujalist th,
		.description td,
		.description th,
		.phead,
		.pthead {
			border: 1px solid #A71333;
			padding: 6px;
			text-align: center;
			font-weight: 600;
			/*							text-shadow: 0px 1px 13px #fff700;*/
			color: #9d0000;

		}

		/*Modal Css*/


		.modal-header {
			border-top: none !important;
		}

		.modal-confirm {
			color: #877676;
			width: 550px;
		}



		.modal-confirm .modal-content {
			padding: 20px;
			border-radius: 5px;
			border: none;
		}

		.modal-confirm .modal-header {
			border-bottom: none;
			position: relative;
		}

		.modal-confirm h4 {
			text-align: center;
			font-size: 20px;
			margin: 22px 0 -15px;
			color: var(--main-color-new-theme);
			font-weight: 800;
		}

		.modal-confirm .form-control,
		.modal-confirm .btn {
			min-height: 40px;
			border-radius: 3px;
		}

		.modal-confirm .close {
			position: absolute;
			top: -5px;
			right: -5px;
		}

		.modal-confirm .modal-footer {
			border: none;
			text-align: center;
			border-radius: 5px;
			font-size: 13px;
		}

		.modal-confirm .icon-box {
			color: #fff !important;
			position: absolute;
			margin: 0 auto;
			left: 0;
			right: 0;
			top: -70px;
			width: 95px;
			height: 95px;
			border-radius: 50%;
			z-index: 9;
			background: #fff;
			padding: 2px;
			text-align: center;
			box-shadow: 0px 2px 2px rgb(0 0 0 / 10%);
		}

		.modal-confirm .icon-box i {
			font-size: 56px;
			position: relative;
			top: 4px;
		}

		.modal-confirm .btn {
			color: #fff;
			border-radius: 4px !important;
			background: var(--main-color-new-theme);
			text-decoration: none;
			transition: all 0.4s;
			line-height: normal;
			border: none;
			padding: 0px 36px;
		}

		.modal-confirm .btn:hover,
		.modal-confirm .btn:focus {
			background: #da2c12;
			outline: none;
		}

		.trigger-btn {
			display: inline-block;
			margin: 100px auto;
		}


		.modal-dialog-centered {
			display: flex;
			align-items: center;
			min-height: calc(100% - 1rem);
		}

		.icon-box {
			max-width: 100px;
			max-height: 100px;
		}

		@media (max-width: 767.98px) {
			.modal-lg {
				max-width: 100%;
				margin: 1.75rem auto;
			}
		}

		input.search-text {
			color: #222;
			position: relative;
			z-index: 5;
			transition: z-index 0.8s, width 0.5s, background 0.3s ease, border 0.3s;
			height: 39px;
			width: 0;
			margin: 0;
			padding: 5px 0 5px 38px;
			box-sizing: border-box;
			font-size: 16px;
			font-size: 2rem;
			cursor: pointer;
			border-radius: 30px;
			border: 1px solid transparent;
			/* background: url(search.png) no-repeat left 9px center transparent; */
			background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjwhRE9DVFlQRSBzdmcgIFBVQkxJQyAnLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4nICAnaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkJz48c3ZnIGVuYWJsZS1iYWNrZ3JvdW5kPSJuZXcgMCAwIDUxMiA1MTIiIGhlaWdodD0iNTEycHgiIGlkPSJMYXllcl8xIiB2ZXJzaW9uPSIxLjEiIHZpZXdCb3g9IjAgMCA1MTIgNTEyIiB3aWR0aD0iNTEycHgiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxwYXRoIGQ9Ik01MDMuODY2LDQ3Ny45NzRMMzYwLjk1OCwzMzUuMDUyYzI4LjcyNS0zNC41NDQsNDYuMDE3LTc4LjkxMiw0Ni4wMTctMTI3LjMzNiAgYzAtMTEwLjA4NC04OS4yMjctMTk5LjMxMi0xOTkuMzEyLTE5OS4zMTJDOTcuNTk5LDguNDAzLDguMzUxLDk3LjYzMSw4LjM1MSwyMDcuNzE1YzAsMTEwLjA2NCw4OS4yNDgsMTk5LjMxMiwxOTkuMzEyLDE5OS4zMTIgIGM0OC40MzUsMCw5Mi43OTItMTcuMjkyLDEyNy4zMzYtNDYuMDE3bDE0Mi45MDgsMTQyLjkyMkw1MDMuODY2LDQ3Ny45NzR6IE0yOS4zMzEsMjA3LjcxNWMwLTk4LjMzNCw3OS45ODctMTc4LjMzMiwxNzguMzMyLTE3OC4zMzIgIGM5OC4zMjUsMCwxNzguMzMyLDc5Ljk5OCwxNzguMzMyLDE3OC4zMzJzLTgwLjAwNywxNzguMzMyLTE3OC4zMzIsMTc4LjMzMkMxMDkuMzE4LDM4Ni4wNDcsMjkuMzMxLDMwNi4wNSwyOS4zMzEsMjA3LjcxNXoiIGZpbGw9IiMzNzQwNEQiLz48L3N2Zz4=) no-repeat left 9px center transparent;
			background-size: 24px;
			z-index: 3;
			width: 100%;
			border: 2px solid var(--main-color-new-theme);
			background-color: white;
			outline: none;
			cursor: auto;
			padding-right: 10px;
		}
	</style>
</head>

<body style="padding: 0% 20% 0% 20%;">

	<button id="downloadPdf"><i class="fa fa-download"></i></button>


	<div class="p-0 text-center" id="PdfPrintSection" style="text-align: center;">


		<img src="<?= base_url('assets/img/android-chrome-192x192.png') ?>" class="icon-box" style="border-radius: 50%;">
		<h4 class="modal-title w-100 fw-bold" style="color:#9d0000!important;font-size:25px!important">❋ <?= @$pujalistData['serviceName'] ?> Puja Samagri ❋</h4>



		<?php
		

		$pujalistData['poojaList']=[
			[
				"name"=>"Betel Leaves",
				"qty"=>"5"
			],
			[
				"name"=>"Betel Nuts",
				"qty"=>"1 packet (Around 20 count)"
			],
			[
				"name"=>"Quarter Coins",
				"qty"=>"20"
			],
			[
				"name"=>"Turmeric",
				"qty"=>"50 gms"
			],
			[
				"name"=>"Kumkum",
				"qty"=>"50 gms"
			],
			[
				"name"=>"Gandham",
				"qty"=>"50 gms"
			],
			[
				"name"=>"Akshathalu",
				"qty"=>"50 gms"
			],
			[
				"name"=>"Coconut",
				"qty"=>"1"
			],
			[
				"name"=>"Flowers",
				"qty"=>"1 bag"
			],
			[
				"name"=>"Any Fruits",
				"qty"=>"6"
			]
			];
		// var_dump($pujalist);
		if (isset($pujalistData['poojaList']) && !empty($pujalistData['poojaList'])) {

			$pujalist = @$pujalistData['poojaList'];
		?>

			<table class="table table-responsive table-bordered mt-4 text-center" style="background: #ffffff3b;background-image:url('<?= base_url("assets/img/white-background-vector.jpg") ?>');position: relative;background-size: contain;width:100%!important;border-collapse: collapse!important;">

				<thead class="pthead">
					<tr>
						<th class="phead" style="font-size: 23px;">✿ Puja Items ✿</th>
						<th class="phead" style="font-size: 23px;">✿ Quantity ✿</th>

					</tr>
				</thead>
				<tbody id="pujalist" class="pujalist">

					<?php foreach ($pujalist as $item) {

						echo '<tr><td>' . $item['name'] . '</td><td> <span id="event_name">' . $item['qty'] . '</span></td></tr>';
					} ?>
				</tbody>
			</table>
		<?php } else {
			echo '<h5 class="py-4" style="color: var(--main-color-new-theme)e0; font-weight: 600;">Puja List not found!</h5>';
		?>
			<!-- <table class="table table-responsive table-bordered mt-4 text-center" style="background: #ffffff3b;background-image:url('<?= base_url("assets/img/white-background-vector.jpg") ?>');position: relative;background-size: contain;width:100%!important;border-collapse: collapse!important">

<thead class="pthead">
    <tr>
        <th class="phead" style="font-size: 23px;">✿ Puja Items ✿</th>
        <th class="phead" style="font-size: 23px;">✿ Quantity ✿</th>

    </tr>
</thead>
<tbody id="pujalist" class="pujalist">
<tr>
        <th class="phead" style="font-size: 23px;">✿ Puja Items ✿</th>
        <th class="phead" style="font-size: 23px;">✿ Quantity ✿</th>

    </tr>
</tbody>
</table> -->
		<?php
		}

		?>
	</div>


	<script>
		document.getElementById('downloadPdf').addEventListener('click', function() {
			// Select the content to convert
			const element = document.getElementById('PdfPrintSection');

			// Configure and generate the PDF
			const options = {
				margin: 1,
				filename: '<?= str_replace(" ", "-", $serviceNamePDF) ?>.pdf',
				image: {
					type: 'jpeg',
					quality: 0.98
				},
				html2canvas: {
					scale: 2
				},
				jsPDF: {
					unit: 'in',
					format: 'letter',
					orientation: 'portrait'
				}
			};

			html2pdf().set(options).from(element).save();
		});
	</script>
</body>

</html>