<?php $this->load->view('includes/head') ?>
<?php $this->load->view('includes/topbar') ?>
<?php $this->load->view('includes/header') ?>
<style>
	.card {
		height: 100%;
		margin: 15px;
		/* Card ke aas-paas spacing */
		box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
		/* Thoda shadow for better visibility */
	}

	.card img {
		object-fit: cover;
		height: 300px;
	}

	.card-header {
		min-height: 60px;
	}

	.container-lg {
		margin-top: 30px;
		/* Top margin for the container */
		margin-bottom: 30px;
		/* Bottom margin for the container */
	}

	.row {
		margin-left: -10px;
		/* Row ke andar spacing adjust */
		margin-right: -10px;
	}

	.col-container {
		padding: 10px;
		/* Columns ke beech space */
	}
</style>

<?php
$header_data = getWebSyncsData('Header Settings', 'headerSettings', '');
$currencySymbol = getCurrencySymbol(); ?>
<?php
// var_dump($bookList);
?>
<div class="container-lg">
	<div class="row" id="books">
		<?php
		$session_data = @$this->session->userdata('books_cart');
		foreach ($bookList as $book) {
		?>

			<div class="col-lg-4 col-container">
				<div class="card  border border-warning my-3">
					<div class="card-header bg-danger">
						<h5 class="text-white bold my-2 text-center"><?= $book->refDataName ?>
						</h5>
					</div>
					<img src="<?= ApiBaseUrl()['url'] . $book->image ?>" class="card-img-top bg-light pt-2" alt="...">
					<div class="card-footer">
						<div class="row">
							<div class="col-sm-12">
								<div class="res-amount" style="">


									<div class="quantity-container" style="display:inline-flex">

										<button class="minus-btn" id="minus-btn<?= $book->_id ?>" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;height: 30px;width: 30px;padding:0px!important;" onclick="quantityMinusFunction('<?= $book->_id ?>')">-</button>

										<input type="number" value="1" min="1" class="quantity-input" readonly id="quantity-input<?= $book->_id ?>" style="width: 30px;text-align: center;height: 30px;">

										<button class="plus-btn" id="plus-btn<?= $book->_id ?>" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;height: 30px;width: 30px;padding:0px!important;" onclick="quantityPlusFunction('<?= $book->_id ?>')">+</button>

									</div>

									<span style="font-size:20px!important;font-weight:bold; " id="Totalprice_<?= $book->_id ?>">$&nbsp;<?= price_format($book->unitPrice, 2) ?></span>
									<div class="form-check" style="justify-content: center; display: flex;">
										<input type="checkbox" id="checkbox_<?= $book->_id ?>" <?= ( isset($session_data['ids']) &&(in_array($book->_id, $session_data['ids'])) ? 'checked' : '')?> class="form-check-input" value="<?= $book->_id ?>" data-id="<?= $book->_id ?>" data-category="<?= $book->menuCategory?>" data-service-category="TEMPLE SHOP" cart_category="BOOKS" data-service-type="<?= $book->refDataCode?>" data-service-name="<?= $book->refDataName ?>" data-price="<?= $book->unitPrice ?>" data-description="<?= $book->description ?>" booking_type="PAY NOW" data-image="<?= $book->image ?>" onchange="addTocart()" name="services_id[]" includesankalpam="NO" available_count="" style="padding: 11px !important;border-radius: 7px;margin-right: 0px;" is_date_required="NO" is_time_required="" is_membership_discount="NO" membership_discount_amt="" data-servicedesc="" data-serviceoccurrencesno="" data-start-time="" data-start-date="" data-end-date="" data-end-time="" data-bookinglimitperday="0" data-daytype="" cutofftime="" data-holdingdates="" isdietyselected="NO" disclaimertext="">
									</div>
								</div>
							</div>
						</div>
						<!-- <a href="https://square.link/u/KdNsqTHP" target="_blank" class="btn btn-danger" rel="nofollow">$11 Buy Now</a> -->
					</div>
				</div>
			</div>
		<?php
		}
		?>
	</div>
</div>


<?php $this->load->view('includes/footer') ?>
<?php $this->load->view('includes/script') ?>
<script>
	function quantityMinusFunction(id) {

		var totalPrice = 0;
		var init_qty = parseInt($('#quantity-input' + id).val());
		if (init_qty > 1) {
			init_qty = init_qty ? parseInt(init_qty) - 1 : 0;

			$('#quantity-input' + id).val(init_qty);
			$("#Totalprice_" + $("#checkbox_" + id).attr('data-id')).html("<?= $currencySymbol; ?>&nbsp;" + (parseFloat($("#checkbox_" + id).attr('data-price')) * init_qty).toFixed(2));
		}

		addTocart();
	}

	function quantityPlusFunction(id) {
		var totalPrice = 0;
		var init_qty = parseInt($('#quantity-input' + id).val());

		init_qty = init_qty ? parseInt(init_qty) + 1 : 0;
		$('#quantity-input' + id).val(init_qty);
		$("#Totalprice_" + $("#checkbox_" + id).attr('data-id')).html("<?= $currencySymbol; ?>&nbsp;" + (parseFloat($("#checkbox_" + id).attr('data-price')) * init_qty).toFixed(2));
		addTocart();

	}

	function addTocart() {

		var totalPrice = 0;
		var totalAmount = [];
		var ids = [];
		var qty = [];
		var serviceName = [];
		var description = [];
		var image = [];
		// var startDate = [];
		// var date = [];
		var zeroAllowInd = [];
		var carryOutPrice = [];
		var menuCategory = [];
		var carryout = [];
		var serviceCategory = [];
		var serviceType = [];
		var serviceAmount = [];
		// var time = [];
		var day = [];


		var addtoCartStatus = true;


		$('input[name="services_id[]"]:checked').each(function() {
			id = $(this).attr('data-id');

			loader.on();

			var init_qty = parseInt($("#quantity-input" + id).val());
			ids.push($(this).attr('data-id'));
			
			init_qty = (init_qty ? parseInt(init_qty) : 1);
			qty.push(init_qty);
			serviceName.push($(this).attr('data-service-name'));
			image.push($(this).attr('data-image'));
			description.push($(this).attr('data-description').replace(/['"`]/g, ''));
			zeroAllowInd.push("NO");
			carryOutPrice.push("");
			carryout.push("");
			menuCategory.push($(this).attr('data-category'));
			serviceCategory.push($(this).attr('data-service-category'));
			serviceType.push($(this).attr('data-service-type'));
			serviceAmount.push($(this).attr('data-price'));
			day.push("");
			
			totalPrice = (parseFloat(totalPrice) + (parseFloat($(this).attr('data-price')) * init_qty));
			totalAmountp = ((parseFloat($(this).attr('data-price')) * init_qty));

			$("#Totalprice_" + $(this).attr('data-id')).html("<?= $currencySymbol; ?>&nbsp;" + (parseFloat($(this).attr('data-price')) * init_qty).toFixed(2));
			totalAmount.push(totalAmountp);
			
			

		});


		if (addtoCartStatus == false) {
			loader.off();
			return false;
		} else {
			
			$(".allPrice").text((totalPrice / 1).toFixed(2));
		}

		$.ajax({
			type: "POST",
			url: "<?= base_url('About_Temple/bookAddCart'); ?>",
			dataType: 'json',
			data: {
				ids: ids,
				totalPrice: totalPrice,
				totalAmount: totalAmount,
				qty: qty,
				serviceName: serviceName,
				image: image,
				description: description,
				// startDate: startDate,
				// date: date,
				zeroAllowInd: zeroAllowInd,
				carryOutPrice: carryOutPrice,
				carryout: carryout,
				menuCategory: menuCategory,
				serviceCategory: serviceCategory,
				serviceType: serviceType,
				serviceAmount: serviceAmount,
				// time: time,
				day: day
			},
			success: function(result) {
				console.log(result);
				$("#includeSankalpamModal").val(result.includeSankalpam);
				loader.off();
				updateCartCount();
			}
		});


	}
</script>
