<?php $this->load->view('admin/includes/head'); ?>
<?php $this->load->view('admin/includes/sidebar'); ?>
<?php $this->load->view('admin/includes/topbar'); ?>
<style>
	#myDonations_filter {
		display: none !important;
	}

	#customSearchInput {
		margin-top: 8px !important;
		border: 1px solid !important;
	}

	#myDonations td {
		padding: 8px;
		text-align: center;
		/* border: 1px solid #ddd;  */
		white-space: normal;
		/* Allow text to wrap */
		word-wrap: break-word;
		/* Break long words to the next line */
		overflow-wrap: break-word;
		/* Another property to allow breaking words */
		max-width: 500px;
		/* Set a maximum width to control cell size */
		min-width: fit-content;
	}

	.service-name {
		max-width: 500px;
		min-width: 300px;
		white-space: normal;
		/* Allow text to wrap */
		word-wrap: break-word;
		/* Break long words to the next line */
		overflow-wrap: break-word;
		/* Allow breaking words */
	}

	#inputContainer input::placeholder {
		color: #888;
		font-style: italic;
	}

	#yearInput {
		height: 24px !important;
	}

	.ml-10 {
		margin-left: 10px !important;
	}

	.loader-container {
		display: flex;
		justify-content: center;
		align-items: center;
		height: 200px;
		/* Adjust as needed */
	}
</style>
<!-- Main content-->
<div class="container px-2 mt-4">
	<?php

	$success = $this->session->flashdata('success');
	$failure = $this->session->flashdata('failure');

	echo $success ?  $success :  $failure;

	?>
	<div class="row">
		<div class="col-sm-12 d-flex">
			<label for="typeSelect">Select Date:</label>
			<select id="typeSelect" onchange="updateInputField();getFilterData()" class="ml-10">
				<!-- <option value="year">Year</option> -->
				<option value="month">Month</option>
				<option value="date">Date</option>
			</select>

			<div id="inputContainer">
				<!-- Yeh dynamic inputs yahaan JavaScript se add honge -->
			</div>

		</div>
		<div class="colsm-12">

			<button id="searchIcon" class="btn btn-light">
				<i class="fa fa-search"></i> <!-- Font Awesome search icon -->
			</button>

			<!-- Hidden search input -->
			<input type="text" id="customSearchInput" class="form-control" placeholder="Search..." style="display:none;">

		</div>
	</div>
	<div class="table-responsive" id="TableData">



	</div>

</div>
<!-- End Main content-->
<script>
	$(document).ready(function() {
		$("#heading").text('My Payments');
		// $('#myDonations').DataTable({
		// 	order: [
		// 		[0, 'desc']
		// 	],
		// 	"lengthChange": false,
		// 	"scrollX": true,
		// 	"ordering": false,
		// 	"searching": true,
		// 	language: {
		// 		emptyTable: "No Payments Available to show..",
		// 		search: ''
		// 	}
		// });
	});
	$(document).ready(function() {
		$("#myDonations_filter").css('display', 'none');
		// Hide the default DataTable search input
		// $('#myDonations_filter').hide();

		// Toggle the visibility of the custom search input when the icon is clicked
		$('#searchIcon').on('click', function() {
			$('#customSearchInput').toggle(); // Show/hide the input box
		});

		// Perform search when typing in the custom input box
		$('#customSearchInput').on('keyup', function() {
			$('#myDonations').DataTable().search($(this).val()).draw(); // Perform the search
		});
	});


	/*filert Data*/
	const typeSelect = document.getElementById('typeSelect');
	const inputContainer = document.getElementById('inputContainer');

	function updateInputField() {
		inputContainer.innerHTML = ''; // Clear previous input
		const currentDate = new Date();
		const today = currentDate.toISOString().split('T')[0]; // 'yyyy-mm-dd' format
		const currentMonth = currentDate.toISOString().split('T')[0].slice(0, 7); // 'yyyy-mm' format
		const currentYear = currentDate.getFullYear();

		if (typeSelect.value === 'year') {
			const yearSelect = document.createElement('select');
			yearSelect.id = 'yearInput';
			yearSelect.name = 'selecteddate';
			yearSelect.classList.add('ml-10'); // Add class to year select dropdown

			// Define year range (e.g., from 1900 to current year)
			for (let year = currentYear; year >= 1900; year--) {
				const option = document.createElement('option');
				option.value = year;
				option.textContent = year;
				if (year === currentYear) option.selected = true; // Set current year as selected
				yearSelect.appendChild(option);
			}

			inputContainer.appendChild(yearSelect);
			yearSelect.addEventListener('change', function() {
				getFilterData(); // Call the getFilterData function when the value changes
			});
		} else {
			let inputField = document.createElement('input');
			if (typeSelect.value === 'date') {
				inputField.type = 'date';
				inputField.name = 'selecteddate';
				inputField.placeholder = 'mm/dd/yyyy';
				inputField.classList.add('ml-10'); // Add class to date input
				inputField.value = today; // Set today's date as default selected value
			} else if (typeSelect.value === 'month') {
				inputField.type = 'month';
				inputField.name = 'selecteddate';
				inputField.placeholder = 'mm/yyyy';
				inputField.classList.add('ml-10'); // Add class to month input
				inputField.value = currentMonth; // Set current month as default selected value
			}
			inputContainer.appendChild(inputField);
			inputField.addEventListener('change', function() {
				getFilterData(); // Call the getFilterData function when the value changes
			});
		}
	}



	// Call updateInputField initially to set up the initial input field
	updateInputField();



	// console.log(nameInputValue);

	function getFilterData() {
		var nameInputValue = '';
		if (typeSelect.value === 'year') {
			nameInputValue = document.querySelector('select[name="selecteddate"]').value;
		} else {
			nameInputValue = document.querySelector('input[name="selecteddate"]').value;
		}
		// console.log(nameInputValue);
		$.ajax({
			url: '<?= base_url('Admin/Dashboard/FilterPaymentsData') ?>',
			type: 'POST',
			data: {
				selecteddate: nameInputValue,
				dateType: typeSelect.value,
			},
			beforeSend: function() {
				// Show centered loader before the AJAX request
				$("#TableData").html(`
                <div class="loader-container">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `);
			},
			success: function(data) {
				$("#TableData").html(data);
				$('#myDonations').DataTable({
					order: [
						[0, 'desc']
					],
					"lengthChange": false,
					"scrollX": true,
					"ordering": false,
					"searching": true,
					language: {
						emptyTable: "No Payments Available to show..",
						search: ''
					}
				});
			}
		});
	}
	getFilterData();


	window.addEventListener('DOMContentLoaded', event => {

// Toggle the side navigation
const sidebarToggle = document.body.querySelector('#sidebarToggle');
if (sidebarToggle) {
	// Uncomment Below to persist sidebar toggle between refreshes
	// if (localStorage.getItem('sb|sidebar-toggle') === 'true') {
	//     document.body.classList.toggle('sb-sidenav-toggled');
	// }
	sidebarToggle.addEventListener('click', event => {
		event.preventDefault();
		document.body.classList.toggle('sb-sidenav-toggled');
		localStorage.setItem('sb|sidebar-toggle', document.body.classList.contains('sb-sidenav-toggled'));
	});
}

});
</script>
</body>

</html>