<?php $this->load->view('admin/includes/head'); ?>
<?php $this->load->view('admin/includes/sidebar'); ?>
<?php $this->load->view('admin/includes/topbar'); ?>
<style>
	#myBookings_filter {
		display: none !important;
	}

	#customSearchInput {
		margin-top: 8px !important;
		border: 1px solid !important;
	}

	#myServiceRequest td {
		padding: 8px;
		text-align: center;
		/* border: 1px solid #ddd;  */
		white-space: normal;
		/* Allow text to wrap */
		word-wrap: break-word;
		/* Break long words to the next line */
		overflow-wrap: break-word;
		/* Another property to allow breaking words */
		max-width: 500px;
		/* Set a maximum width to control cell size */
		min-width: fit-content;
	}

	.service-name {
		max-width: 500px;
		min-width: 300px;
		white-space: normal;
		/* Allow text to wrap */
		word-wrap: break-word;
		/* Break long words to the next line */
		overflow-wrap: break-word;
		/* Allow breaking words */
	}

	.service-date-time {
		max-width: 200px;
		min-width: 200px;
	}

	#inputContainer input::placeholder {
		color: #888;
		font-style: italic;
	}

	#yearInput {
		height: 24px !important;
	}

	.ml-10 {
		margin-left: 10px !important;
	}

	.loader-container {
		display: flex;
		justify-content: center;
		align-items: center;
		height: 200px;
		/* Adjust as needed */
	}
	@media only screen and (max-width:360px) {
		.collapse:not(.show) {
    display: flex!important;
}
	}
</style>
<div class="container px-2 mt-4">
	<div class="row">

		<div class="col-sm-12">
			<a href="<?= base_url('admin/in-temple-bookings') ?>" class="btn btn btn-info" style="margin-top: 0px;background:var(--active-devotee-dashboard-menu)!important;">My Bookings</a>
			<?php
			if ($myServiceRequestCount > 0) {
			?>
				<a href="<?= base_url('admin/my-service-request') ?>" class="btn" style="background-color: gray;color:white;">My Service Requests </a>
			<?php } ?>

			<!-- Add a search icon button -->
			<button id="searchIcon" class="btn btn-light">
				<i class="fa fa-search"></i> <!-- Font Awesome search icon -->
			</button>

			<!-- Hidden search input -->
			<input type="text" id="customSearchInput" class="form-control" placeholder="Search..." style="display:none;">

		</div>
		<div class="container-fluid mt-2 mb-2">
			<div class="row">
				<!-- Select Dropdown -->
				<div class="col-12 col-md-3 mb-2">
					<label for="typeSelect" class="form-label">Select Date:</label>
					<select id="typeSelect" onchange="updateInputField(); getFilterData()" class="form-select">
						<option value="month">Month</option>
						<option value="date">Date</option>
					</select>
				</div>

				<!-- Dynamic Inputs will come here -->
				<div class="col-12 col-md-9" id="inputContainer">
					<!-- JavaScript will inject input fields here -->
				</div>
			</div>
		</div>
	</div>
	<div id="TableData" class="table-responsive">


	</div>

</div>
<!-- End Main content-->

<?php $this->load->view('admin/includes/footer'); ?>
<script type="text/javascript">
	/*filert Data*/
const typeSelect = document.getElementById('typeSelect');
	const inputContainer = document.getElementById('inputContainer');

	function updateInputField() {
		inputContainer.innerHTML = ''; // Clear previous input

		const currentDate = new Date();
		const today = currentDate.toISOString().split('T')[0];
		const currentMonth = today.slice(0, 7);
		const currentYear = currentDate.getFullYear();

		if (typeSelect.value === 'year') {
			const wrapper = document.createElement('div');
			wrapper.className = 'row';

			const col = document.createElement('div');
			col.className = 'col-12 col-sm-6';

			const yearLabel = document.createElement('label');
			yearLabel.textContent = 'Select Year:';
			yearLabel.setAttribute('for', 'yearInput');
			yearLabel.className = 'form-label';

			const yearSelect = document.createElement('select');
			yearSelect.id = 'yearInput';
			yearSelect.name = 'selecteddate';
			yearSelect.className = 'form-select';

			for (let year = currentYear; year >= 1900; year--) {
				const option = document.createElement('option');
				option.value = year;
				option.textContent = year;
				if (year === currentYear) option.selected = true;
				yearSelect.appendChild(option);
			}

			col.appendChild(yearLabel);
			col.appendChild(yearSelect);
			wrapper.appendChild(col);
			inputContainer.appendChild(wrapper);
			yearSelect.addEventListener('change', getFilterData);

		} else if (typeSelect.value === 'date') {
			const day = String(currentDate.getDate()).padStart(2, '0');
			const month = String(currentDate.getMonth() + 1).padStart(2, '0'); // Months are 0-based
			const year = currentDate.getFullYear();

			const newtoday = `${month}-${day}-${year}`;
			const wrapper = document.createElement('div');
			wrapper.className = 'row';

			const fromCol = document.createElement('div');
			fromCol.className = 'col-12 col-sm-6 mb-2';
			const fromLabel = document.createElement('label');
			fromLabel.textContent = 'From Date:';
			fromLabel.setAttribute('for', 'fromDate');
			fromLabel.className = 'form-label';
			const fromDate = document.createElement('input');
			fromDate.type = 'text';
			fromDate.id = 'fromDate';
			fromDate.name = 'fromDate';
			fromDate.value = newtoday;
			fromDate.className = 'form-control datepicker';
			fromCol.appendChild(fromLabel);
			fromCol.appendChild(fromDate);

			const toCol = document.createElement('div');
			toCol.className = 'col-12 col-sm-6';
			const toLabel = document.createElement('label');
			toLabel.textContent = 'To Date:';
			toLabel.setAttribute('for', 'toDate');
			toLabel.className = 'form-label';
			const toDate = document.createElement('input');
			toDate.type = 'text';
			toDate.id = 'toDate';
			toDate.name = 'toDate';
			toDate.value = newtoday;
			toDate.className = 'form-control datepicker';
			toCol.appendChild(toLabel);
			toCol.appendChild(toDate);

			wrapper.appendChild(fromCol);
			wrapper.appendChild(toCol);
			inputContainer.appendChild(wrapper);

			fromDate.addEventListener('change', getFilterData);
			toDate.addEventListener('change', getFilterData);

			$(".datepicker").datepicker({
				dateFormat: 'mm-dd-yy',
				changeMonth: true,
				changeYear: false,
				showButtonPanel: true,
				onSelect: function(dateText, inst) {
					// Format and set the selected date
					var date = $(this).datepicker('getDate');
					$(this).val($.datepicker.formatDate('mm-dd-yy', date));

					// ✅ Call your filter function
					getFilterData();
				}
			});


		} else if (typeSelect.value === 'month') {
			const wrapper = document.createElement('div');
			wrapper.className = 'row';

			const col = document.createElement('div');
			col.className = 'col-12 col-sm-6';

			const monthLabel = document.createElement('label');
			monthLabel.textContent = 'Select Month:';
			monthLabel.setAttribute('for', 'monthInput');
			monthLabel.className = 'form-label';

			const monthInput = document.createElement('input');
			monthInput.type = 'month';
			monthInput.id = 'monthInput';
			monthInput.name = 'selecteddate';
			monthInput.value = currentMonth;
			monthInput.className = 'form-control'; // ✅ Important fix

			col.appendChild(monthLabel);
			col.appendChild(monthInput);
			wrapper.appendChild(col);
			inputContainer.appendChild(wrapper);

			monthInput.addEventListener('change', getFilterData);
		}

	}

	// Call updateInputField initially to set up the initial input field
	updateInputField();


	$(document).ready(function() {


		// $("#dropdown-list").html('<div class="dropdown"><button class="btn dropdown-toggle text-white border-dark" type="button" id="filter-bookings" data-bs-toggle="dropdown" aria-expanded="false" style="background:#03396C!important">ALL</button><ul class="dropdown-menu filter-bookings" aria-labelledby="filter-bookings"><li><a class="dropdown-item" href="#" data-value="ALL">ALL</a></li><li><a class="dropdown-item" href="#" data-value="IN-TEMPLE">INSIDE TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="AWAY-TEMPLE">OUTSIDE TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="EVENTS">EVENTS</a></li>	<li><a class="dropdown-item" href="#" data-value="FACILITY">FACILITY</a></li>			</ul></div>');
		$("#dropdown-list").html('<div class="dropdown"><button class="btn dropdown-toggle text-white border-dark" type="button" id="filter-bookings" data-bs-toggle="dropdown" aria-expanded="false" style="background:#03396C!important">ALL</button><ul class="dropdown-menu filter-bookings" aria-labelledby="filter-bookings"><li><a class="dropdown-item" href="#" data-value="ALL">ALL</a></li><li><a class="dropdown-item" href="#" data-value="IN-TEMPLE">INSIDE TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="AWAY-TEMPLE">OUTSIDE TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="EVENTS">EVENTS</a></li></ul></div>');
		// $("#dropdown-list").html('<div class="dropdown"><button class="btn dropdown-toggle text-white border-dark" type="button" id="filter-bookings" data-bs-toggle="dropdown" aria-expanded="false" style="background:#03396C!important">ALL</button><ul class="dropdown-menu filter-bookings" aria-labelledby="filter-bookings"><li><a class="dropdown-item" href="#" data-value="ALL">ALL</a></li><li><a class="dropdown-item" href="#" data-value="IN-TEMPLE">IN TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="AWAY-TEMPLE">AWAY TEMPLE</a></li><li><a class="dropdown-item" href="#" data-value="EVENTS">EVENTS</a></li></ul></div>');

		// var selectedValue = 'IN-TEMPLE';
		var selectedValue = 'ALL';

		$("#filter-bookings").text("IN TEMPLE BOOKINGS"); // set initial text

		$('.dropdown-menu a').click(function(e) {
			e.preventDefault(); // prevent link from navigating

			var selectedValue = $(this).data('value');
			$("#filter-bookings").text($(this).text()).attr('data-value', selectedValue); // update button text
			var nameInputValue = '';
			if (typeSelect.value === 'year') {
				nameInputValue = document.querySelector('select[name="selecteddate"]').value;
			} else {
				nameInputValue = document.querySelector('input[name="selecteddate"]').value;
			}
			$.ajax({
				url: '<?= base_url('admin/filterBookingData/') ?>' + selectedValue,
				type: 'POST',
				data: {
					aspectType: selectedValue,
					selecteddate: nameInputValue,
					dateType: typeSelect.value,
				},
				beforeSend: function() {
					// Show centered loader before the AJAX request
					$("#TableData").html(`
                <div class="loader-container">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `);
				},
				success: function(data) {
					$("#TableData").html(data);
					$('#myBookings').DataTable({
						order: [
							[0, 'desc']
						],
						"lengthChange": false,
						"scrollX": true,
						"ordering": false,
						"searching": true,
						language: {
							emptyTable: "No Bookings Available to show..",
							search: ''
						}
					});
					if (selectedValue == 'ALL') {
						$("#heading").text('My Bookings');
					}
					if (selectedValue == 'IN-TEMPLE') {
						$("#heading").text('Inside Temple');
					}
					if (selectedValue == 'AWAY-TEMPLE') {
						$("#heading").text('Outside Temple');
					}
					if (selectedValue == 'EVENTS') {
						$("#heading").text('Events');
					}
					if (selectedValue == 'FACILITY') {
						$("#heading").text('Facility');
					}
				}
			});
		});

		$('.dropdown-menu a[data-value="' + selectedValue + '"]').trigger('click'); // trigger click on initial value



	});


	function show_booking_status(service, status) {

		var status = status;
		var service = service;

		Swal.fire({
			title: 'Booking Status',
			text: 'Your service "' + service + '" has been "' + status + '".',
			type: "success",
			confirmButtonText: 'OK',
			confirmButtonColor: '#008080',
		}).then((result) => {
			window.location.reload();
		});
	}

	function CancelBooking(id) {

		var id = id;
		Swal.fire({
			title: 'Do you want to cancel this Booking?',
			showDenyButton: false,
			showCancelButton: true,
			confirmButtonText: 'Yes',
			denyButtonText: 'No',
		}).then((result) => {
			if (result.isConfirmed) {
				loader.on();
				$.ajax({
					url: '<?= base_url('admin/Dashboard/CancelBooking/') ?>' + id,
					type: 'POST',
					dataType: "json",
					success: function(data) {
						loader.off();
						if (data['statusCode'] == 1) {
							Swal.fire({
								title: 'Booking has been cancelled',
								type: "success",
								confirmButtonText: 'OK',
								confirmButtonColor: '#008080',
							}).then((result) => {
								window.location.reload();
							});
						} else {
							Swal.fire({
								title: 'Something went wrong!',
								type: "alert",
								confirmButtonText: 'OK',
								confirmButtonColor: '#008080',
							}).then((result) => {
								window.location.reload();
							});
						}
					}
				});
			} else if (result.isDenied) {
				Swal.fire('Changes are not saved', '', 'info')
			}
		});
	}

	$(document).ready(function() {
		$("#myBookings_filter").css('display', 'none');
		// Hide the default DataTable search input
		// $('#myBookings_filter').hide();

		// Toggle the visibility of the custom search input when the icon is clicked
		$('#searchIcon').on('click', function() {
			$('#customSearchInput').toggle(); // Show/hide the input box
		});

		// Perform search when typing in the custom input box
		$('#customSearchInput').on('keyup', function() {
			$('#myBookings').DataTable().search($(this).val()).draw(); // Perform the search
		});
	});


	// Ensure this function is accessible globally
	function toggleChildRows(button) {
		var parentRow = $(button).closest("tr");
		var childRows = parentRow.nextUntil(".parent-row");

		// Show/hide child rows
		childRows.toggle();

		// Display alert message based on visibility
		if (childRows.is(":visible")) {
			// alert('Hide Details');
			$(button).text("Hide Details");
		} else {
			// alert('Show Details');
			$(button).text("Show Details");
		}
	}

	function getFilterData() {
		var selectedValue1 = $("#filter-bookings").data('value');
		var requestData = {
			aspectType: selectedValue1,
			dateType: typeSelect.value,
		};

		if (typeSelect.value === 'year') {
			requestData.selecteddate = document.getElementById('yearInput')?.value || '';
		} else if (typeSelect.value === 'date') {
			requestData.selecteddate = document.getElementById('fromDate')?.value || '';
			requestData.selectedenddate = document.getElementById('toDate')?.value || '';
		} else if (typeSelect.value === 'month') {
			requestData.selecteddate = document.getElementById('monthInput')?.value || '';
		}

		console.log("Request Data:", requestData);

		$.ajax({
			url: '<?= base_url('admin/filterBookingData/') ?>' + selectedValue1,
			type: 'POST',
			data: requestData,
			beforeSend: function() {
				$("#TableData").html(`
                <div class="loader-container">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            `);
			},
			success: function(data) {
				console.log("Received Data:", data); // Debugging line

				$("#TableData").html(data);

				if ($.fn.DataTable.isDataTable('#myBookings')) {
					$('#myBookings').DataTable().destroy(); // Destroy old instance
				}

				$('#myBookings').DataTable({
					order: [
						[0, 'desc']
					],
					"lengthChange": false,
					"scrollX": true,
					"ordering": false,
					"searching": true,
					language: {
						emptyTable: "No Bookings Available to show..",
						search: ''
					}
				});
			}

		});
	}
</script>


</body>

</html>