<?php $this->load->view('includes/head') ?>
<?php $this->load->view('includes/topbar') ?>
<?php $this->load->view('includes/header') ?>

<style type="text/css">
    @import url(//fonts.googleapis.com/css?family=Montserrat:300,500);
    
    .priest-section {
        /* background-color: #A63030 !important; */
        background: linear-gradient(to top, var(--main-color-new-theme), var(--main-color-new-theme));
        padding: 7px;
        margin-bottom: 40px;
        text-align: center;
        border-radius: 8px;
    }

    .priest-section h5 {
        color: #ffffff;
        font-size: 20px;
        font-weight: bold;
        margin: 0;
    }

    .priest-image {
        height: 195px;
        width: 200px;
        border-radius: 50%;
        border: 4px solid #A63030;
        /* object-fit: cover; */
    }

    .priest-description {
        color: #333;
        line-height: 1.6;
        text-align: justify;
        font-size: 16px;
    }

    .priest-speaks {
        font-size: 16px;
        font-weight: 500;
        color: #555;
    }

    @media (max-width: 768px) {
        .row {
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .priest-image {
            width: 150px;
            height: 150px;
            margin-bottom: 10px;
        }

        .priest-description, .priest-speaks {
            /* text-align: center; */
        }
    }
</style>

<main id="main">
    <!-- ======= About Committee Section ======= -->
   <section style="background-size: auto;">
    <div class="responsive-container">
        <!-- Heading Section -->
        <div class="priest-heading">
            <h1 style="font-size: 2.5rem; color: #A63030; text-align: center; margin-bottom: 27px !important; margin-top: 0px !important; font-weight: bolder">
                Our Priests Information
            </h1>
            <h2 style="font-size: 1.5rem; color: #333; text-align: center; margin-bottom: 20px !important;">
        For Priest Services Contact Pramod Bommaraju - 847-915-1936
    </h2>
        </div>

        <?php foreach ($priest_data->data as $item) { ?>
            <!-- Priest Information Section -->
            <div class="container">
                <div class="priest-section" style="padding: 1px; background-color: #A63030;">
                    <h5 style="padding-top: 3px;"><?= $item->refDataName; ?></h5>
                </div>
                <div class="row">
                    <div class="col-md-4 col-lg-3" style="text-align: center;">
                        <img src="<?= ApiBaseUrl()['url'] . $item->image ?>" alt="<?= $item->refDataName; ?>" class="img-fluid priest-image">
                    </div>
                    <div class="col-md-8 col-lg-9">
                        <p class="priest-description" style="line-height: 37px !important; font-family: emoji;">
                            <?php if (isset($item->description)) { ?>
                                <?= $item->description; ?>
                            <?php } else { ?>
                                Description is not available.
                            <?php } ?>
                        </p>

                        <!-- <?php if (isset($item->phone)) { ?>
                            <p class="priest-phone">
                                <strong style="font-weight: bold; font-family: emoji;">Phone:</strong> <?= base64_decode($item->phone); ?>
                            </p>
                        <?php } ?> -->

                        <?php if (isset($item->spokenLanguages)) { ?>
                            <p class="priest-speaks">
                                <strong style="font-weight: bold; font-family: emoji;">Speaks:</strong> <?= $item->spokenLanguages; ?>
                            </p>
                        <?php } else { ?>
                            <p class="priest-speaks">
                                <strong style="font-weight: bold; font-family: emoji;">Speaks:</strong> Information not available.
                            </p>
                        <?php } ?>
                    </div>
                </div>
                <br>
            </div>
        <?php } ?>
    </div>
</section>

    <!-- End About Committee Section -->
</main><!-- End #main -->

<script type="text/javascript">
    $(document).ready(function() {
        window.scrollTo({ top: 225, behavior: 'smooth' });
    });
</script>

<?php $this->load->view('includes/footer') ?>
<?php $this->load->view('includes/script') ?>
