<?php

defined('BASEPATH') or exit('No direct script access allowed');

function ApiBaseUrl()
{
	$data = array(
		'url' => "https://aspgen.vaaptech.com:9000/",
		// 'url' => "https://aspgenpre.vaaptech.com:9000/",
		// 'url' => "http://localhost:3000/",
		'productID' => "62c807133d9ee4045ab78d4d",
		// Production Mode 
		'clientID' => "648b6aa39e56f22df3f011bb"
	);
	return $data;
}



function GetProjectName()
{
	if (PROJECT_NAME !== null && PROJECT_NAME != '') {
		return PROJECT_NAME;
	} else {
		return 'Chatwala';
	}
}
function addAnnualRegistrations()
{
	$data = array(
		'url' => "api/event/addAnnualRegistrations",
		'moduleName' => "Annual Registration",
		'aspectType' => "annualRegistrations"
	);
	return $data;
}

function getclientInfoById()
{
	$CI = &get_instance();
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/webgen/getclientInfoById');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\n         
		\"_id\": \"" . ApiBaseUrl()['clientID'] . "\"\n       
	}");

	$token = $CI->session->userdata('token');
	$headers = array(
		'Authorization: Bearer ' . $token,
		'Content-Type: application/json',
	);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return json_decode($result, true);
}

function customerLogin()
{
	$data = array(
		'url' => "api/customerDetails/customerLoginWeb",
		'moduleName' => "Contacts"
	);
	return $data;
}
function refundRequest()
{
	$data = array(
		'url' => "api/payment/refundRequest"
	);
	return $data;
}



function GetMeetings()
{
	$data = array(
		'url' => "api/appgen/filterAPI",
		'moduleName' => "Meeting"
	);
	return $data;
}




function getMeetingData($FilterDate = '')
{

	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');
	$response = getUserDetails();
	$managementCategory = @$response->data[0]->managementCategory;



	if (!empty($FilterDate)) {


		if ($FilterDate === 'currentMonth') {
			// Get the current month's start date
			$startDate = date('01/m/Y');

			// Get the current month's end date
			$endDate = date('t/m/Y');


			$query = array(
				"refDataName1" => $managementCategory,
				"aspectType" => "meetingProfile",
				"refDataName2" => array(
					'$lte' => $endDate,
					'$gte' => $startDate
				)
			);
		} else {
			$query = array(
				"refDataName1" => $managementCategory,
				"aspectType" => "meetingProfile",
				"refDataName2" => array(
					'$lte' => $FilterDate,
					'$gte' => $FilterDate
				)
			);
		}
	} else {
		$query = array(
			"refDataName1" => $managementCategory,
			"aspectType" => "meetingProfile"
		);
	}

	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => GetMeetings()['moduleName'],
			"aspectType" => "meetingProfile",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"userName" => $userName,
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . GetMeetings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
	$token = $CI->session->userdata('token');
	$headers = array(
		'Authorization: Bearer ' . $token,
		'Content-Type: application/json',
	);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return $response = json_decode($result);
}



function getAllMeetingData()
{
	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');
	$response = getUserDetails();
	$managementCategory = @$response->data[0]->managementCategory;



	$query = array(
		"refDataName1" => $managementCategory,
		"aspectType" => "meetingProfile"
	);


	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => GetMeetings()['moduleName'],
			"aspectType" => "meetingProfile",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"userName" => $userName,
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . GetMeetings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
	$token = $CI->session->userdata('token');
	$headers = array(
		'Authorization: Bearer ' . $token,
		'Content-Type: application/json',
	);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return $response = json_decode($result);
}


function GetMeetingsById($id)
{

	$CI = &get_instance();

	$id = $id;
	$response = getUserDetails();
	$managementCategory = @$response->data[0]->managementCategory;

	$query = array(
		"aspectType" => "meetingProfile",
		"insertedId" => $id,
		"refDataName1" => $managementCategory
	);
	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => "Meeting",
			"aspectType" => "meetingProfile",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_URL,  ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
	$token = $CI->session->userdata('token');
	$headers = array(
		'Authorization: Bearer ' . $token,
		'Content-Type: application/json',
	);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}



function getDeities()
{

	$query = array(
		"aspectType" => "Diety Directory"
	);
	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => "Diety",
			"aspectType" => "Diety Directory",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_URL,  ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);


	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}



function GetAttendancedata($memberDirectory, $meetingname)
{

	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Meeting Attendance Register\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"meetingAttendanceRegister\",     
		\"query\": {   \"aspectType\": \"meetingAttendanceRegister\", \"Parent.refDataName1\": \"" . $memberDirectory . "\", \"Parent.refDataName\": \"" . $meetingname . "\"},       
		\"skip\": 0,    
		\"next\": 1024
	} 
}");

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}


function GetMeetingMinutes($memberDirectory, $meetingname)
{

	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Meeting Minutes\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"meetingMinutes\",     
		\"query\": {   \"aspectType\": \"meetingMinutes\", \"Parent.refDataName1\": \"" . $memberDirectory . "\", \"Parent.refDataName\": \"" . $meetingname . "\"},       
		\"skip\": 0,    
		\"next\": 1024
	} 
}");

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}

function getMemberDirectoryByGroup($group, $filterYear)
{

	if ($filterYear != '') {


		// Set start date to October 1st of the 
		$startDate = date('m/d/Y', strtotime("$filterYear-10-01"));
		// Set end date to September 30th of the 
		$endDate = date('m/d/Y', strtotime("$filterYear-09-30 +1 year"));


		$query = array(
			'aspectType' => 'managementDirectory',
			"managementCategory" => $group,

			'effDate' => array(
				'$lte' => $startDate,
				'$gte' => $endDate
			)
		);
	} else {

		$startDate = date('01/m/Y');
		$endDate = date('t/m/Y');

		$query = array(
			"aspectType" => "managementDirectory",
			"managementCategory" => $group,
			'effDate' => array(
				'$lte' => $endDate,
				'$gte' => $startDate
			)
		);
	}


	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => "Management Directory",
			"aspectType" => "managementDirectory",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);


	$data_string = json_encode($data);

	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}

function getManagementsDirectory($filter = '')
{

	if ($filter != '' &&  $filter != 'SELECT YEAR') {


		// Set start date to October 1st of the 

		$startDate = date('d/m/Y', strtotime("$filter-10-01 -1 year"));
		// Set end date to September 30th of the 
		$endDate = date('d/m/Y', strtotime("$filter-09-30"));



		$query = array(
			'aspectType' => 'managementDirectory',
			'effDate' => array(
				'$gte' => $startDate,
				'$lte' => $endDate
			)
		);
	} else {

		$startDate = date('01/10/Y', strtotime('-1 year'));
		$endDate = date('t/m/Y');


		$query = array(
			"aspectType" => "managementDirectory",
			'effDate' => array(
				'$gte' => $startDate,
				'$lte' => $endDate
			)
		);
	}


	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => "Management Directory",
			"aspectType" => "managementDirectory",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);

	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}

function getCommitteeBOD($filter = '')
{

	if ($filter != '' &&  $filter != 'SELECT YEAR') {


		// Set start date to October 1st of the 

		$startDate = date('d/m/Y', strtotime("$filter-10-01 -1 year"));
		// Set end date to September 30th of the 
		$endDate = date('d/m/Y', strtotime("$filter-09-30"));



		$query = array(
			'aspectType' => 'managementDirectory',
			// "managementCategory" => "BOARD OF DIRECTORS",
			'effDate' => array(
				'$gte' => $startDate,
				'$lte' => $endDate
			)
		);
	} else {

		$startDate = date('01/10/Y', strtotime('-1 year'));
		$endDate = date('t/m/Y');


		$query = array(
			"aspectType" => "managementDirectory",
			// "managementCategory" => "BOARD OF DIRECTORS"
			'effDate' => array(
				'$gte' => $startDate,
				'$lte' => $endDate
			)
		);
	}


	$data = array(
		"componentConfig" => array(
			"query" => $query,
			"moduleName" => "Management Directory",
			"aspectType" => "managementDirectory",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);
	$data_string = json_encode($data);
	// var_dump($data_string);die();
	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}



function ManagementGroup()
{
	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt(
		$ch,
		CURLOPT_POSTFIELDS,
		"{\"componentConfig\": {
			\"moduleName\": \"Master Data Management\", 
			\"aspectType\": \"managementCategory\",
			\"query\":{
				\"aspectType\": \"managementCategory\"},
				\"productID\": \"" . ApiBaseUrl()['productID'] . "\", 
				\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
				\"userName\": \"" . $CI->session->userdata('refDataName') . "\", 
				\"skip\": 0, 
				\"next\":1220
			}}"
	);


	// \"managementCategory\":\"".@getUserDetails()->data[0]->managementCategory."\"

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}
// **************************************************************************************************
// **************************************************************************************************


function getPanchangamData($lat, $long, $tzone, $year, $month, $day, $hours, $minute)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, 'https://vedicrishi-horoscope-matching-v1.p.rapidapi.com/basic_panchang/');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\n  \"day\": \"" . $day . "\",\n  \"month\": \"" . $month . "\",\n  \"year\": \"" . $year . "\",\n  \"hour\": \"" . $hours . "\",\n  \"min\": \"" . $minute . "\",\n  \"lat\": \"" . $lat . "\",\n  \"lon\": \"" . $long . "\",\n  \"tzone\": \"" . $tzone . "\"\n}");

	$headers = array();
	$headers[] = 'X-Rapidapi-Host: vedicrishi-horoscope-matching-v1.p.rapidapi.com';
	// $headers[] = 'X-Rapidapi-Key: c134901be4mshe8183baaade0a64p1b5249jsnb1b2b8a71111';
	$headers[] = 'X-Rapidapi-Key: 0b6600c1a2mshcac05eb674d792ap157fcejsn532f5444948b';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return $response;
}



function addAPI()
{
	$data = array(
		'url' => "api/appgen/addAPI"
	);
	return $data;
}



function customerSignup()
{

	$data = array(
		'url' => "api/customerDetails/addCustomerDetailWeb",
		'moduleName' => "Contacts"
	);
	return $data;
}

function sendEmailOTP()
{
	$data = array(
		'url' => "api/auth/sendMemberAuthCode"
	);
	return $data;
}

function SubscribeNewsletter()
{
	$data = array(
		'url' => "api/home/addSubscription"
	);
	return $data;
}

function verifyEmailOTP()
{
	$data = array(
		'url' => "api/auth/verifyMemberCode"
	);
	return $data;
}



function addServiceCart()
{

	$data = array(
		'url' => "api/bookingService/addServiceCart"
	);
	return $data;
}

function getServiceDetailbyId()
{

	$data = array(
		'url' => "api/bookingService/getServiceDetailbyId"
	);
	return $data;
}

function updateTransactionStatus()
{

	$data = array(
		'url' => "api/bookingService/updateTransactionStatus"
	);
	return $data;
}
function filterAPI()
{
	$data = array(
		'url' => "api/appgen/filterAPI"
	);
	return $data;
}

function postAPI()
{
	$data = array(
		'url' => "api/appgen/postAPI"
	);
	return $data;
}

function addServiceRequest()
{
	$data = array(
		'url' => "api/bookingService/addServiceRequest"
	);
	return $data;
}


function sendContactEmail()
{
	$data = array(
		'url' => "api/emailSend/sendContactEmail"
	);
	return $data;
}

function sendBookingDataPdfOnMail()
{
	$data = array(
		'url' => "api/emailSend/sendBookingDataPdfOnMail"
	);
	return $data;
}


function addVolunteer()
{
	$data = array(
		'url' => "api/volunteer/addVolunteer"
	);
	return $data;
}

function getServiceAvailability()
{
	$data = array(
		'url' => "api/bookingService/getServiceAvailability"
	);
	return $data;
}


function settings()
{
	$data = array(
		'url' => "api/appsettings/setting"
	);
	return $data;
}




function formatPhoneNumber($phoneNumber)
{
	$phoneNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

	if (strlen($phoneNumber) > 10) {
		$countryCode = substr($phoneNumber, 0, strlen($phoneNumber) - 10);
		$areaCode = substr($phoneNumber, -10, 3);
		$nextThree = substr($phoneNumber, -7, 3);
		$lastFour = substr($phoneNumber, -4, 4);

		$phoneNumber = '+' . $countryCode . ' (' . $areaCode . ') ' . $nextThree . '-' . $lastFour;
	} else if (strlen($phoneNumber) == 10) {
		$areaCode = substr($phoneNumber, 0, 3);
		$nextThree = substr($phoneNumber, 3, 3);
		$lastFour = substr($phoneNumber, 6, 4);

		$phoneNumber = '' . $areaCode . '-' . $nextThree . '-' . $lastFour;
	} else if (strlen($phoneNumber) == 7) {
		$nextThree = substr($phoneNumber, 0, 3);
		$lastFour = substr($phoneNumber, 3, 4);

		$phoneNumber = $nextThree . '-' . $lastFour;
	}

	return $phoneNumber;
}

function randString($length)
{
	$charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	$str = '';
	$count = strlen($charset);
	while ($length--) {
		$str .= $charset[mt_rand(0, $count - 1)];
	}

	return strtoupper($str);
}

function slugify($string)
{
	return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string)));
}


function camelCase($str)
{
	$str = ucwords(strtolower($str));
	return $str;
}



function CheckEmptyNullVar($val = '')
{
	if ($val == '' || $val == 'null') {
		return '';
	} else {
		return $val;
	}
}


function dateFormat($value)
{
	return date("jS M, Y", strtotime($value));
}
function numberFormat($value = '')
{
	$value = $value ? $value : 0;
	return number_format($value, 2);
}



function format_event_date($start_date = '', $end_date = '', $start_time = '', $end_time = '')
{
	// Convert US date format to DateTime object
	if (!empty($start_date)) {
		$start_date = DateTime::createFromFormat('m/d/Y', $start_date);
	} else {
		$start_date = '';
	}
	if (!empty($end_date)) {
		$end_date = DateTime::createFromFormat('m/d/Y', $end_date);
	} else {
		$end_date = '';
	}

	// Convert start and end times to DateTime object
	if (!empty($start_time)) {
		$start_time = DateTime::createFromFormat('g:i A', $start_time);
	} else {
		$start_time = '';
	}
	if (!empty($end_time)) {
		$end_time = DateTime::createFromFormat('g:i A', $end_time);
	} else {
		$end_time = '';
	}

	// Format the date range string
	$date_range = '';
	if ($start_date && $end_date) {
		// If start and end dates are in the same month and year
		if ($start_date->format('mY') == $end_date->format('mY')) {
			$start_day = $start_date->format('d');
			$end_day = $end_date->format('d');
			// If the start and end days are the same, only show one day
			if ($start_day == $end_day) {
				$date_range = $start_date->format('M d');
			} else {
				$date_range = $start_date->format('M d') . ' - ' . $end_date->format('d');
			}
		} else {
			$date_range = $start_date->format('M d') . ' - ' . $end_date->format('M d');
		}
	} else {
		// If either start or end date is missing
		$date_range = ($start_date ? $start_date->format('M d') : '') . ($end_date ? ' - ' . $end_date->format('M d') : '');
	}

	// Format the time range string
	if (($end_time ? $end_time->format('A') : '') == ($start_time ? $start_time->format('A') : '')) {
		$time_range = ($start_time ? $start_time->format('g:i') : '') . ($end_time ? ' - ' . $end_time->format('g:i A') : '');
	} else {
		$time_range = ($start_time ? $start_time->format('g:i A') : '') . ($end_time ? ' - ' . $end_time->format('g:i A') : '');
	}

	// Combine date and time strings and return
	return ($date_range ? $date_range : '') . ($time_range ? ($date_range ? ' | ' . $time_range : $time_range) : '');
}


function filterValidData($data)
{
	// Check if endDate is not empty
	if (!empty($data["endDate"])) {
		$endDateTimestamp = strtotime($data["endDate"]);
		$currentTimestamp =  strtotime(date('m/d/Y'));

		// If endDate is not expired, return the data
		if ($endDateTimestamp >= $currentTimestamp) {
			return 1;
		}
	} elseif (!empty($data["startDate"])) {
		// If endDate is empty but startDate is not, check startDate
		$startDateTimestamp = strtotime($data["startDate"]);
		$currentTimestamp = strtotime(date('m/d/Y'));

		// If startDate is not expired, return the data
		if ($startDateTimestamp >= $currentTimestamp) {
			return 1;
		}
	} else {
		// If both startDate and endDate are empty, the data is valid
		return 1;
	}

	// If none of the conditions are met, return null (invalid data)
	return 0;
}


function getFullPaymentSettings()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"action\": \"getClientSetting\",   
		\"productId\":\"" . ApiBaseUrl()['productID'] . "\",
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\"
	}");

	// $token = $this->session->userdata('token');
	$headers = array();
	// $headers[] = 'Authorization: Bearer '.$token.'';
	$headers[] = 'Content-Type: application/json';



	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return json_decode($result, true);
}

function getPaymentGatewaySettings()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"action\": \"getClientSetting\",   
		\"productId\":\"" . ApiBaseUrl()['productID'] . "\",
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\"
	}");

	// $token = $this->session->userdata('token');
	$headers = array();
	// $headers[] = 'Authorization: Bearer '.$token.'';
	$headers[] = 'Content-Type: application/json';



	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return @$response['result']['data'][0]['paymentGatewaySettings'][1]['paymentGateway'][0];
}


function SettingsApi()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"action\": \"getClientSetting\",   
		\"productId\":\"" . ApiBaseUrl()['productID'] . "\",
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\"
	}");

	// $token = $this->session->userdata('token');
	$headers = array();
	// $headers[] = 'Authorization: Bearer '.$token.'';
	$headers[] = 'Content-Type: application/json';



	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return @$response;
}



function GeneralSettings()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"action\": \"getClientSetting\",   
		\"productId\":\"" . ApiBaseUrl()['productID'] . "\",
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\"
	}");

	// $token = $this->session->userdata('token');
	$headers = array();
	// $headers[] = 'Authorization: Bearer '.$token.'';
	$headers[] = 'Content-Type: application/json';



	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return @$response['result']['data'][0]['generalSetting'];
}


function getEventDisplayGroups($serviceTypes)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	$url = ApiBaseUrl()['url'] . filterAPI()['url'];

	$data = array(
		'componentConfig' => array(
			'query' => array(
				'aspectType' => 'eventDisplayGroup',
				'eventType' => $serviceTypes,
				'status' => 'ACTIVE'
			),
			'moduleName' => 'Master Data Management',
			'aspectType' => 'eventDisplayGroup',
			'productID' => ApiBaseUrl()['productID'],
			'clientID' => ApiBaseUrl()['clientID'],
			'skip' => 0,
			'next' => 1000
		)
	);

	$headers = array(
		'Content-Type: application/json'
	);

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error: ' . curl_error($ch);
	}

	curl_close($ch);

	$response = json_decode($result);

	return json_decode(json_encode($response->data), true);
}



function sortBySequenceId($array)
{
	$sequenceIds = array();
	foreach ($array as $event) {
		$sequenceId = isset($event['sequenceId']) ? $event['sequenceId'] : PHP_INT_MAX;
		$sequenceIds[] = $sequenceId;
	}
	array_multisort($sequenceIds, SORT_ASC, $array);

	return $array;
}


function checkServiceAvailability($isAvailable, $data)
{
	if ($isAvailable == 0) {
		return 0;
	} else if ($isAvailable == 1) {
		return 1;
	} else if ($isAvailable == 2) {

		// 	echo  date('h:i A').'    =   ';
		// echo $data['timedStartTime'].'    =   ';
		// echo  $data['timedEndTime'];
		$currentTime = strtotime(date('h:i A'));
		$startTime = strtotime($data['timedStartTime']);
		$endTime = strtotime($data['timedEndTime']);
		// Check if the current time is within the time range
		if ($currentTime >= $startTime && $currentTime <= $endTime) {
			return 2;
		}
		return 0;
	} else if ($isAvailable == 3) {

		if (isset($data['AvailableCount']) && $data['AvailableCount'] > 0) {
			return 3;
		} else {
			return 1;
		}
	}
	return 0;
}

function checkServiceAvailabilityObjectType($isAvailable, $data)
{
	if ($isAvailable == 0) {
		return 0;
	} else if ($isAvailable == 1) {
		return 1;
	} else if ($isAvailable == 2) {

		// 	echo  date('h:i A').'    =   ';
		// echo $data->timedStartTime.'    =   ';
		// echo  $data->timedEndTime;
		$currentTime = strtotime(date('h:i A'));
		$startTime = strtotime($data->timedStartTime);
		$endTime = strtotime($data->timedEndTime);
		// Check if the current time is within the time range
		if ($currentTime >= $startTime && $currentTime <= $endTime) {
			return 2;
		}
		return 0;
	} else if ($isAvailable == 3) {

		if (isset($data->AvailableCount) && $data->AvailableCount > 0) {
			return 3;
		} else {
			return 1;
		}
	}
	return 0;
}

function GetChildEventByParentEvent($ParentEvent, $serviceTypes, $serviceCategoryTypes, $session_data)
{
	

	$CI = &get_instance();

	$eventGroups = getEventDisplayGroups($serviceTypes);
	$eventGroups = sortBySequenceId($eventGroups);
	$deities_data = getWebSyncsData('Master Data Management', 'deity', '');



	$html = '';
	if (!empty($eventGroups)) {

		$html .= '<div id="scrl-container" class="row">';
		foreach ($eventGroups as $key => $value) {

			$html .= '<div class="serviceSearch col-md-4 mt-3" id="scrl-flex-scroll"><div class="scrl-box"><center class="mb-3"><center><h4 class="fw-bold">' . @camelCase($value['refDataCode']) . '</h4><img src="' . base_url('assets/img/border.png') . '" width="250px"></center>';


			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
				\"moduleName\": \"Temple Events\",  
				\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
				\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
				\"aspectType\": \"ServiceSetup\",     
				\"query\": {  \"sourceTypes\": \"WEBSITE\",\"aspectType\": \"ServiceSetup\", \"parentService\": \"" . $ParentEvent . "\", \"serviceCategoryTypes\": \"" . $serviceCategoryTypes . "\", \"EventDispay\": \"" . $value['refDataCode'] . "\" },   
				\"userName\": \"\",     
				\"skip\": 0,    
				\"next\": 1024    
			} }");

			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);
			$response = json_decode($result);
			// var_dump($response);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}

			curl_close($ch);




			$services = json_decode(json_encode($response->data), true);
			// print_r($services);die();



			$services = sortBySequenceId($services);

			if ($services != array()) {

				$html .= '<style>

				*{

					padding:0;
					margin:0;
				}


				.event-card{
					overflow:hidden;
					width: 50px;
					height:50px;
					padding-bottom: 0.5em;
					border-style: solid;
					border-width: 0px;
					border-style: solid;


				}
				.event-card img{
					width: 100%;
					height:105px!important;
					-o-object-fit:cover;
					object-fit:cover;
				}
				.event-card .date-ribbon {
					position: absolute;
					top: 53px;
					background:white;
					left: 91px;
					color: #black;
					padding: 0.2em 1em;
					padding: 14px 6px;
					border-radius: 7px;
					border-style: solid;
					border-width: 2px 2px;
				}
				.event-card .date-ribbon h1{
					text-align:center;
					font-weight: 900;
					margin-bottom: 0px;
					font-size: 18px;
					margin-top:-0.09em;
				}

				
			}
				@media only screen and (max-width:992px){
				.event-card{
					    width: auto!important;
				}		
							. py-checkbox-div{
				width:100%!important;
		}
		}

				
				</style><div class="row px-0">';


				// var_dump($services);

				foreach ($services as $key => $item) {

					if ($item['status'] == 'ACTIVE') {
						$isValid = filterValidData($item);

						if ($isValid == 1) {



							$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

							$available_count_design = '';
							$filter_color = '';
							$available_count = '';
							$disable_input_field = '';
							//for testing
							//$item['isDietySelected'] = 'YES';

							if ($is_availibility_check == 1) {
								$available_count_design = '';
								$filter_color = 'filter: grayscale(1);';
								$disable_input_field = 'disabled readonly';
								$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							} else {

								if ($is_availibility_check == 3) {
									if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
										$available_count_design = ' <a href="javascript:void(0)">
									<div class="mask">
									<div class="d-flex justify-content-start align-items-end h-100">
									<h5 style="font-size: 11px!important;"><span class="badge bg-success mt-2 ms-1" style="font-size: 11px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
									</div>
									</div>
									<div class="hover-overlay">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
									</div>
									</a>';
									} else {
										$available_count_design = ' <a href="javascript:void(0)">
									<div class="mask">
									<div class="d-flex justify-content-start align-items-end h-100">
									<h5 style="font-size: 11px!important;"><span class="badge bg-danger mt-2 ms-1" style="font-size: 11px!important;">Avl. 0</span></h5>
									</div>
									</div>
									<div class="hover-overlay">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
									</div>
									</a>';
									}
									$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
								<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="EVENTS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"   available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;" is_date_required="' . @$item['isDTVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] .'" isTextinputBox="'.@$item['isTextinputBox']. ' data-start-date="' . @$item['startDate'] . '" data-end-date="'. @$item['endDate'] .'" isdietyselected="'. @$item['isDietySelected'].'" ">
								</div>';
								} else if ($is_availibility_check == 2) {
									$filter_color = 'filter: grayscale(1);';
									$disable_input_field = 'disabled readonly';
									$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
								} else {
									$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
								<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="EVENTS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"   available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;" is_date_required="' . @$item['isDTVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] .'" isTextinputBox="'.@$item['isTextinputBox']. '" data-start-date="' . @$item['startDate'] . '" data-end-date="' . @$item['endDate'] . '" isDietyselected="'. @$item['isDietySelected'].'" ">
								</div>';
								}
							}

							$dt_visibility = '';
							if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'NO') {
								$dt_visibility = 'd-none';
							}


							if (@$item['qtyCounter'] == 'YES') {
								$quantityContainer_display = 'inline-flex';
							} else {
								$quantityContainer_display = 'none';
							}



							if (isset($item['Image']) && !empty($item['Image'])) {
								$src = ApiBaseUrl()['url'] . $item['Image'];
							} else {
								$src = base_url('assets/img/') . "services-listing.png";
							}



							if ($item['serviceAmount'] != 0 && $item['serviceAmount'] != '') {

								$amountSection = @getCurrencySymbol() . '&nbsp;<span  style="font-size:14px!important;font-weight:bold;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  number_format($item['serviceAmount'], 2)) . '</span>';
							} else {

								$item['serviceAmount'] = 1;
								$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;background-color:transparent;color:white;border:0;padding-right:10px;font-weight:bold; padding-left: 20px;">$</span>
							<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="Enter Any Amount"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold; margin-right: 7px;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format(0, 2)) . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
							</div>


							<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important">
							' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  number_format($item['serviceAmount'], 2)) . '</span>
							</div>';
							}


							if ($item['startDate'] != '') {

								$formattedDate = date('M d, Y', strtotime($item['startDate']));

								$dayName = date('(D)', strtotime($item['startDate']));
								$day = date('d', strtotime($item['startDate']));


								if ($day % 10 == 1 && $day != 11) {
									$suffix = 'st';
								} elseif ($day % 10 == 2 && $day != 12) {
									$suffix = 'nd';
								} elseif ($day % 10 == 3 && $day != 13) {
									$suffix = 'rd';
								} else {
									$suffix = 'th';
								}
								$formattedDay = $day . $suffix;

								$formattedDay = '<div class="date-ribbon">
							<h1>' . $formattedDay . '</h1>

							</div>';
							} else {
								$formattedDay = '';
							}


							$start_date_input_field = '';



							if ($item['startDate'] != '' && $item['endDate'] != '') {


								$is_fixed_date = '';

								if (strtotime($item['startDate']) == strtotime($item['endDate'])) {

									$is_fixed_date = $item['startDate'] ? $item['startDate'] : date('m/d/Y');


									$start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>
							
							<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . ('' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . $is_fixed_date . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly disabled   data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
								} else {

									$is_fixed_date = $item['startDate'] ? $item['startDate'] : date('m/d/Y');


									$start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>
							
							<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . ('' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value=""') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
								}
							} else if ($item['startDate'] != '') {


								$is_fixed_date = '';

								$is_fixed_date = $item['startDate'] ? $item['startDate'] : date('m/d/Y');


								$start_date_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

							<input type="text" id="datepicker_' . $item['_id'] . '" class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $is_fixed_date . '" disabled  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly    data-start-date="' . $item['startDate'] . '" data-end-date="' . $item['endDate'] . '">';
							}


							$start_time_input_field = '';

							if ($item['startTime'] != '') {
								$start_time_input_field = '<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>
							<input type="text"  class=" form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" value="' . $item['startTime'] . '" readonly>';
							}

							if (isset($item['description']) && $item['description'] != '') {
								$descriptionWithEyeIcon = '<style>
							.collapse.in { display: inline !important; }
							</style>

							<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
							' . $item['description'] . '
							</span> 
							<span>
							<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:green"></i></a>
							</span>';
							} else {
								$descriptionWithEyeIcon = '';
							}

							//deity options
							$deities_html = '';
							if (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES') {

								$deities_html .= '<div class="col-sm-4 col-md-12">
							<select class="form-control" id="dietyName_' . $item['_id'] . '" style="font-size: .875rem;" onchange="addTocart();">
							<option value="" selected disabled>--select deity--</option>';
								if(isset($item['dietyName']) && $item['dietyName'] !== ''){
									$custom_deities_array = json_decode($item['dietyName'], true);
									foreach ($custom_deities_array as $deity) {
										$selected = '';
										if (!empty($session_data['ids']) && !empty($session_data['dietyName'])) {
											$index = array_search($item['_id'], $session_data['ids']);
											if ($index !== false && isset($session_data['dietyName'][$index]) && $session_data['dietyName'][$index] == $deity) {
												$selected = 'selected';
											}
										}

										$deities_html .= '<option value="' . $deity . '" ' . $selected . ' data-daytype="">' . htmlspecialchars($deity) . '</option>';
									}

								}else{
									foreach ($deities_data as $deity) {
										$selected = '';
										if (!empty($session_data['ids']) && !empty($session_data['dietyName'])) {
											$index = array_search($item['_id'], $session_data['ids']);
											if ($index !== false && isset($session_data['dietyName'][$index]) && $session_data['dietyName'][$index] == $deity['refDataName']) {
												$selected = 'selected';
											}
										}

										$deities_html .= '<option value="' . $deity['refDataName'] . '" ' . $selected . ' data-daytype="' . @$deity['day'] . '">' . htmlspecialchars($deity['refDataName']) . '</option>';
									}
								}


								$deities_html .= '</select>
							</div>';
							}





							$html .= '<div class="col-md-12 my-1 serviceSearch px-0 mx-0" style="' . $filter_color . '' . '">
						<div class="row " style="background: #fff3f5 !important;border: 1px solid #7d1456;    border-radius: 13px;    min-height: 100px;margin-left: 40px;">
						<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0 service-col-img" style="padding-left: 0px; display: flex; flex-direction: column; justify-content: space-evenly; align-items: stretch;border-radius: inherit;">


						<div class="event-card card" style="display: flex; flex-direction: column; justify-content: space-around;padding-bottom: 0px!important;">

						<img src="' . $src . '" alt="' . $item['refDataName'] . '"> 



						' . $formattedDay . '

						</div>
						' . $available_count_design . '


						</div>
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-10 text-left" style="display: flex; justify-content: center; align-items: baseline; flex-direction: column; align-content: space-between; flex-wrap: wrap;padding-left:26px;background-color: white;">
						<h3 class="fw-bold mb-1 pt-2 event-desc" style="font-size: 20px !important;margin-bottom: 0;color: var(--main-color-new-theme);display: inline-flex;width: -webkit-fill-available;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</h3>
						<p class="mt-0 mb-1" style="font-size:15px!important;line-height:1.4">' . $descriptionWithEyeIcon . '</p>
						' . $deities_html . '
						<div class="input-group ' . $dt_visibility . ' " style="width: 110%;">
						' . $start_date_input_field . '

						' . $start_time_input_field . '


						</div>

						</div>
						<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 text-center pr-0" style="
						padding: 0;background: #7d1456;color: white;border-radius: 0px 13px 13px 0px;display: flex; justify-content: center; align-items: center;
						">

						<div class="row">
						<div class="col-md-12" style="display: flex; justify-content: center; align-items: center;padding:0">
						<div class="display:flex">
						<style type="text/css">.form-check-input[type=checkbox] {margin-right:0px!important; margin-top: 0px!important}</style>
						<span class="suffix">' . $amountSection . '</span>
						' . $checkbox . '
						</div>
						</div>
						</div>

						</div>
						</div>
						</div>';
						}
					}
				}
				$html .= '</div>';
			} else {
				$html .= '';
			}

			$html .= '</div></div>';
		}



		$html .= '</div>';
	} else {

		$CI = &get_instance();

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
			\"moduleName\": \"Temple Events\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"ServiceSetup\",     
			\"query\": {        \"sourceTypes\": \"WEBSITE\", \"aspectType\": \"ServiceSetup\", \"parentService\": \"" . $ParentEvent . "\", \"serviceCategoryTypes\": \"" . $serviceCategoryTypes . "\" },   
			\"userName\": \"\",     
			\"skip\": 0,    
			\"next\": 1024    
		} }");
		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$response = json_decode($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}

		curl_close($ch);




		$services = json_decode(json_encode($response->data), true);
		$services = sortBySequenceId($services);



		$html = '';


		if ($services != array()) {
			$html .= '<style>

			*{

				padding:0;
				margin:0;
			}


			.event-card{
				overflow:hidden;
				width: auto;
				/* height:150px;
				padding-bottom: 0.5em;*/
				border-style: solid;
				border-width: 0px;
				border-style: solid;
			}
			/*controls the image*/
			.event-card img{
				width: 100%;
				height:105px!important;
				-o-object-fit:cover;
				object-fit:cover;
			}



			/*small calender item in top left corner*/
			.event-card .date-ribbon {
				position: absolute;
				top: 53px;
				background:WHITE;
				left: 91px;
				color: #black;
				padding: 0.2em 1em;
				padding: 14px 6px;
				border-radius: 7px;
				border-style: solid;
				border-width: 2px 2px;
			}
			.event-card .date-ribbon h1{
				text-align:center;
				font-weight: 900;
				margin-bottom: 0px;
				font-size: 18px;
				margin-top:-0.09em;
			}
							@media only screen and (max-width:992px){
				.event-card{
					    width: auto!important;
				}		
							. py-checkbox-div{
				width:100%!important;
		}
		}
	
			@media only screen and (max-width: 992px) {
    			.service-col-scontent {
        			width: 85% !important;
        			border-radius: 0px 12px 0px 0px;
					padding:0px!important;
    			}
			.event-card img{
				width: 100%;
				        height: 100px !important;
				-o-object-fit:cover;
				object-fit:cover;
			}
		}

			</style><div class="row px-0" style="margin-top: 20px;">';

			usort($services, function ($a, $b) {
				$dateA = DateTime::createFromFormat('m/d/Y', $a['startDate']);
				$dateB = DateTime::createFromFormat('m/d/Y', $b['startDate']);


				if ($dateA == $dateB) {
					return 0;
				} elseif ($dateA < $dateB) {
					return -1;
				} else {
					return 1;
				}
			});


			foreach ($services as $key => $item) {
				// $html.="<br><br>".$item['status'];
				if ($item['status'] == 'ACTIVE') {
					$isValid = filterValidData($item);

					if ($isValid == 1) {

						$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

						$available_count_design = '';
						$filter_color = '';
						$available_count = '';
						$disable_input_field = '';

						if ($is_availibility_check == 1) {
							$available_count_design = '';
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {

							if ($is_availibility_check == 3) {
								if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
									$available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 11px!important;"><span class="badge bg-success mt-2 ms-1" style="font-size: 11px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
								} else {
									$available_count_design = ' <a href="javascript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 11px!important;"><span class="badge bg-danger mt-2 ms-1" style="font-size: 11px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
								}
								$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;" is_date_required="' . @$item['isDTVisible'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
							} else if ($is_availibility_check == 2) {
								$filter_color = 'filter: grayscale(1);';
								$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
								$disable_input_field = 'disabled readonly';
							} else {
								$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" daytypes="' . @$item['dayTypes'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important;margin-left:10px" is_date_required="' . @$item['isDTVisible'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
							}
						}

						$dt_visibility = '';
						if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'NO') {
							$dt_visibility = 'd-none';
						}



						if (@$item['qtyCounter'] == 'YES') {
							$quantityContainer_display = 'inline-flex';
						} else {
							$quantityContainer_display = 'none';
						}



						if (isset($item['Image']) && !empty($item['Image'])) {
							$src = ApiBaseUrl()['url'] . $item['Image'];
						} else {
							$src = base_url('assets/img/') . "services-listing.png";
						}


						if ($item['serviceAmount'] != 0 && $item['serviceAmount'] != '') {



							$amountSection = @getCurrencySymbol() . '&nbsp;<span  style="font-size:20px!important;font-weight:bold;color: white;;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  number_format($item['serviceAmount'], 2)) . '</span>';
						} else {

							$item['serviceAmount'] = 1;
							$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;background-color:transparent;color:white;border:0;padding-right:10px;font-weight:bold;font-size:20px!important;color: white;">$</span>
						<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 20px!important; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  '') . '" ' . $disable_input_field . '>
						</div>


						<div class="d-none col-md-12" style="padding: 0px 30px;font-size:20px!important">
						' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  number_format($item['serviceAmount'], 2)) . '</span>
						</div>';
						}


						// if ($item['startDate'] != '') {

						// 	$formattedDate = date('M d, Y', strtotime($item['startDate']));

						// 	$dayName = date('(D)', strtotime($item['startDate']));
						// 	$day = date('d', strtotime($item['startDate']));


						// 	if ($day % 10 == 1 && $day != 11) {
						// 		$suffix = 'st';
						// 	} elseif ($day % 10 == 2 && $day != 12) {
						// 		$suffix = 'nd';
						// 	} elseif ($day % 10 == 3 && $day != 13) {
						// 		$suffix = 'rd';
						// 	} else {
						// 		$suffix = 'th';
						// 	}
						// 	$formattedDay = $day . $suffix;

						// 	$formattedDay = '<div class="date-ribbon">
						// 	<h1>' . $formattedDay . '</h1>

						// 	</div>';
						// } else {
						$formattedDay = '';
						// }




						if (isset($item['description']) && $item['description'] != '') {
							$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:green"></i></a>
						</span>';
						} else {
							$descriptionWithEyeIcon = '';
						}



						$limitPerdayFeature = '';
						$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
						$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

						if ($BookingLimitPerDay > 0) {

							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
						} else {
							// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
							if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



								if (!empty($item['dayTypes'])) {

									$date_value = 'value=""';
								} else {

									if (strtotime($item['startDate']) == strtotime($item['endDate'])) {
										$date_value = 'value="' . $item['startDate'] . '" disabled';
									} else {
										$date_value = 'value=""';
									}
								}
							} else if (isset($item['startDate']) && $item['startDate']) {

								$date_value = 'value="' . $item['startDate'] . '" disabled';
							} else {

								if (in_array($item['_id'], $session_data['ids'])) {
									$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								} else {
									// $date_value = 'value="' . date('m/d/Y') . '"';
									$date_value = 'value=""';
								}
							}
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-events form-control form-control-sm date-time-placeholder" style="color: #7d1456;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . $date_value  . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" >';
						}


						if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
							$dateTimeCode = '';
							$dateTimeCode = '<div class="row m-0 pt-0 gap-0 gap-md-2">
						<div class="col-md-4 m-0 p-0 date-col-div">
						<div class="input-group">
						<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 time-col-div">

						<div class="input-group">
						<span class="input-group-text" style="padding-left: 0;color: #7d1456;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '" _id="' . $item['_id'] . '" data-dt-visible="' . (isset($item['isDTVisible']) ? $item['isDTVisible'] : 'NO') . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #000000; background-color: #ffffff00; opacity: 1; border: 0; padding: 0px !important; max-width:100px !important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ? 'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"' : '') . '') . ' placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
						} else {
							$dateTimeCode = '';
						}


						$cartDateCount = 1;
						if (in_array($item['_id'], $session_data['ids'])) {
							$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
							$cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

							if (!empty($cartDate)) {
								$cartDateCount = count(explode(',', $cartDate));
							}
						}


						// if ($item['qtyCounter'] != 'YES') {
						// 	$style_res_amount = 'display: flex!important;flex-direction: row;justify-content: flex-end;align-items: center;padding: 0px;';
						// } else {
						// 	$style_res_amount = 'display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 20px;';
						// }

						if ($item['qtyCounter'] != 'YES') {
							$style_res_amount = 'display: flex!important;flex-direction: row;justify-content: end !important;align-items: stretch;padding: 0px;';
						} else {
							$style_res_amount = '';
						}

						$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme)!important;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @getCurrencySymbol() . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
					</div>

					<div class="col-md-12 my-1 serviceSearch" style="' . $filter_color . '' . '">
					<div class="row " style="background: var(--main-color-new-theme)!important;border: 1px solid #7d1456;    border-radius: 13px">
					<div class="col-lg-1 col-md-1 col-xs-1 service-col-img" style="padding-left:0px;    background: white;">


					<div class="event-card card">

					<img src="' . $src . '" alt="' . $item['refDataName'] . '"> 



					' . $formattedDay . '

					</div>
					' . $available_count_design . '

					</div>


					<div class="col-md-6 col-lg-7 col-xl-7 service-col-scontent" style="background:white!important;">
					<h3 class="pt-2 mb-1 event-desc" style="font-size: 20px !important;margin-bottom: 0;color: var(--main-color-new-theme);display: inline-flex;width: -webkit-fill-available;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</h3>
					<p class="mt-0 mb-1" style="font-size:15px!important;line-height:1.4">' . $descriptionWithEyeIcon . '</p>
					<div class="input-group ' . $dt_visibility . ' " style="width: 70%;">

					' . $dateTimeCode . '

					


					</div>

					</div>


					
					

					<div class="col-sm-6 col-md-6 col-lg-4 col-xl-4" style="display: flex !important;flex-direction: column;justify-content: center;align-items: stretch;padding: 0px 25px;">

						<div class="res-amount" style="' . $style_res_amount . '"> 

					
							<div class="quantity-container" style="display:' . $quantityContainer_display . '">

								<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

								<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '"  ' . $disable_input_field . '>

								<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

							</div>

							<span style="font-size:20px!important;font-weight:bold;color: white;margin-top:5px; ' . ($item['qtyCounter'] != 'YES' ?  'padding-right: 36px;' : '') . '" id="Totalprice_' . $item['_id'] . '">' . $amountSection . '</span>
							' . $checkbox . '
						</div>
					</div>
					</div>
					</div>';
					}
				}
			}
			$html .= '</div>';
		} else {
			$html .= '';
		}
	}




	return $html;
}

function getServiceTypes()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	$url = ApiBaseUrl()['url'] . filterAPI()['url'];

	$data = array(
		'componentConfig' => array(
			'query' => array(
				// 'aspectType' => 'servicesDisplayGroup'
				'aspectType' => 'serviceCategoryTypes'
			),
			'moduleName' => 'Master Data Management',
			// 'aspectType' => 'servicesDisplayGroup',
			'aspectType' => 'serviceCategoryTypes',
			// 'collectionType' => 'Business',
			'productID' => ApiBaseUrl()['productID'],
			'clientID' => ApiBaseUrl()['clientID'],
			'skip' => 0,
			'next' => 1000
		)
	);

	$headers = array(
		'Content-Type: application/json'
	);

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error: ' . curl_error($ch);
	}

	curl_close($ch);

	$response = json_decode($result);

	return json_decode(json_encode($response->data), true);
}


function GetServiceCatTypes()
{
	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Master Data Management\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"serviceCategoryTypes\",     
		\"query\": {        \"aspectType\": \"serviceCategoryTypes\",  \"status\": \"ACTIVE\"},   
		\"userName\": \"\",     
		\"skip\": 0,    
		\"next\": 1024    
	} }");
	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	return json_decode(json_encode($response->data), true);
}

// ==================  getServiceTypesByDisplayGroup  ================
function getServiceTypesByDisplayGroupAndDeityName($DisplayGroup)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	$url = ApiBaseUrl()['url'] . filterAPI()['url'];

	$data = array(
		'componentConfig' => array(
			'query' => array(
				'aspectType' => 'servicesDisplayGroup',
				'refDataName' => $DisplayGroup
			),
			'moduleName' => 'Master Data Management',
			'aspectType' => 'servicesDisplayGroup',
			// 'collectionType' => 'Business',
			'productID' => ApiBaseUrl()['productID'],
			'clientID' => ApiBaseUrl()['clientID'],
			'skip' => 0,
			'next' => 1000
		)
	);

	$headers = array(
		'Content-Type: application/json'
	);

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error: ' . curl_error($ch);
	}

	curl_close($ch);

	$response = json_decode($result);

	return json_decode(json_encode($response->data), true);
}
// ==================  getServiceTypesByDisplayGroup  ================


function getServiceTypesByDisplayGroup($DisplayGroup)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	$url = ApiBaseUrl()['url'] . filterAPI()['url'];

	$data = array(
		'componentConfig' => array(
			'query' => array(
				'aspectType' => 'servicesDisplayGroup',
				'refDataName' => $DisplayGroup
			),
			'moduleName' => 'Master Data Management',
			'aspectType' => 'servicesDisplayGroup',
			// 'collectionType' => 'Business',
			'productID' => ApiBaseUrl()['productID'],
			'clientID' => ApiBaseUrl()['clientID'],
			'skip' => 0,
			'next' => 1000
		)
	);

	$headers = array(
		'Content-Type: application/json'
	);

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error: ' . curl_error($ch);
	}

	curl_close($ch);

	$response = json_decode($result);

	return json_decode(json_encode($response->data), true);
}


// ==========Filter Services By Display Group And Deity Name Start==========



function FilterServicesByDisplayGroupAndDeityName($DisplayGroup, $deityName, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);


	$queryData = array(
		"aspectType" => "ServiceSetup",
		"servicesDispayGroup" => $DisplayGroup,
		"dietyName" => $deityName,
		"sourceTypes" => "WEBSITE",
		"status" => "ACTIVE"
	);

	$query = json_encode($queryData);

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {
			\"query\": $query, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);
	$currency = getCurrencySymbol();

	$html = '';

	// print_r($services);

	if ($services != array()) {
		$html .= '<table class="table border-0 servicesDataTable">
		<thead class="d-none">
		<tr class="table-primary">
		<th style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Service Name</th>
		<th class="text-end" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Amount</th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		</tr>
		</thead>
		<tbody id="table">';

		foreach ($services as $key => $item) {







			$isValid = filterValidData($item);
			if ($isValid == 1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}

				$pageLength = $key + 1;

				//////////////////////////////////////////////////////

				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}



				$description = $item['description'];

				$words = explode(" ", $description);
				if (count($words) > 20) {
					$limited_words = array_slice($words, 0, 20);
					$limited_string = implode(" ", $limited_words) . "...";
				} else {
					$limited_string = $description;
				}

				// echo $item['qtyCounter'];

				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}




				if ($item['serviceAmount'] != 0) {


					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important;" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}


					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: var(--main-color-new-theme) !important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: var(--main-color-new-theme) !important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '>';
					}


					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-3 m-0 p-0">
						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-3">

						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['description']) && $item['description'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}

					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0" style="color:#fff!important" width="60%">
					<div class="col-md-12 m-0 p-0">

					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;">
					' . $available_count_design . '
					</div>
					</div>


					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">

					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					' . $descriptionWithEyeIcon . '
					' . $dateTimeCode . '

					</div>
					</div>
					</div>
					</td>


					<td class="text-end align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="5%"><span  id="price_' . $item['_id'] . '"></span>
					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;" width="13%">

					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					</td>


					<td class="text-end align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="12%">

					<div class="row m-0" style="padding-right: 40px;">
					<div class="col-md-6">
					' . ($bookingType == "PAY NOW" ?  "" : "<img src=" . base_url('assets/img/pay-later.png') . " style='height: 35px;  width: 35px;margin-left: 10px;'></img>") . '
					</div>
					<div class="col-md-6" style="padding-top: 6px;">
					<span style="font-size:20px!important;font-weight:bold;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($item['serviceAmount']) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>
					</div>

					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;" width="10%">

					' . $checkbox . '

					</td>
					</tr>
					';
				} else {

					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}

					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0 col-7 " style="color:#fff!important">
					<div class="col-md-12 m-0 p-0">
					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 100px;width:100%;width: 83%;margin-left: 10px;">
					' . $available_count_design . '
					</div>

					</div>
					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					<div class="row m-0 p-0">
					<div class="col-md-3 m-0 p-0">
					<div class="input-group">
					<div class="input-group-addon" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


					</div>
					</div>
					<div class="col-md-3">

					<div class="input-group">
					<div class="input-group-addon timepicker-services" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
					</div>
					</div>
					</div>

					<p class="text-white mb-0 pb-2" style="line-height:20px;font-size:13px!important">
					' . ($limited_string != '' ? ' ' . $limited_string : '') . '
					</p>

					</div>
					</div>
					</div>
					</td>
					<td class="text-center col-2 align-middle"  style="background-color:var(--main-color-new-theme);"><span></span></td>

					<td colspan="2" class="text-end col-2 align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;">


					<span>Request A Service</span>
					<span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
					</td>

					<td class="text-center col-1 align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;">
					' . $checkbox . '
					</td>
					</tr>';
				}
			}
		}
		$html .= '</tbody>

		</table></table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}
// ===================== Filter Services By Display Group And Deity Name End=======================







// =====================Services Filter By DisplayGroup Name Start=======================
function FilterServicesByDisplayGroup($DisplayGroup, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);


	$queryData = array(
		"aspectType" => "ServiceSetup",
		"servicesDispayGroup" => $DisplayGroup,
		"sourceTypes" => "WEBSITE",
		"status" => "ACTIVE"
	);

	$query = json_encode($queryData);

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {
			\"query\": $query, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);
	$currency = getCurrencySymbol();

	$html = '';

	// print_r($services);

	if ($services != array()) {
		$html .= '<table class="table border-0 servicesDataTable">
		<thead class="d-none">
		<tr class="table-primary">
		<th style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Service Name</th>
		<th class="text-end" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Amount</th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		</tr>
		</thead>
		<tbody id="table">';

		foreach ($services as $key => $item) {

			$isValid = filterValidData($item);
			if ($isValid == 1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}

				$pageLength = $key + 1;

				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}

				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}



				if ($item['serviceAmount'] != 0) {

					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}


					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  ' . $disable_input_field . '>';
					}


					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-3 m-0 p-0">
						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-3">

						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['description']) && $item['description'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}

					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0 " style="color:#fff!important" width="60%">
					<div class="col-md-12 m-0 p-0">

					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;">
					' . $available_count_design . '
					</div>
					</div>


					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">

					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					' . $descriptionWithEyeIcon . '
					' . $dateTimeCode . '

					</div>
					</div>
					</div>
					</td>


					<td class="text-end align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="5%"><span  id="price_' . $item['_id'] . '"></span>
					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;" width="13%">

					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					</td>


					<td class="text-end align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="12%">

					<div class="row m-0" style="padding-right: 40px;">
					<div class="col-md-6">
					' . ($bookingType == "PAY NOW" ?  "" : "<img src=" . base_url('assets/img/pay-later.png') . " style='height: 35px;  width: 35px;margin-left: 10px;'></img>") . '
					</div>
					<div class="col-md-6" style="padding-top: 6px;">
					<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($item['serviceAmount']) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>
					</div>

					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;padding-left:30px" width="10%">

					' . $checkbox . '

					</td>
					</tr>
					';
				} else {

					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}

					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0" style="color:#fff!important" width="60%">
					<div class="col-md-12 m-0 p-0">
					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 120px;width:100%;width: 83%;margin-left: 10px;">
					' . $available_count_design . '
					</div>

					</div>
					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					<div class="row m-0 p-0">
					<div class="col-md-3 m-0 p-0">
					<div class="input-group">
					<div class="input-group-addon" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


					</div>
					</div>
					<div class="col-md-3">

					<div class="input-group">
					<div class="input-group-addon timepicker-services" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
					</div>
					</div>
					</div>

					</div>
					</div>
					</div>
					</td>
					<td class="text-center align-middle"  style="background-color:var(--main-color-new-theme);" width="10%"><span></span></td>

					<td colspan="2" class="text-end align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="15%">


					<span>Request A Service</span>
					<span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;" width="15%">
					' . $checkbox . '
					</td>
					</tr>';
				}
			}
		}
		$html .= '</tbody>

		</table></table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}


// =====================Services Filter By DisplayGroup Name End=======================




// =====================Services Filter By Deity Name Start=======================

function getServicesByServiceTypeAndDeityName($deityName, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);


	$queryData = array(
		"aspectType" => "ServiceSetup",
		"dietyName" => $deityName,
		"sourceTypes" => "WEBSITE",
		"status" => "ACTIVE"
	);

	$query = json_encode($queryData);

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {
			\"query\": $query, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);
	$currency = getCurrencySymbol();

	$html = '';

	// print_r($services);

	if ($services != array()) {
		$html .= '<table class="table border-0 servicesDataTable">
		<thead class="d-none">
		<tr class="table-primary">
		<th style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Service Name</th>
		<th class="text-end" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important">Amount</th>
		<th class="text-center" style="padding: 15px 20x;font-size: 18px;background-color:#3a4047!important;color:#fff!important"></th>
		</tr>
		</thead>
		<tbody id="table">';

		foreach ($services as $key => $item) {

			$isValid = filterValidData($item);
			if ($isValid == 1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}

				$pageLength = $key + 1;
				//////////////////////////////////////////////////////

				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}

				// echo $item['qtyCounter'];

				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}


				if ($item['serviceAmount'] != 0) {

					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" booking_type="' . $bookingType . '" isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}



					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '>';
					}


					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-3 m-0 p-0">
						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-3">

						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['description']) && $item['description'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}


					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0" style="color:#fff!important" width="60%">
					<div class="col-md-12 m-0 p-0">

					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;">
					' . $available_count_design . '
					</div>
					</div>


					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">
					
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					' . $descriptionWithEyeIcon . '
					' . $dateTimeCode . '


					</div>
					</div>
					</div>
					</td>
					<td class="text-end align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="5%"><span  id="price_' . $item['_id'] . '"></span>
					</td>
					
					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;" width="13%">

					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					</td>


					<td class="text-end align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="12%">

					<div class="row m-0" style="padding-right: 40px;">
					<div class="col-md-6">
					' . ($bookingType == "PAY NOW" ?  "" : "<img src=" . base_url('assets/img/pay-later.png') . " style='height: 35px;  width: 35px;margin-left: 10px;'></img>") . '
					</div>
					<div class="col-md-6" style="padding-top: 6px;">
					<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($item['serviceAmount']) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>
					</div>
					
					</td>

					<td class="text-center align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;padding-left:30px" width="10%">

					' . $checkbox . '

					</td>
					</tr>
					';
				} else {
					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2">
					<td class="p-0 col-7 " style="color:#fff!important">
					<div class="col-md-12 m-0 p-0">
					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 100px;width:100%;width: 83%;margin-left: 10px;">
					</div>

					</div>
					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>


					<div class="row m-0 p-0">
					<div class="col-md-3 m-0 p-0">
					<div class="input-group">
					<div class="input-group-addon" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


					</div>
					</div>
					<div class="col-md-3">

					<div class="input-group">
					<div class="input-group-addon timepicker-services" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</td>
					<td class="text-center col-2 align-middle"  style="background-color:var(--main-color-new-theme);"><span></span></td>

					<td colspan="2" class="text-end col-2 align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;">


					<span>Request A Service</span>
					<span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
					</td>

					<td class="text-center col-1 align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;">
					<div class="form-check">
					<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '"  includeSankalpam="' . @$includeSankalpam . '" ' . $disable_input_field . ' style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
					</div>
					</td>
					</tr>';
				}
			}
		}
		$html .= '</tbody>

		</table></table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

// =====================Services Filter By Deity Name End=======================
function getServicesByServiceType2($serviceCategory, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);


	curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceCategoryTypes": "' . $serviceCategory . '",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';
	// var_dump($services[1]);
	// die();
	if ($services != array()) {
		$i = 0;
		foreach ($services as $key => $item) {
			// if($i>0){
			// 	var_dump($item['serviceOccurrencesNo']);die();
			// }


			$i++;
			$isValid = filterValidData($item);
			if ($isValid == 1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}


				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}



				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}



				// var_dump($item);
				if ($item['serviceAmount'] != 0) {


					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						$serviceOccurrencesNo = $item['serviceOccurrencesNo'];
					} else {
						$serviceOccurrencesNo = '';
					}
					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						$servicetAmount = ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])) * $item['serviceOccurrencesNo'], 2)  :  price_format($item['serviceAmount'], 2));
					} else {
						$servicetAmount = ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2));
					}

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $servicetAmount . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '" data-servicedesc="' . @$item['description'] . '" data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $servicetAmount . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  : @$item['description']) . '" data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '">
							</div>';
						}
					}



					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . ' start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {

						if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



							if (!empty($item['dayTypes'])) {
								if (in_array($item['_id'], $session_data['ids'])) {
									if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
										$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
										if (!empty($selectedDate) && is_string($selectedDate)) {
											$date_value = 'value="' . ($selectedDate) . '"';
											$selectedDate = explode(", ", $selectedDate);
											$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
											$date_value1 = 'value="' . ($selectedDate1) . '"';
										} else {
											$date_value1 = 'value="' . ($selectedDate) . '"';
											$date_value = 'value="' . ($selectedDate) . '"';
										}
									} else {
										$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
										$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									}
								} else {

									$date_value = 'value=""';
									$date_value1 = 'value=""';
								}
							} else {
								$date_value = 'value="' . date('m/d/Y') . '"';
								$date_value1 = 'value="' . date('m/d/Y') . '"';
							}
						} else if (isset($item['startDate']) && $item['startDate']) {
							$date_value = 'value="' . $item['startDate'] . '" disabled';
							$date_value1 = 'value="' . $item['startDate'] . '" disabled';
						} else {

							if (in_array($item['_id'], $session_data['ids'])) {
								if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
									$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
									if (!empty($selectedDate) && is_string($selectedDate)) {
										$date_value = 'value="' . ($selectedDate) . '"';
										$selectedDate = explode(", ", $selectedDate);
										$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
										$date_value1 = 'value="' . ($selectedDate1) . '"';
									} else {
										$date_value1 = 'value="' . ($selectedDate) . '"';
										$date_value = 'value="' . ($selectedDate) . '"';
									}
								} else {
									$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								}
							} else {
								// $date_value = 'value="' . date('m/d/Y') . '"';
								$date_value = 'value=""';
								$date_value1 = 'value=""';
							}
						}

						if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="d-none datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 24px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker1_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 24px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value1 . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
						} else {
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 24px; width: -webkit-fill-available; margin-top: -29px; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  select_date="' . @$item['selectDate'] . '" end_date="' . @$item['endDate'] . '">';
						}
					}
					$limitPerdayFeature .= '<span  id="datepickerCount_' . $item['_id'] . '"></span>';


					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-12 m-0 p-0">
						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-left: 0;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0">

						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding:.375rem .75rem .375rem 0rem" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important;max-width:100px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}






					if (isset($item['description']) && $item['description'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false"><i class="fa fa-eye" style="color: var(--main-color-new-theme);"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}







					if ($item['qtyCounter'] != 'YES') {
						$style_res_amount = 'display: flex!important;flex-direction: row;justify-content: flex-end;align-items: stretch;padding: 0px;border-left:1px solid white;';
					} else {
						$style_res_amount = 'display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;border-left:1px solid white;';
					}


					$pageLength = $key + 1;




					$priceType = '';


					if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


						$priceTypeString = $item['priceType'];


						$priceTypeArray = json_decode($priceTypeString, true);

						if ($priceTypeArray != array()) {

							$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


							foreach ($priceTypeArray as $index => $option) {

								$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' (' . $currency . ' ' . price_format($option['value'], 2) . ')</option>';
							}

							$priceType .= '</select>';
						}
					}
					// if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
					// $servicetAmount=((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])) * $item['serviceOccurrencesNo'], 2)  :  price_format($item['serviceAmount'], 2)) ;
					// }else{
					// 	$servicetAmount=((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) ;
					// }
					$logoMember = '';
					if (!empty($CI->session->userdata('logged_in')) && $CI->session->userdata('logged_in') == 1 && !empty($CI->session->userdata('membershipStatus')) && $CI->session->userdata('membershipStatus') == 'ACTIVE' && isset($item['membershipDiscount']) && $item['membershipDiscount'] == 'YES') {
						$logoMember = '<img src="' . base_url('admin_assets/img/membership.png') . '" height="15" />';
					}

					$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white">
					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">
					<a href="' . $src . '" data-lightbox="set">

					<div class="crop-center img-responsive bg-light services-thumb" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div></a>

					
					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
					</div>
					</a>
					</div>
					</div>
					<div class="col-md-6 col-lg-7 col-xl-7" style="background:linear-gradient(to top, var(--main-color-new-theme), var(--main-color-new-theme) ); flex; flex-direction: row; align-items: center;">
					<div style="padding-left: 16px;width: -webkit-fill-available;">
					<label class="pt-2" style="font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . $logoMember . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					' . $descriptionWithEyeIcon . '
					' . $dateTimeCode . '
					' . $priceType . '
					</div>
					</div>

					<div class="col-sm-6 col-md-6 col-lg-4 col-xl-4" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px; background: linear-gradient(to top, #93291E, var(--main-color-new-theme));">

					<div class="res-amount" style="' . $style_res_amount . '"> 

					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '"  ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					<span style="font-size:20px!important;font-weight:bold; ' . ($item['qtyCounter'] != 'YES' ?  'padding-right: 36px;' : '') . '" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . $servicetAmount . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
				}
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

function getServicesByServiceType($serviceCategory, $session_data)
{

	$CI = &get_instance();
	$membershipDetails = membershipStatusCheck();
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);


	curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceCategoryTypes": "' . $serviceCategory . '",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	// var_dump($response);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';

	// var_dump($services[1]);
	// die();
	// var_dump($services);
	if ($services != array()) {
		$deities_data = getWebSyncsData('Diety', 'Diety Directory', '');
		$i = 0;
		foreach ($services as $key => $item) {
			// if($i>0){
			// 	var_dump($item['serviceOccurrencesNo']);die();
			// }

			// console the item  using script
			$html .= '<script> console.log(' . json_encode($item) . ');</script>';


			$i++;
			$isValid = filterValidData($item);
			if (1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}


				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}


				if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo']) && $item['serviceOccurrencesNo'] > 1) {
					$item['qtyCounter'] = 'NO';
				}
				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
					$quantityContainer_display2 = 'none';
				} else {
					$quantityContainer_display = 'none';
					$quantityContainer_display2 = 'inline-flex';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}


				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;
				// var_dump($item);
				if ($item['serviceAmount'] != 0) {


					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						$serviceOccurrencesNo = $item['serviceOccurrencesNo'];
					} else {
						$serviceOccurrencesNo = '';
					}
					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						$servicetAmount = ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])) * $item['serviceOccurrencesNo'], 2)  :  price_format($item['serviceAmount'], 2));
					} else {
						$servicetAmount = ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2));
					}

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $servicetAmount . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" is_time_required="' . @$item['isTimeVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '" data-servicedesc="' . @$item['description'] . '" data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" data-daytype="' . @$item['dayTypes'] . '" cutofftime="' . @$item['cutOffTime'] . '"  data-holdingDates="' . @$item['holdingDates'] . '" isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;' . ($item['qtyCounter'] != 'YES' ? 'margin-right: 12px' : '') . '">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . $servicetAmount . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" is_time_required="' . @$item['isTimeVisible'] . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   $session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  : @$item['description']) . '" data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '"   data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" data-daytype="' . @$item['dayTypes'] . '" cutofftime="' . @$item['cutOffTime'] . '"  data-holdingDates="' . @$item['holdingDates'] . '" isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
							</div>';
						}
					}



					$limitPerdayFeature = '';

					$default_date = date('m/d/Y');
					if ($item['serviceTypes'] == 'VADAMALA') {
						$default_date = '';
					}
					if ($BookingLimitPerDay > 0) {

						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . ' start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: var(--main-color-new-theme) !important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value=""' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . $default_date . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '>';
					} else {

						if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



							if (!empty($item['dayTypes'])) {
								if (in_array($item['_id'], $session_data['ids'])) {
									if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
										$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
										if (!empty($selectedDate) && is_string($selectedDate)) {
											$date_value = 'value="' . ($selectedDate) . '"';
											$selectedDate = explode(", ", $selectedDate);
											$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
											$date_value1 = 'value="' . ($selectedDate1) . '"';
										} else {
											$date_value1 = 'value="' . ($selectedDate) . '"';
											$date_value = 'value="' . ($selectedDate) . '"';
										}
									} else {
										$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
										$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									}
								} else {

									$date_value = 'value=""';
									$date_value1 = 'value=""';
								}
							} else {
								$date_value = 'value="' . date('m/d/Y') . '"';
								$date_value1 = 'value="' . date('m/d/Y') . '"';
							}
						} else if (isset($item['startDate']) && $item['startDate']) {
							$date_value = 'value="' . $item['startDate'] . '" disabled';
							$date_value1 = 'value="' . $item['startDate'] . '" disabled';
						} else {

							if (in_array($item['_id'], $session_data['ids'])) {
								if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
									$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
									if (!empty($selectedDate) && is_string($selectedDate)) {
										$date_value = 'value="' . ($selectedDate) . '"';
										$selectedDate = explode(", ", $selectedDate);
										$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
										$date_value1 = 'value="' . ($selectedDate1) . '"';
									} else {
										$date_value1 = 'value="' . ($selectedDate) . '"';
										$date_value = 'value="' . ($selectedDate) . '"';
									}
								} else {
									$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								}
							} else {
								// $date_value = 'value="' . date('m/d/Y') . '"';
								$date_value = 'value=""';
								$date_value1 = 'value=""';
							}
						}

						if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="d-none datepicker-services1 form-control form-control-sm date-time-placeholder" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker1_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder"  placeholder="Start Date" ' . $date_value1 . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
						} else {
							$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  select_date="' . @$item['selectDate'] . '" end_date="' . @$item['endDate'] . '">';
						}
					}
					$limitPerdayFeature .= '<span  id="datepickerCount_' . $item['_id'] . '"></span>';


					$deities_html = '';
					if (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES') {
						$deities_html .= '<div class="col-sm-4">
						<select class="form-control" id="dietyName_' . $item['_id'] . '" style="font-size: .875rem;" onchange="addTocart();">
						<option value="" selected disabled>--select diety--</option>';
						foreach ($deities_data as $deity) {
							$selected = '';
							if (!empty($session_data['ids']) && !empty($session_data['dietyName'])) {
								$index = array_search($item['_id'], $session_data['ids']);
								if ($index !== false && isset($session_data['dietyName'][$index]) && $session_data['dietyName'][$index] == $deity['refDataName']) {
									$selected = 'selected';
								}
							}

							$deities_html .= '<option value="' . $deity['refDataName'] . '" ' . $selected . '>' . htmlspecialchars($deity['refDataName']) . '</option>';
						}


						$deities_html .= '</select>
						</div>';
					}

					$dateTimeCode = '';
					$dateCode = '';

					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {

						$dateCode = '
							<!-- Date Section (Left Side) -->
							<div class="col-sm-4 col-md-8 m-0 p-0 date-col-div">
								<div class="input-group">
									<span class="input-group-text" style="color: var(--main-color-new-theme); background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
										<i class="fa fa-calendar"></i>
									</span>
									' . $limitPerdayFeature . '
								</div>
							</div>';
					}


					$TimeCode = '';
					if (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') {

						$TimeCode = '
							<!-- Time Section (Right Side) -->
							<div class="col-sm-4 col-md-4 p-0 time-col-div">
								<div class="input-group">
									<span class="input-group-text" style="color: var(--main-color-new-theme); background-color: #e9ecef00; border: 1px solid #ced4da00; padding: .375rem .75rem .375rem 0rem;" id="basic-addon1">
										<i class="fa fa-clock-o"></i>
									</span>
									<input type="text" id="timepicker_' . $item['_id'] . '" _id="' . $item['_id'] . '" data-dt-visible="' . (isset($item['isDTVisible']) ? $item['isDTVisible'] : 'NO') . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #000000; background-color: #ffffff00; opacity: 1; border: 0; padding: 0px !important; max-width:100px !important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ? 'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"' : '') . '') . ' placeholder="--:--" ' . $disable_input_field . '>
								</div>
							</div>';
					}

					if ((isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') || (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') || (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES')) {
						$dateTimeCode = '<div class="row m-0 pt-3 datetime-div" style="">' . $deities_html . $dateCode . $TimeCode . '</div>';
					}







					if (isset($item['description']) && $item['description'] != '') {
						$descriptionEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						&nbsp;<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false"><i class="fa fa-eye" style="color: #0015a2;font-size: 17px;margin-top: -3px;width: fit-content;"></i></a>
						';
						$descriptionWithEyeIcon = '
						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="color:var(--main-color-new-theme);">
						' . $item['description'] . '
						</span> 
						';
					} else {
						$descriptionEyeIcon = '';
						$descriptionWithEyeIcon = '';
					}







					if ($item['qtyCounter'] != 'YES') {
						$style_res_amount = 'display: flex!important;flex-direction: row;justify-content: center !important;align-items: stretch;padding: 0px; gap: 10vw';
					} else {
						$style_res_amount = '';
					}


					$pageLength = $key + 1;




					$priceType = '';


					if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


						$priceTypeString = $item['priceType'];


						$priceTypeArray = json_decode($priceTypeString, true);

						if ($priceTypeArray != array()) {

							$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


							foreach ($priceTypeArray as $index => $option) {

								$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' (' . $currency . ' ' . price_format($option['value'], 2) . ')</option>';
							}

							$priceType .= '</select>';
						}
					}
					// if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
					// $servicetAmount=((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])) * $item['serviceOccurrencesNo'], 2)  :  price_format($item['serviceAmount'], 2)) ;
					// }else{
					// 	$servicetAmount=((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) ;
					// }
					$logoMember = '';
					if ($membershipDetails['membershipStatus'] == 'ACTIVE' && isset($item['membershipDiscount']) && $item['membershipDiscount'] == 'YES') {
						$logoMember = '<img src="' . base_url('admin_assets/img/membership.png') . '" height="15" />';
					}


					$html .= '
					<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme)!important; color:#fff!important; font-weight:bold; font-size:18px!important; padding:5px 5px!important;" width="1%">
						' . @$currency . '&nbsp;<span id="price_' . $item['_id'] . '">' . number_format((float)$item['serviceAmount'], 2) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
						<div class="col-md-12 col-xl-12 px-0" style="margin-bottom:20px !important;">
							<div class="card shadow-0 border rounded-3 px-0" style="border-radius: unset !important;">
								<div class="card-body p-0 m-0">
									<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme)!important; color:white">
										
										<!-- Image Column -->
										<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0 service-col-img">
											<div class="bg-image hover-zoom ripple rounded ripple-surface">
												<a href="' . $src . '" data-lightbox="set">
													<div class="crop-center img-responsive bg-light services-thumb" style="background-image: url(' . $src . '); box-shadow: 2px 2px 10px #00000030; height:90px; width:100%; background-size:cover; background-repeat:no-repeat;">
														' . $available_count_design . '
													</div>
												</a>
												<a href="#!">
													<div class="hover-overlay">
														<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
													</div>
												</a>
											</div>
										</div>
										
										<!-- Service Details Column -->
										<div class="col-md-6 col-lg-7 col-xl-7 service-col-scontent" style="background-color:white!important; display: flex; flex-direction: column; align-items: flex-start;">
											
											<!-- First Row: Service Name & Eye Icon -->
											<div style="padding-left:16px; width:-webkit-fill-available;">
												<label class="pt-2" style="font-size:20px!important; margin-bottom:0;color:var(--main-color-new-theme);display:inline-flex;width: -webkit-fill-available;">
													' . replaceSingleQuotesWithBackticks($item['refDataName'])  . $descriptionEyeIcon . '
												</label>
												' . $descriptionWithEyeIcon . '
											</div>
											
											<!-- Second Row: Date/Time & Price -->
											<div style="width:-webkit-fill-available;">
												' . $dateTimeCode . '
												' . $priceType . '
											</div>
											
										</div>

					<div class="col-sm-6 col-md-6 col-lg-4 col-xl-4" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="' . $style_res_amount . '"> 

					
					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" readonly value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '"  ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					' . (
						$item["refDataName"] === "Any Amount"
						? '
							<div class="input-group" style="width: 50%; color: white;">
								<span class="input-group-text">$</span>
								<input id="anyAmtDonation' . $item["_id"] . '" 
									service-id="' . $item["_id"] . '" 
									placeholder="0.00" 
									type="text" 
									class="form-control amount-input-donations" 
									minlength="1" 
									pattern="[1-9]\d*" 
									style="background: transparent; color: white !important; font-size: 19px; font-weight: bold;" 
									value="' . (in_array($item["_id"], $session_data["ids"])
							? price_format($session_data["serviceAmount"][array_search($item["_id"], $session_data["ids"])], 2)
							: '') . '" 
									' . $disable_input_field . '>
							</div>
						'
						: '
							<span style="font-size:20px!important; font-weight:bold; margin-top: 5px;' .
						($item["qtyCounter"] !== "YES" ? ' padding-right: 36px;' : '') . '" 
								id="Totalprice_' . $item["_id"] . '">
								' . @$currency . '&nbsp;' . number_format($servicetAmount, 2) . '
							</span>
						'
					) . '
					
					

					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
				}
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}


function getPayLaterServices($serviceCategory, $session_data)
{
	// function getServicesByServiceType($serviceCategory,$serviceType, $session_data){


	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// \"serviceTypes\":\"".$serviceType."\", 


	curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceCategoryTypes": "' . $serviceCategory . '",
				"bookingType": "PAY LATER",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';

	// echo '<pre>';
	// print_r($services);
	// die;

	if ($services != array()) {

		foreach ($services as $key => $item) {




			$isValid = filterValidData($item);
			if ($isValid == 1) {

				$includeSankalpam = 'NO';
				if (isset($item['includeSankalpam']) && $item['includeSankalpam'] == 'YES') {

					$includeSankalpam = 'YES';
				}

				$cartDateCount = 0.00;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}



				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "img.jpg";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}




				if ($item['serviceAmount'] != 0) {



					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="SERVICES" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" booking_type="' . $bookingType . '"  data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" includeSankalpam="' . @$includeSankalpam . '"  available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}



					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
					}


					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0">

						<div class="input-group">
						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

						<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['description']) && $item['description'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['description'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}


					$pageLength = $key + 1;



					$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white">
					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>
					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
					</div>
					</a>
					</div>
					</div>
					<div class="col-md-6 col-lg-7 col-xl-7" style="background-color:var(--main-color-new-theme)!important;display: flex; flex-direction: row; align-items: center;">
					<div>
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					' . $descriptionWithEyeIcon . '
					' . $dateTimeCode . '
					</div>
					</div>

					<div class="col-md-6 col-lg-4 col-xl-4" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;border-left:1px solid white;"> 

					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>

					<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($item['serviceAmount']) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
				} else {


					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceAmount'] : 0) . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" booking_type="' . $bookingType . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="services_id[]" isDateTime="' . @$item['isDTVisible'] . '" includeSankalpam="' . @$includeSankalpam . '" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '">
							</div>';
						}
					}



					$html .= '<tr style="border-top:2px solid #FFEFE2;border-bottom:9px solid #FFEFE2;' . $filter_color . '">
					<td class="p-0 col-7 " style="color:#fff!important">
					<div class="col-md-12 m-0 p-0">
					<div class="row m-0 p-0">
					<div class="col-md-2 m-0 p-0">
					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px;height: 100px;width:100%;width: 83%;margin-left: 10px;">
					' . $available_count_design . '
					</div>
					</div>
					<div class="col-md-10" style="background-color:var(--main-color-new-theme)!important;">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label>
					<br>

					<div class="row m-0 p-0">
					<div class="col-md-3 m-0 p-0">
					<div class="input-group">
					<div class="input-group-addon" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-calendar" for="datepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>


					</div>
					</div>
					<div class="col-md-3">

					<div class="input-group">
					<div class="input-group-addon timepicker-services" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-right: 10px;">
					<label class="fa fa-clock-o" for="timepicker_' . $item['_id'] . '"></label>
					</div>

					<input type="text" id="timepicker_' . $item['_id'] . '" isDateTime="' . @$item['isDTVisible'] . '" class="timepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding: 0px!important;" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" ' . $disable_input_field . '>
					</div>
					</div>
					</div>

					</div>
					</div>
					</div>
					</td>
					<td class="text-center col-2 align-middle"  style="background-color:var(--main-color-new-theme);"><span></span></td>

					<td colspan="2" class="text-end col-2 align-middle"  style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;">


					<span>Request A Service</span>
					<span class="d-none" style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">$ 0.00</span>
					</td>

					<td class="text-center col-1 align-middle" style="background-color:var(--main-color-new-theme);color:#000000!important;font-weight:bold;">
					' . $checkbox . '
					</td>
					</tr>';
				}
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}


function GetServiceById($id)
{

	$serviceId = $id;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . getServiceDetailbyId()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{          
		\"_id\": \"" . $serviceId . "\",          
		\"productId\":\" " . ApiBaseUrl()['productID'] . "\",           
		\"clientId\": \"" . ApiBaseUrl()['clientID'] . "\",           
		\"username\":\"asdf\"        
	}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}


	return $serviceDetails = json_decode(json_encode($response->data[0]), true);
}


function price_format($price, $zeroAfterPoint)
{

	return sprintf("%." . $zeroAfterPoint . "f", $price);
}


function getServiceAvailibiltydata($startDate, $serviceName, $endDate = '')
{


	$date_format = DateTime::createFromFormat('m/d/Y', $startDate);
	// $startDate = $date_format->format('Y-m-d');

	if ($date_format) {
		$startDate = $date_format->format('Y-m-d');
	}
	if (!empty($endDate)) {
		$date_format_end = DateTime::createFromFormat('m/d/Y', $endDate);
		if ($date_format_end) {
			$endDate = $date_format_end->format('Y-m-d');
		}
	}

	// $date_format_end = DateTime::createFromFormat('m/d/Y', $endDate);
	// $endDate = $date_format_end->format('Y-m-d');


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . getServiceAvailability()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"clientId\": \"" . ApiBaseUrl()['clientID'] . "\", 
		\"aspectType\": \"serviceBooking\", 
		\"ServiceSetup\": \"" . $serviceName . "\", 
		\"startDate\": \"" . $startDate . "\", 
		\"endDate\": \"" . $endDate . "\", 
		\"serviceTypes\": \"VADAMALA\"
	}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	// var_dump("{
	// 		\"clientId\": \"".ApiBaseUrl()['clientID']."\", 
	// 		\"aspectType\": \"serviceBooking\", 
	// 		\"ServiceSetup\": \"".$serviceName."\", 
	// 		\"startDate\": \"".$startDate."\", 
	// 		\"endDate\": \"".$endDate."\", 
	// 		\"serviceTypes\": \"VADAMALA\"
	// 	}");


	return json_decode(json_encode($response), true);
}





function getManagementCategory()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"managementCategory\",     
			\"query\": {        
				\"aspectType\": \"managementCategory\"     
				},       
				\"skip\": 0,    
				\"next\": 1024    } }");

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);



	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response = json_decode($result, true);
}


function getUserDetails()
{

	$CI   = &get_instance();

	if ($CI->session->userdata('logged_in') == 1) {

		$email = base64_decode($CI->session->userdata('email'));
		$phone = base64_decode($CI->session->userdata('phone'));

		if (!empty($email)) {
			$data = array('email' => $email, 'isMobile' => false, 'phone' => '');
		} else if (!empty($phone)) {

			$data = array('email' => '', 'isMobile' => true, 'phone' => $phone);
		}

		$postfield = json_encode($data);

		if ($CI->session->userdata('userType') == 'Managements') {
			$moduleName = 'Management Directory';
		} else {
			$moduleName = customerLogin()['moduleName'];
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . customerLogin()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"dataJson\": $postfield,
			\"componentConfig\": {        \"moduleName\": \"" . $moduleName . "\",        \"productID\": \"" . ApiBaseUrl()['productID'] . "\",        \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\"    }}");
		$headers = array();
		$headers[] = 'Content-Type:application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$result = curl_exec($ch);
		return $response = json_decode($result);


		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
	} else {
		redirect(base_url());
	}
}


function getPriest()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Contacts\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"Member Directory\",     
			\"query\": {        \"aspectType\": \"Member Directory\",      \"memberTypes\": \"PRIEST\", \"status\": \"ACTIVE\"      },    
			\"skip\": 0,    
			\"next\": 1024    
		} 
	}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	// var_dump($response);
	// die();
	return $response;
}



function getPriestAvailibility($serviceDate, $targetTime)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/priest/getpriestAvailbilityNew');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\",
		\"serviceDate\":\"" . $serviceDate . "\",
		\"targetTime\":\"" . $targetTime . "\",
		\"priestId\":\"\",
		\"memberType\":\"PRIEST\"
	}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return $response;
}


function getServicesDisplayGroup()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {
			\"query\": {
				\"aspectType\": \"servicesDisplayGroup\" 
				}, 
				\"moduleName\": \"Master Data Management\", 
				\"aspectType\": \"servicesDisplayGroup\", 
				\"productID\": \"" . ApiBaseUrl()['productID'] . "\",
				\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",   
				\"skip\": 0, 
				\"next\": 1000
			}}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return $result;
}

function getServicesByDisplayGroup()
{
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {\"query\": {
			\"aspectType\": \"ServiceSetup\",
			\"sourceTypes\":\"WEBSITE\", 
			\"servicesDispayGroup\":\"Religious Services\", 
			\"status\": \"ACTIVE\" 
			}, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",  
			\"skip\": 0, 
			\"next\": 1024}}");


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $result;
}

function getThithiNext90Days($tithi)
{
	// var_dump("{\"componentConfig\": {\"moduleName\": \"Annual Registration\", \"aspectType\": \"annualRegistrations\",\"productID\": \"" . ApiBaseUrl()['productID'] . "\", \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", \"tithi\": \"" . $tithi . "\"}}");die();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/event/getThithiNext90Days');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {\"moduleName\": \"Annual Registration\", \"aspectType\": \"annualRegistrations\",\"productID\": \"" . ApiBaseUrl()['productID'] . "\", \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", \"tithi\": \"" . $tithi . "\"}}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';

	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	$response = json_decode($result, true);


	return $response;
}

function GetCity($stateName = '')
{
	$response = getUserDetails();
	$userDetails = $response->data[0];

	$CI = &get_instance();
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\":    {      
		\"moduleName\": \"Master Data Management\",      
		\"productID\":\"" . ApiBaseUrl()['productID'] . "\",      
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",      
		\"aspectType\":\"cityTypes\",      
		\"query\": {        \"aspectType\": \"cityTypes\",   \"refDataCode\" : \"" . $stateName . "\"   },    
		\"skip\": 0,      
		\"next\": 700    }    }");
	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	$option = '<option value="" selected disabled>Select City</option>';


	$keys = array_column($response->data, 'refDataName');
	array_multisort($keys, SORT_ASC, $response->data);



	$selected_option = '';
	if (!empty(@$userDetails->cityTypes) && @replaceSingleQuotesWithBackticks($userDetails->cityTypes) !== replaceSingleQuotesWithBackticks("DON'T KNOW")) {
		$selected_option = '<option value="' . @replaceSingleQuotesWithBackticks($userDetails->cityTypes) . '" selected>' . @replaceSingleQuotesWithBackticks($userDetails->cityTypes) . '</option>';
	}

	foreach ($response->data as $key => $item) {

		$option .= $key == 0 ? $selected_option : '';


		$option .= '<option value="' . @replaceSingleQuotesWithBackticks($item->refDataName) . '" ' . (@replaceSingleQuotesWithBackticks($item->refDataName) == @replaceSingleQuotesWithBackticks($userDetails->cityTypes) ? 'selected' : '') . '>' . @replaceSingleQuotesWithBackticks($item->refDataName) . '</option>';
	}

	echo $option;
}
function GetState()
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\":    {      \"moduleName\": \"Master Data Management\",      \"productID\":\"" . ApiBaseUrl()['productID'] . "\",      \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",      \"aspectType\":\"stateTypes\",      \"query\": {        \"aspectType\": \"stateTypes\"      },  \"skip\": 0,      \"next\": 700    }    }");

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response->data;
}


function VolunteerTypes()
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\":    {      \"moduleName\": \"Master Data Management\",      \"productID\":\"" . ApiBaseUrl()['productID'] . "\",      \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",      \"aspectType\":\"volunteerArea\",      \"query\": {        \"aspectType\": \"volunteerArea\"      },  \"skip\": 0,      \"next\": 700    }    }");

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response->data;
}

function getPreferredLocations()
{
	$CI = &get_instance();
	$userName = $CI->session->userdata('refDataName');

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"serviceRequestCategory\",     
			\"query\": {        
				\"aspectType\": \"serviceRequestCategory\"     
				},   
				\"userName\": \"" . $userName . "\",     
				\"skip\": 0,    
				\"next\": 1024    } }");


	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	// var_dump(json_decode($result)['data']);
	return	 $response = json_decode($result);



	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
}




function getPreferredLanguage()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"languageTypes\",     
			\"query\": {        
				\"aspectType\": \"languageTypes\"     
				},      
				\"skip\": 0,    
				\"next\": 1024    } }");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return 	$response;
}



function GetVotingDetailsRegister($memberDirectory, $meetingname)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {
			\"moduleName\": \"Voting Detail Register\",
			\"aspectType\": \"votingDetailRegister\",
			\"productID\":\"" . ApiBaseUrl()['productID'] . "\",
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",
			\"query\": {
				\"aspectType\": \"votingDetailRegister\",
				\"Parent.refDataName1\":\"" . $memberDirectory . "\",
				\"Parent.refDataName\":\"" . $meetingname . "\"
				},
				\"skip\":0,
				\"next\":100
			}}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return json_decode($result, true);
}



function getDonationsByDonationsTypes2($donationTypes, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// \"serviceTypes\":\"".$serviceType."\", 


	curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceTypes":"' . $donationTypes . '",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);


	$html = '';


	if ($services != array()) {

		foreach ($services as $key => $item) {


			$pageLength = $key + 1;
			// echo $item['qtyCounter'];

			if ($item['qtyCounter'] == 'YES') {
				$quantityContainer_display = 'inline-flex';
			} else {
				$quantityContainer_display = 'none';
			}



			if (isset($item['Image']) && !empty($item['Image'])) {
				$src = ApiBaseUrl()['url'] . $item['Image'];
			} else {
				$src = base_url('assets/img/') . "logo.png";
			}

			$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

			$available_count_design = '';
			$filter_color = '';
			$available_count = '';
			$disable_input_field = '';
			$disable_input_field = '';

			if ($item['serviceAmount'] == 0 || $item['serviceAmount'] == 0.00 || $item['serviceAmount'] == null || $item['serviceAmount'] == "") {



				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$disable_input_field = 'disabled readonly';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
				} else {

					if ($is_availibility_check == 3) {
						$disable_input_field = '';
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}
						$checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" data-servicedesc="" is_date_required="' . $item['isDTVisible'] . '" >
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						$checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" data-servicedesc="" is_date_required="' . $item['isDTVisible'] . '" >
						</div>';
						$disable_input_field = '';
					}
				}

				$item['serviceAmount'] = 1;
				$amountSection = '<div class="input-group" style="width: 50%;">
				<span class="input-group-text">$</span>
				<input id="anyAmtDonation' . $item['_id'] . '" service-id="' . $item['_id'] . '" placeholder="0.00" type="text" class="form-control amount-input-donations" placeholder="enter amount you like to donate"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  '') . '" ' . $disable_input_field . '>
				</div>


				<div class="d-none col-md-12" style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';
			} else {
				$amountSection = '<div style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';


				$checkbox = '<div class="form-check">
				<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_date_required="' . $item['isDTVisible'] . '">
				</div>';
			}

			if (isset($item['description']) && $item['description'] != '') {
				$descriptionWithEyeIcon = '<style>
				.collapse.in { display: inline !important; }
				</style>

				<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
				' . $item['description'] . '
				</span> 
				<span>
				<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
				</span>';
			} else {
				$descriptionWithEyeIcon = '';
			}

			$priceType = '';

			if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


				$priceTypeString = $item['priceType'];


				$priceTypeArray = json_decode($priceTypeString, true);

				if ($priceTypeArray != array()) {

					$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


					foreach ($priceTypeArray as $index => $option) {

						$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])] == $option['key'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' </option>';
					}

					$priceType .= '</select>';
				}
			}



			if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {

				$date_value = 'value="' . $item['startDate'] . '"';
			} else if (isset($item['startDate']) && $item['startDate']) {

				$date_value = 'value="' . $item['startDate'] . '" disabled';
			} else {

				if (in_array($item['_id'], $session_data['ids'])) {
					$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
				} else {

					if (isset($item['dayTypes']) && !empty($item['dayTypes'])) {
						$date_value = 'value=""';
					} else {

						$date_value = 'value="' . date('m/d/Y') . '"';
					}
				}
			}



			if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
				$dateTimeCode = '';
				$dateTimeCode = '<div class="row m-0 pt-3">
				<div class="col-md-8 m-0 p-0">
				<div class="input-group">
				<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;padding-left: 0;" id="basic-addon1"><i class="fa fa-calendar"></i></span>
				
				<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" is_date_required="' . $item['isDTVisible'] . '">

				</div>
				</div>



				</div>';
			} else {
				$dateTimeCode = '';
			}



			$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
			</div><div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '"> <div class="col-md-12 col-xl-12 px-0"> <div class="card shadow-0 border rounded-3 px-0"> <div class="card-body p-0 m-0"> <div class="row" id="searchHere" style="background-color:var(--main-color-new-theme) ;color:white; --bs-gutter-x: -1rem !important;"> <div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0"> 
			
			<div class="bg-image hover-zoom ripple rounded ripple-surface"> 
			<a href="' . $src . '" data-lightbox="set">
			<img src="' . $src . '" class="crop-center img-responsive bg-light services-thumb" style="border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat; font-weight:bold;">' . $available_count_design . '
			</a>
			
			<a href="#!"> <div class="hover-overlay"> <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div> </div> </a> </div> </div> <div class="col-md-6 col-lg-7 col-xl-7" style="background-color:var(--main-color-new-theme) !important;display: flex; flex-direction: row; align-items: center;"> <div> 

			<label class="pt-2 services-title" style="padding-left: 12px;font-size:20px!important;font-weight:800!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br>

			' . $descriptionWithEyeIcon . '
			' . $dateTimeCode . '
			' . $priceType . ' 

			</div> 

			</div> 

			<div class="col-md-6 col-lg-4 col-xl-4" style=" display: flex; flex-direction: column; justify-content: center; ">

			<div class="res-amount res-amount-' . $item['_id'] . '" style="display: flex!important; flex-direction: row; justify-content: space-evenly; align-items: stretch;"> 

			


			' . $amountSection . '

			


			' . $checkbox . '



			</div> </div> </div> </div> </div> </div> </div><input type="hidden" value="' . $pageLength . '" id="pageLength">';
		}
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

function getDonationsByDonationsTypes($donationTypes, $session_data)
{

	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// \"serviceTypes\":\"".$serviceType."\", 


	curl_setopt($ch, CURLOPT_POSTFIELDS, '{
		"componentConfig": {
			"query": {
				"aspectType": "ServiceSetup",
				"serviceTypes":"' . $donationTypes . '",
				"sourceTypes": "WEBSITE",
				"status": "ACTIVE"
				},
				"moduleName": "Temple Services",
				"aspectType": "ServiceSetup",
				"collectionType": "Business",
				"productID": "' . ApiBaseUrl()['productID'] . '",
				"clientID": "' . ApiBaseUrl()['clientID'] . '",
				"skip": 0,
				"next": 1024
			}
		}');


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);


	$html = '';


	if ($services != array()) {

		foreach ($services as $key => $item) {


			$pageLength = $key + 1;
			// echo $item['qtyCounter'];

			if ($item['qtyCounter'] == 'YES') {
				$quantityContainer_display = 'inline-flex';
			} else {
				$quantityContainer_display = 'none';
			}



			if (isset($item['Image']) && !empty($item['Image'])) {
				$src = ApiBaseUrl()['url'] . $item['Image'];
			} else {
				$src = base_url('assets/img/') . "logo.png";
			}

			$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

			$available_count_design = '';
			$filter_color = '';
			$available_count = '';
			$disable_input_field = '';
			$disable_input_field = '';

			if ($item['serviceAmount'] == 0 || $item['serviceAmount'] == 0.00 || $item['serviceAmount'] == null || $item['serviceAmount'] == "") {



				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$disable_input_field = 'disabled readonly';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
				} else {

					if ($is_availibility_check == 3) {
						$disable_input_field = '';
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}
						$checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" data-servicedesc="" is_date_required="' . $item['isDTVisible'] . '" isTextinputBox="'.@$item['isTextinputBox']. '" >
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						$checkbox = '<div class="form-check">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" data-servicedesc="" is_date_required="' . $item['isDTVisible'] . '" isTextinputBox="'.@$item['isTextinputBox']. '" >
						</div>';
						$disable_input_field = '';
					}
				}

				$item['serviceAmount'] = 1;
				$amountSection = '<div class="input-group" style="width: 50%;">
				<span class="input-group-text">$</span>
				<input id="anyAmtDonation' . $item['_id'] . '" service-id="' . $item['_id'] . '" placeholder="0.00" type="text" class="form-control amount-input-donations" placeholder="enter amount you like to donate"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  '') . '" ' . $disable_input_field . '>
				</div>


				<div class="d-none col-md-12" style="padding: 0px 30px;font-size:20px!important;margin-top:5px;">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';
			} else {
				$amountSection = '<div style="padding: 0px 30px;font-size:20px!important;margin-top:5px;">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';


				$checkbox = '<div class="form-check">
				<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 9px;padding:14px!important" data-servicedesc="' . (in_array($item['_id'], @$session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_date_required="' . $item['isDTVisible'] . '">
				</div>';
			}

			if (isset($item['description']) && $item['description'] != '') {
				$descriptionEyeIcon = '<style>
				.collapse.in { display: inline !important; }
				</style>

				&nbsp;<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false"><i class="fa fa-eye" style="color: #0015a2;font-size: 17px;margin-top: -3px;width: fit-content;"></i></a>
				';
				$descriptionWithEyeIcon = '
				<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="color:var(--main-color-new-theme);">
				' . $item['description'] . '
				</span> 
				';
			} else {
				$descriptionEyeIcon = '';
				$descriptionWithEyeIcon = '';
			}

			$priceType = '';

			if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


				$priceTypeString = $item['priceType'];


				$priceTypeArray = json_decode($priceTypeString, true);

				if ($priceTypeArray != array()) {

					$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


					foreach ($priceTypeArray as $index => $option) {

						$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])] == $option['key'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' </option>';
					}

					$priceType .= '</select>';
				}
			}



			if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {

				$date_value = 'value="' . $item['startDate'] . '"';
			} else if (isset($item['startDate']) && $item['startDate']) {

				$date_value = 'value="' . $item['startDate'] . '" disabled';
			} else {

				if (in_array($item['_id'], $session_data['ids'])) {
					$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
				} else {

					if (isset($item['dayTypes']) && !empty($item['dayTypes'])) {
						$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
					} else {

						$date_value = 'value="' . date('m/d/Y') . '"';
					}
				}
			}



			if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
				$dateTimeCode = '';
				$dateTimeCode = '<div class="row m-0 pt-3" style="margin-top: -14px !important;">
				<div class="col-sm-12 col-md-8 m-0 p-0 date-col-div">
				<div class="input-group">
				<span class="input-group-text" style="color:var(--main-color-new-theme)!important;background-color: #e9ecef00;border: 1px solid #ced4da00;padding-left: 0;" id="basic-addon1"><i class="fa fa-calendar"></i></span>
				
				<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" is_date_required="' . $item['isDTVisible'] . '">

				</div>
				</div>



				</div>';
			} else {
				$dateTimeCode = '';
			}



			$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme)!important;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
			</div><div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '"> <div class="col-md-12 col-xl-12 px-0" style="margin-bottom: 5px;"> <div class="card shadow-0 border rounded-3 px-0"style="border-radius: unset !important;"> <div class="card-body p-0 m-0"> <div class="row" id="searchHere" style="background-color:var(--main-color-new-theme)!important; color:white"> <div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0 service-col-img"> 
			
			<div class="bg-image hover-zoom ripple rounded ripple-surface"> 
			<a href="' . $src . '" data-lightbox="set">
			<img src="' . $src . '" class="crop-center img-responsive bg-light services-thumb" style="box-shadow: 2px 2px 10px #00000030; height: 100px;width:100%;background-size: cover; background-repeat: no-repeat; font-weight:bold;">' . $available_count_design . '
			</a>
			
			<a href="#!"> 
				<div class="hover-overlay"> 
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div> 
				</div>
			</a> 
			</div> 
			</div> 
			<div class="col-md-6 col-lg-7 col-xl-7 service-col-scontent" style="background-color:white!important; display: flex; flex-direction: column; align-items: flex-start;"> 
			<div style="width:100%"> 

				<label class="pt-2" style="font-size:20px!important; color:#000000!important; margin-bottom: 0;">';
			if (isset($item['isTextinputBox']) && $item['isTextinputBox'] == 'YES') {
				$html .= '<div class="input-group">
						<input type="text" id="serviceDesc' . $item['_id'] . '" oninput="serviceDesc(this,`' . $item['_id'] . '`)"  class="form-control form-control-sm" style="color: #000000ff;opacity: 1;padding:3px!important;font-weight: 700 !important;font-size: 14px !important;" placeholder="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" >
						</div>';
			} else {
				$html .= replaceSingleQuotesWithBackticks($item['refDataName']);
			}
			$html .= '</label>
												' . $descriptionWithEyeIcon . '
			' . $dateTimeCode . '
			' . $priceType . ' 

			</div> 

			</div> 

			<div class="col-md-6 col-lg-4 col-xl-4" style=" display: flex; flex-direction: column; justify-content: center; ">

			<div class="res-amount res-amount-' . $item['_id'] . '" style=""> 

			


			' . $amountSection . '

			


			' . $checkbox . '



			</div> </div> </div> </div> </div> </div> </div><input type="hidden" value="' . $pageLength . '" id="pageLength">';
		}
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}


function getDonationsCatTypes()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Master Data Management\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"serviceTypes\",     
		\"query\": {        \"aspectType\": \"serviceTypes\", \"refDataCode\": \"DONATIONS\", \"status\": \"ACTIVE\" },   
		\"userName\": \"\",     
		\"skip\": 0,    
		\"next\": 1024    
	} }");
	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);
	// print_r($response->data);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	return json_decode(json_encode($response->data), true);
}


function convert_date_range_format($start_date, $end_date)
{
	list($start_month, $start_day, $start_year) = explode('/', $start_date);
	list($end_month, $end_day, $end_year) = explode('/', $end_date);
	$start_month = DateTime::createFromFormat('!m', $start_month)->format('M');
	$end_month = DateTime::createFromFormat('!m', $end_month)->format('M');
	$output_date_range = $start_month . ' ' . $start_day . ' - ' . $end_month . ' ' . $end_day;
	return $output_date_range;
}


// **********************************Rentals Functions**************************



function GetRentalTypes()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/appgen/filterAPI');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{      
		\"componentConfig\": {        
			\"moduleName\": \"Master Data Management\",        
			\"aspectType\": \"rentalTypes\",        
			\"productID\":\"" . ApiBaseUrl()['productID'] . "\",        
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",        
			\"query\": {          
				\"aspectType\": \"rentalTypes\"        
				},        
				\"skip\":0,        
				\"next\":1024
			}}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return json_decode($result, true);
}


function getRentalServicesByRentalTypes($refDataCode, $refDataname, $session_data = '')
{
	$CI = &get_instance();

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/appgen/filterAPI');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$data = [
		"componentConfig" => [
			"moduleName" => "Rental Setup",
			"aspectType" => "rentalSetup",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"query" => [
				"aspectType" => "rentalSetup",
				"rentalCategory" => $refDataCode,
				"refDataCode" => $refDataname
			],
			"skip" => 0,
			"next" => 1024
		]
	];

	$postData = json_encode($data);

	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$response = json_decode($result, true);


	$rentals = $response['data'];
	$rentals = sortBySequenceId($rentals);

	$currency = getCurrencySymbol();
	$html = '';
	// echo '<pre>';
	// print_r($rentals); die();

	if ($rentals != array()) {

		foreach ($rentals as $key => $item) {




			$isValid = filterValidData($item);
			if ($isValid == 1) {

				// if (isset($item['rentalBookingTypes']) && CheckEmptyNullVar($item['rentalBookingTypes']) != '') {

				// 	$rental_booking_types = $item['rentalBookingTypes'];



				// 	$options = json_decode($rental_booking_types);
				// 	$rental_booking_types_options =  '<select style="padding: 4px; border-radius: 5px; margin-bottom: 10px;" id="booking_type'.$item['_id'].'" onchange="showSection(this, `'.$item['_id'].'`)">';
				// 	$rental_booking_types_options .=  '<option value=" " selected disabled>Select Type</option>';
				// 	foreach ($options as $option) {
				// 		$rental_booking_types_options .= "<option value='$option'".((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['bookingTypes'][array_search($item['_id'], $session_data['ids'])] == $option ? 'selected' : '')  : '').">".$option."</option>";
				// 	}
				// 	$rental_booking_types_options .=  '</select>';

				// }else{

				// 	$rental_booking_types_options = '';
				// }




				$priceType = '';

				if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


					$priceTypeString = $item['priceType'];


					$priceTypeArray = json_decode($priceTypeString, true);

					if ($priceTypeArray != array()) {

						$priceType = '<select id="booking_type' . $item['_id'] . '" class="price_types p-2 mt-2" style="padding: 4px; border-radius: 5px; margin-bottom: 10px;"  onchange="showSection(this, `' . $item['_id'] . '`)">';

						$priceType .=  '<option value=" " selected disabled>Select Type</option>';

						foreach ($priceTypeArray as $index => $option) {

							$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['initial_amt_hourly'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . '</option>';
						}

						$priceType .= '</select>';
					}
				}


				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['image']) && !empty($item['image'])) {
					$src = ApiBaseUrl()['url'] . $item['image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  @$item['costPerUnit'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  @$item['costPerUnit'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  @$item['costPerUnit'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}


				$pageLength = $key + 1;

				if (isset($item['costPerUnit']) && @$item['costPerUnit'] != 0) {



					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . @$item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . @$item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], @$session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '">
							</div>';
						}
					}

					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
					}

					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">

						

						' . @$priceType . '

						
						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "HOURLY" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "MORNING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "EVENING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "AFTERNOON" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "FULL DAY" ? '' : 'd-none')  : 'd-none') . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" type="text" class="time_picker_start hasTimepicker start" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" type="text" class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}









					$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format(@$item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:var(--main-color-new-theme)!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format(@$item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
				} else {


					$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

					$available_count_design = '';
					$filter_color = '';
					$available_count = '';
					$disable_input_field = '';

					if ($is_availibility_check == 1) {
						$available_count_design = '';
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {

						if ($is_availibility_check == 3) {
							if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							} else {
								$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
							}
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . @$item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '">
							</div>';
						} else if ($is_availibility_check == 2) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . @$item['costPerUnit'] . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], @$session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '">
							</div>';
						}
					}

					$limitPerdayFeature = '';
					$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
					$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

					if ($BookingLimitPerDay > 0) {

						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
					}

					if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
						$dateTimeCode = '';
						$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">

						

						' . @$priceType . '

						
						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "HOURLY" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "MORNING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "EVENING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "AFTERNOON" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "FULL DAY" ? '' : 'd-none')  : 'd-none') . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" type="text" class="time_picker_start hasTimepicker start" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" type="text" class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>

						</div>';
					} else {
						$dateTimeCode = '';
					}

					if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
						$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
					} else {
						$descriptionWithEyeIcon = '';
					}









					$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format(@$item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:var(--main-color-new-theme)!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format(@$item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					';
				}
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

function addRentalServiceCart()
{

	$data = array(
		'url' => "api/bookingService/addRentalServiceCart"
	);
	return $data;
}



function getCurrencySymbol()
{
	$GeneralSettings = GeneralSettings();

	$currencySymbol = isset($GeneralSettings['currencySymbol']) ? (CheckEmptyNullVar($GeneralSettings['currencySymbol']) != '' ? $GeneralSettings['currencySymbol'] : '$') : '$';

	return $currencySymbol;
}

function getSponsorTypes($serviceType = '')
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	$url = ApiBaseUrl()['url'] . filterAPI()['url'];

	if ($serviceType != '') {
		$data = array(
			'componentConfig' => array(
				'query' => array(
					'aspectType' => 'serviceTypes',
					'refDataCode' => 'SPONSORSHIP',
					'refDataName' => $serviceType
				),
				'moduleName' => 'Master Data Management',
				'aspectType' => 'serviceTypes',
				'productID' => ApiBaseUrl()['productID'],
				'clientID' => ApiBaseUrl()['clientID'],
				'skip' => 0,
				'next' => 1000
			)
		);
	} else {
		$data = array(
			'componentConfig' => array(
				'query' => array(
					'aspectType' => 'serviceTypes',
					'refDataCode' => 'SPONSORSHIP'
				),
				'moduleName' => 'Master Data Management',
				'aspectType' => 'serviceTypes',
				'productID' => ApiBaseUrl()['productID'],
				'clientID' => ApiBaseUrl()['clientID'],
				'skip' => 0,
				'next' => 1000
			)
		);
	}


	$headers = array(
		'Content-Type: application/json'
	);

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	if (curl_errno($ch)) {
		echo 'Error: ' . curl_error($ch);
	}

	curl_close($ch);

	$response = json_decode($result);

	return json_decode(json_encode($response->data), true);
}


function getSponsorTypesServicesByServiceType2($serviceType, $session_data, $parentId = '')
{


	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// \"serviceTypes\":\"".$serviceType."\", 

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {\"query\": {
			\"aspectType\": \"ServiceSetup\",
			\"serviceCategoryTypes\":\"SPONSORSHIP\", 
			\"serviceTypes\":\"" . $serviceType . "\", 
			\"sourceTypes\":\"WEBSITE\", 
			\"parentService\":null, 
			\"status\": \"ACTIVE\" }, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';

	// var_dump($services);



	if ($services != array()) {

		foreach ($services as $key => $item) {




			$isValid = filterValidData($item);
			if ($isValid == 1) {


				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}



				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}

				if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
					$serviceOccurrencesNo = $item['serviceOccurrencesNo'];
				} else {
					$serviceOccurrencesNo = '';
				}


				if (!isset($item['isDTVisible']) && !isset($item['isdtVisible'])) {
					$item['isDTVisible'] = 'NO';
				} else {
					$item['isDTVisible'] = isset($item['isDTVisible']) ? $item['isDTVisible'] : $item['isdtVisible'];
				}



				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}

						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
						<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . trim($item['description']) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc=""  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '">
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {


						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . trim($item['description']) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '"  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '">
							</div>';
					}
				}



				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . ' start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
				} else {

					// if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



					// 	if (!empty($item['dayTypes'])) {

					// 		$date_value = 'value=""';
					// 	} else {
					// 		$date_value = 'value="' . date('m/d/Y') . '"';
					// 	}
					// } else if (isset($item['startDate']) && $item['startDate']) {
					// 	$date_value = 'value="' . $item['startDate'] . '" disabled';
					// } else {

					// 	if (in_array($item['_id'], $session_data['ids'])) {
					// 		$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
					// 	} else {
					// 		// $date_value = 'value="' . date('m/d/Y') . '"';
					// 		$date_value = 'value=""';
					// 	}
					// }

					if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



						if (!empty($item['dayTypes'])) {
							if (in_array($item['_id'], $session_data['ids'])) {
								if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
									$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
									if (!empty($selectedDate) && is_string($selectedDate)) {
										$date_value = 'value="' . ($selectedDate) . '"';
										$selectedDate = explode(", ", $selectedDate);
										$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
										$date_value1 = 'value="' . ($selectedDate1) . '"';
									} else {
										$date_value1 = 'value="' . ($selectedDate) . '"';
										$date_value = 'value="' . ($selectedDate) . '"';
									}
								} else {
									$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								}
							} else {

								$date_value = 'value=""';
								$date_value1 = 'value=""';
							}
						} else {
							$date_value = 'value="' . date('m/d/Y') . '"';
							$date_value1 = 'value="' . date('m/d/Y') . '"';
						}
					} else if (isset($item['startDate']) && $item['startDate']) {
						$date_value = 'value="' . $item['startDate'] . '" disabled';
						$date_value1 = 'value="' . $item['startDate'] . '" disabled';
					} else {

						if (in_array($item['_id'], $session_data['ids'])) {
							if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
								$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
								if (!empty($selectedDate) && is_string($selectedDate)) {
									$date_value = 'value="' . ($selectedDate) . '"';
									$selectedDate = explode(", ", $selectedDate);
									$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
									$date_value1 = 'value="' . ($selectedDate1) . '"';
								} else {
									$date_value1 = 'value="' . ($selectedDate) . '"';
									$date_value = 'value="' . ($selectedDate) . '"';
								}
							} else {
								$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
							}
						} else {
							// $date_value = 'value="' . date('m/d/Y') . '"';
							$date_value = 'value=""';
							$date_value1 = 'value=""';
						}
					}

					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="d-none datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker1_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value1 . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px; width: -webkit-fill-available; margin-top: -29px; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  select_date="' . @$item['selectDate'] . '" end_date="' . @$item['endDate'] . '">';
					}
				}
				$limitPerdayFeature .= '<span  id="datepickerCount_' . $item['_id'] . '"></span>';
				/*if ($BookingLimitPerDay > 0) {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				} else {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				}*/


				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
					$dateTimeCode = '';
					$dateTimeCode = '<div class="row m-0 pt-3">
					<div class="col-md-12 m-0 p-0">
					<div class="input-group">
					<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

					' . $limitPerdayFeature . '
					</div>
					</div>

					<div class="col-md-4 p-0">

					<div class="input-group">
					<span class="input-group-text" style="color: var(--main-color-new-theme);background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-clock-o"></i></span>

					<input type="text" id="timepicker_' . $item['_id'] . '"  class="form-control form-control-sm timepicker-services date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important" ' . (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . '  placeholder="--:--" >
					</div>

					</div>

					</div>';
				} else {
					$dateTimeCode = '';
				}
				// $dateTimeCode.='/'.$item['isDTVisible'];

				if (isset($item['description']) && $item['description'] != '') {
					$descriptionWithEyeIcon = '<style>
					.collapse.in { display: inline !important; }
					</style>

					<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
					' . $item['description'] . '
					</span> 
					<span>
					<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
					</span>';
				} else {
					$descriptionWithEyeIcon = '';
				}


				$pageLength = $key + 1;



				$priceType = '';

				if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


					$priceTypeString = $item['priceType'];


					$priceTypeArray = json_decode($priceTypeString, true);

					if ($priceTypeArray != array()) {

						$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


						foreach ($priceTypeArray as $index => $option) {

							$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' (' . $currency . ' ' . price_format($option['value'], 2) . ')</option>';
						}

						$priceType .= '</select>';
					}
				}



				if ($item['serviceAmount'] != 0 && $item['serviceAmount'] != '') {



					if ($quantityContainer_display == 'none') {

						$amountSection = '<span style="font-size:20px!important;font-weight:bold;margin-right: 25px;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
					} else {
						$amountSection = '<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
					}
				} else {

					$item['serviceAmount'] = 1;
					if ($quantityContainer_display == 'none') {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
					<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
					</div>


					<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important;margin-right: 25px;">
					' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>';
					} else {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
						<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
						</div>
	
	
						<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important">
						' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
						</div>';
					}
				}



				$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
				</div>
				<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
				<div class="col-md-12 col-xl-12 px-0">
				<div class="card shadow-0 border rounded-3 px-0">
				<div class="card-body p-0 m-0">
				<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white;--bs-gutter-x: -1rem !important;">
				<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
				<div class="bg-image hover-zoom ripple rounded ripple-surface">
				<div class="crop-center img-responsive bg-light services-thumb" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>
				<a href="#!">
				<div class="hover-overlay">
				<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
				</div>
				</a>
				</div>
				</div>
				<div class="col-md-6 col-lg-6 col-xl-8" style="background-color:var(--main-color-new-theme) !important;display: flex; flex-direction: row; align-items: center;">
				<div style="width: 100%;">
				<label class="pt-2 services-title" style="padding-left: 12px;font-size:20px!important;font-weight:800!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
				' . $descriptionWithEyeIcon . '
				' . $dateTimeCode . '
				' . $priceType . '
				</div>
				</div>';
				if ($quantityContainer_display == 'none') {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">
				<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: end; align-items: stretch;padding: 0px;border-left:1px solid white;"> ';
				} else {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 10px 0px 25px">
			<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;border-left:1px solid white;"> ';
				}
				$html .= '

				<div class="quantity-container" style="display:' . $quantityContainer_display . '">

				<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

				<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly>

				<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme);color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

				</div>




				' . $amountSection . '
				' . $checkbox . '
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				<input type="hidden" value="' . $pageLength . '" id="pageLength">';
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}

	return $html;
}


function getSponsorTypesServicesByServiceType($serviceType, $session_data, $parentId = '')
{


	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// \"serviceTypes\":\"".$serviceType."\", 

	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {\"query\": {
			\"aspectType\": \"ServiceSetup\",
			\"serviceCategoryTypes\":\"SPONSORSHIP\", 
			\"serviceTypes\":\"" . $serviceType . "\", 
			\"sourceTypes\":\"WEBSITE\", 
			\"parentService\":null, 
			\"status\": \"ACTIVE\" }, 
			\"moduleName\": \"Temple Services\", 
			\"aspectType\": \"ServiceSetup\", 
			\"collectionType\": \"Business\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';

	// var_dump($services);



	if ($services != array()) {
		$deities_data = getWebSyncsData('Diety', 'Diety Directory', '');
		foreach ($services as $key => $item) {




			$isValid = filterValidData($item);
			if ($isValid == 1) {


				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}



				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}

				if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
					$serviceOccurrencesNo = $item['serviceOccurrencesNo'];
				} else {
					$serviceOccurrencesNo = '';
				}


				if (!isset($item['isDTVisible']) && !isset($item['isdtVisible'])) {
					$item['isDTVisible'] = 'NO';
				} else {
					$item['isDTVisible'] = isset($item['isDTVisible']) ? $item['isDTVisible'] : $item['isdtVisible'];
				}



				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}

						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
						<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . trim($item['description']) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc=""  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '"   isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {


						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . trim($item['description']) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '"  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '"   isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
							</div>';
					}
				}



				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . ' start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
				} else {

					// if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



					// 	if (!empty($item['dayTypes'])) {

					// 		$date_value = 'value=""';
					// 	} else {
					// 		$date_value = 'value="' . date('m/d/Y') . '"';
					// 	}
					// } else if (isset($item['startDate']) && $item['startDate']) {
					// 	$date_value = 'value="' . $item['startDate'] . '" disabled';
					// } else {

					// 	if (in_array($item['_id'], $session_data['ids'])) {
					// 		$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
					// 	} else {
					// 		// $date_value = 'value="' . date('m/d/Y') . '"';
					// 		$date_value = 'value=""';
					// 	}
					// }

					if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



						if (!empty($item['dayTypes'])) {
							if (in_array($item['_id'], $session_data['ids'])) {
								if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
									$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
									if (!empty($selectedDate) && is_string($selectedDate)) {
										$date_value = 'value="' . ($selectedDate) . '"';
										$selectedDate = explode(", ", $selectedDate);
										$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
										$date_value1 = 'value="' . ($selectedDate1) . '"';
									} else {
										$date_value1 = 'value="' . ($selectedDate) . '"';
										$date_value = 'value="' . ($selectedDate) . '"';
									}
								} else {
									$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								}
							} else {

								$date_value = 'value=""';
								$date_value1 = 'value=""';
							}
						} else {
							$date_value = 'value="' . date('m/d/Y') . '"';
							$date_value1 = 'value="' . date('m/d/Y') . '"';
						}
					} else if (isset($item['startDate']) && $item['startDate']) {
						$date_value = 'value="' . $item['startDate'] . '" disabled';
						$date_value1 = 'value="' . $item['startDate'] . '" disabled';
					} else {

						if (in_array($item['_id'], $session_data['ids'])) {
							if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
								$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
								if (!empty($selectedDate) && is_string($selectedDate)) {
									$date_value = 'value="' . ($selectedDate) . '"';
									$selectedDate = explode(", ", $selectedDate);
									$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
									$date_value1 = 'value="' . ($selectedDate1) . '"';
								} else {
									$date_value1 = 'value="' . ($selectedDate) . '"';
									$date_value = 'value="' . ($selectedDate) . '"';
								}
							} else {
								$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
							}
						} else {
							// $date_value = 'value="' . date('m/d/Y') . '"';
							$date_value = 'value=""';
							$date_value1 = 'value=""';
						}
					}

					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="d-none datepicker-services1 form-control form-control-sm date-time-placeholder" style="color:var(--main-color-new-theme);background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker1_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color:var(--main-color-new-theme);background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value1 . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '">';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder1" style="color:var(--main-color-new-theme);background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px; width: -webkit-fill-available; margin-top: -29px; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  select_date="' . @$item['selectDate'] . '" end_date="' . @$item['endDate'] . '">';
					}
				}
				$limitPerdayFeature .= '<span  id="datepickerCount_' . $item['_id'] . '" style="color:color:var(--main-color-new-theme);"></span>';
				/*if ($BookingLimitPerDay > 0) {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				} else {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				}*/


				/*if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
					$dateTimeCode = '';
					$dateTimeCode = '<div class="row m-0 pt-3" style="margin-top: -14px !important;">
						<!-- Date Section (8 columns) -->
						<div class="col-sm-4 col-md-8 m-0 p-0 date-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:var(--main-color-new-theme);; background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-calendar"></i>
								</span>
								' . $limitPerdayFeature . '
							</div>
						</div>
						<!-- Time Section (4 columns) -->
						<div class="col-sm-4 col-md-4 p-0 time-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:var(--main-color-new-theme); background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-clock-o"></i>
								</span>
								<input type="text" id="timepicker_' . $item['_id'] . '" class="form-control form-control-sm timepicker-services date-time-placeholder1" style="color:var(--main-color-new-theme); background-color: #ffffff00; opacity: 1; border: 0; padding: 0px!important;" '
						. (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ? 'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"' : ''))
						. ' placeholder="--:--" ' . $disable_input_field . '>
							</div>
						</div>
					</div>';
				} else {
					$dateTimeCode = '';
				}*/


				// $dateTimeCode.='/'.$item['isDTVisible'];

				$deities_html = '';
				if (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES') {
					$deities_html .= '<div class="col-sm-4">
					<select class="form-control" id="dietyName_' . $item['_id'] . '" style="font-size: .875rem;" onchange="addTocart();">
					<option value="" selected disabled>--select diety--</option>';
					foreach ($deities_data as $deity) {
						$selected = '';
						if (!empty($session_data['ids']) && !empty($session_data['dietyName'])) {
							$index = array_search($item['_id'], $session_data['ids']);
							if ($index !== false && isset($session_data['dietyName'][$index]) && $session_data['dietyName'][$index] == $deity['refDataName']) {
								$selected = 'selected';
							}
						}

						$deities_html .= '<option value="' . $deity['refDataName'] . '" ' . $selected . '>' . htmlspecialchars($deity['refDataName']) . '</option>';
					}


					$deities_html .= '</select>
					</div>';
				}

				$dateTimeCode = '';
				$dateCode = '';

				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {

					$dateCode = '
						<!-- Date Section (8 columns) -->
						<div class="col-sm-4 col-md-8 m-0 p-0 date-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:var(--main-color-new-theme);; background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-calendar"></i>
								</span>
								' . $limitPerdayFeature . '
							</div>
						</div>';
				}


				$TimeCode = '';
				if (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') {

					$TimeCode = '
						<!-- Time Section (4 columns) -->
						<div class="col-sm-4 col-md-4 p-0 time-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:#000000!important; background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-clock-o"></i>
								</span>
								<input type="text" id="timepicker_' . $item['_id'] . '" _id="' . $item['_id'] . '" data-dt-visible="' . (isset($item['isDTVisible']) ? $item['isDTVisible'] : 'NO') . '"  class="form-control form-control-sm timepicker-services date-time-placeholder1" style="color:#000000; background-color: #ffffff00; opacity: 1; border: 0; padding: 0px!important;" '
						. (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ? 'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"' : ''))
						. ' placeholder="--:--" ' . $disable_input_field . '>
							</div>
						</div>';
				}

				if ((isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') || (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') || (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES')) {
					$dateTimeCode = '<div class="row m-0 pt-3" style="margin-top: -14px !important;">' . $deities_html . $dateCode . $TimeCode . '</div>';
				}

				if (isset($item['description']) && $item['description'] != '') {
					$descriptionEyeIcon = '<style>
					.collapse.in { display: inline !important; }
					</style>

					&nbsp;<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false"><i class="fa fa-eye" style="color: #0015a2;font-size: 17px;margin-top: -3px;width: fit-content;"></i></a>
					';
					$descriptionWithEyeIcon = '
					<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="color:var(--main-color-new-theme);">
					' . $item['description'] . '
					</span> 
					';
				} else {
					$descriptionEyeIcon = '';
					$descriptionWithEyeIcon = '';
				}



				$pageLength = $key + 1;



				$priceType = '';

				if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


					$priceTypeString = $item['priceType'];


					$priceTypeArray = json_decode($priceTypeString, true);

					if ($priceTypeArray != array()) {

						$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


						foreach ($priceTypeArray as $index => $option) {

							$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' (' . $currency . ' ' . price_format($option['value'], 2) . ')</option>';
						}

						$priceType .= '</select>';
					}
				}



				if ($item['serviceAmount'] != 0 && $item['serviceAmount'] != '') {



					if ($quantityContainer_display == 'none') {

						$amountSection = '<span style="font-size:20px!important;font-weight:bold;margin-right: 25px;margin-top: 5px;" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  number_format($item['serviceAmount'], 2)) . '</span>';
					} else {
						$amountSection = '<span style="font-size:20px!important;font-weight:bold;margin-top: 5px;" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   number_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  number_format($item['serviceAmount'], 2)) . '</span>';
					}
				} else {

					$item['serviceAmount'] = 1;
					if ($quantityContainer_display == 'none') {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 22px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
					<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
					</div>


					<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important;margin-right: 25px;">
					' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>';
					} else {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 22px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
						<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
						</div>
	
	
						<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important">
						' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
						</div>';
					}
				}


				$html .= '<script> console.log('  . json_encode($item) . ') </script>';
				$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme)!important;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
				</div>
				<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
				<div class="col-md-12 col-xl-12 px-0">
				<div class="card shadow-0 border rounded-3 px-0" style="margin-bottom:5px!important;border-radius: unset !important;">
				<div class="card-body p-0 m-0">
				<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme)!important;color:white">
				<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0 service-col-img">
				<div class="bg-image hover-zoom ripple rounded ripple-surface">
				<div class="crop-center img-responsive bg-light services-thumb" style="background-image: url(' . $src . ');box-shadow: 2px 2px 10px #00000030; height: 100px!important;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>
				<a href="#!">
				<div class="hover-overlay">
				<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
				</div>
				</a>
				</div>
				</div>
				<div class="col-md-6 col-lg-6 col-xl-8 service-col-scontent" style="background-color:white!important; display: flex; flex-direction: column; align-items: flex-start;">
				<div style="width: 100%;">
					<label class="pt-2" style="font-size:20px!important; margin-bottom:0;color:var(--main-color-new-theme);display:inline-flex;width: -webkit-fill-available;">
													' . replaceSingleQuotesWithBackticks($item['refDataName'])  . $descriptionEyeIcon . '
												</label>
												' . $descriptionWithEyeIcon . '
				' . $dateTimeCode . '
				' . $priceType . '
				</div>
				</div>';
				if ($quantityContainer_display == 'none') {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">
				<div class="res-amount" style="display: flex!important; flex-direction: row;justify-content: end !important; align-items: stretch;padding: 0px;"> ';
				} else {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 10px 0px 25px">
			<div class="res-amount" style=""> ';
				}
				$html .= '

				<div class="quantity-container" style="display:' . $quantityContainer_display . '">

				<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

				<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" data-max="' . $item['BookingLimitPerDay'] . '" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly>

				<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

				</div>




				' . $amountSection . '
				' . $checkbox . '
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				<input type="hidden" value="' . $pageLength . '" id="pageLength">';
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}

	return $html;
}


function getRecurringSponsorTypesServicesByServiceType($serviceTypes, $session_data)
{

	$CI = &get_instance();
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$productID = ApiBaseUrl()['productID'];
	$clientID = ApiBaseUrl()['clientID'];

	$data = [
		"componentConfig" => [
			"query" => [
				"aspectType" => "ServiceSetup",
				"serviceCategoryTypes" => "DONATIONS",
				"serviceTypes" => $serviceTypes,
				"sourceTypes" => "WEBSITE",
				"status" => "ACTIVE"
			],
			"moduleName" => "Temple Services",
			"aspectType" => "ServiceSetup",
			"collectionType" => "Business",
			"productID" => $productID,
			"clientID" => $clientID,
			"skip" => 0,
			"next" => 1024
		]
	];

	$postData = json_encode($data);

	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);





	$html = '';


	if ($services != array()) {

		foreach ($services as $key => $item) {


			$pageLength = $key + 1;
			// echo $item['qtyCounter'];

			if ($item['qtyCounter'] == 'YES') {
				$quantityContainer_display = 'inline-flex';
			} else {
				$quantityContainer_display = 'none';
			}



			if (isset($item['Image']) && !empty($item['Image'])) {
				$src = ApiBaseUrl()['url'] . $item['Image'];
			} else {
				$src = base_url('assets/img/') . "logo.png";
			}

			$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

			$available_count_design = '';
			$filter_color = '';
			$available_count = '';
			$disable_input_field = '';
			$disable_input_field = '';

			if ($item['serviceAmount'] == 0) {



				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$disable_input_field = 'disabled readonly';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
				} else {

					if ($is_availibility_check == 3) {
						$disable_input_field = '';
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}
						$checkbox = '<div class="form-check" style="width:50%">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						$checkbox = '<div class="form-check" style="width:50%">
						<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
						</div>';
						$disable_input_field = '';
					}
				}

				$item['serviceAmount'] = 1;
				$amountSection = '<div class="input-group">
				<span class="input-group-text">$</span>
				<input id="anyAmtDonation' . $item['_id'] . '" service-id="' . $item['_id'] . '" placeholder="0.00" type="text" class="form-control amount-input-donations"   minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 19px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  '') . '" ' . $disable_input_field . '>
				
				</div>


				<div class="d-none col-md-12" style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';
			} else {
				$amountSection = '<div style="padding: 0px 30px;font-size:20px!important">
				' . @getCurrencySymbol() . '&nbsp;<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * $item['serviceAmount']), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
				</div>';


				$checkbox = '<div class="form-check" style="width:50%">
				<input type="checkbox" id="checkbox_' . $item['_id'] . '" class="form-check-input"  value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="DONATIONS" data-service-type="' . $item['serviceTypes'] . '"  data-service-name="' . replaceSingleQuotesWithBackticks($item['refDataName']) . '" data-price="' . (in_array($item['_id'], $session_data['ids']) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  : ($item['serviceAmount'] ? $item['serviceAmount'] : price_format($item['serviceAmount'], 2))) . '" data-description="' . replaceSingleQuotesWithBackticks(trim($item['description'])) . '" data-image="' . $item['Image'] . '" onchange="addTocart()" name="services_id[]" style="margin-left: 12px;padding:14px!important" >
				</div>';
			}



			$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme);color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @getCurrencySymbol() . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
			</div><div class="row serviceSearch justify-content-center mb-3" style="' . $filter_color . '"> <div class="col-md-12 col-xl-12 px-0"> <div class="card shadow-0 border rounded-3 px-0"> <div class="card-body p-0 m-0"> <div class="row" id="searchHere" style="background-color:var(--main-color-new-theme);color:white"> 

			<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0"> <div class="bg-image hover-zoom ripple rounded ripple-surface"> 
			<a href="' . $src . '" data-lightbox="set">
			<div class="crop-center img-responsive bg-light" id="img-responsive1" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div></a>

			<a href="#!"> <div class="hover-overlay"> <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div> </div> </a> </div> </div> <div class="col-md-6 col-lg-7 col-xl-7" style="background-color:var(--main-color-new-theme)!important;display: flex; flex-direction: row; align-items: center;"> <div> <label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> <p class="text-white mb-0 pb-2" style="padding-left: 12px;line-height:20px;font-size:13px!important"> ' . @replaceSingleQuotesWithBackticks($item['description']) . ' </p> </div> </div> <div class="col-md-6 col-lg-4 col-xl-4" style=" display: flex; flex-direction: column; justify-content: center; ">

			<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-evenly; align-items: stretch;"> 

			


			' . $amountSection . '

			


			' . $checkbox . '


			</div> </div> </div> </div> </div> </div> </div><input type="hidden" value="' . $pageLength . '" id="pageLength">';
		}
		// $html .= '</tbody></table></table><input type="hidden" value="'.$pageLength.'" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

function getDailySchedulesServices()
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {
		\"query\": {
			\"aspectType\": \"ServiceSetup\", 
			\"sourceTypes\" : \"WEBSITE\", 
			\"servicesDispayGroup\" : \"Regular Services\", 
			\"status\" : \"ACTIVE\"
			} , 
			\"aspectType\": \"ServiceSetup\",
			\"moduleName\" : \"Temple Services\", 
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",
			\"collectionType\": \"Business\" , 
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\", 
			\"skip\": 0, 
			\"next\": 1024
		}}");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	$headers[] = 'Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJkYXRhIjoiaGFyc2huYS5iYWpwYWk3OEBnbWFpbC5jb20iLCJleHAiOjE2NjgxMTE1NTUsImlhdCI6MTY2ODEwNzk1NX0.ZYRe7ROH6PNGWowcMmFJ1iKSwYgn461KZ8P-2edqBdo';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result, true);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return $response;
}


function ArrReverse($array)
{
	$originalArray = $array;
	// Step 1: Get the keys of the original array
	$keys = array_keys($originalArray);
	// Step 2: Reverse the order of the keys
	$reversedKeys = array_reverse($keys);
	// Step 3: Create a new associative array using the reversed keys
	$reversedArray = array();
	foreach ($reversedKeys as $key) {
		$reversedArray[$key] = $originalArray[$key];
	}
	return $reversedArray;
}


function getNakshtra()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"nakshatraTypes\",     
			\"query\": {        
				\"aspectType\": \"nakshatraTypes\"     
				},      
				\"skip\": 0,    
				\"next\": 1024    
			} }");


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return 	$response;
}


function getGotra()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"gotraTypes\",     
			\"query\": {        
				\"aspectType\": \"gotraTypes\"     
				},      
				\"skip\": 0,    
				\"next\": 1024    
			} }");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return 	$response;
}

function getRashi()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\": {   
			\"moduleName\": \"Master Data Management\",  
			\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
			\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
			\"aspectType\": \"rashiTypes\",     
			\"query\": {        
				\"aspectType\": \"rashiTypes\"     
				},      
				\"skip\": 0,    
				\"next\": 1024    
			} }");

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	$result = curl_exec($ch);
	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	return 	$response;
}



function sortByTimestampDesc($a, $b)
{

	if (isset($a->recCreTime)) {
		$timestampA = strtotime(@$a->recCreDate) + (@$a->recCreTime / 1000);
		$timestampB = strtotime(@$b->recCreDate) + (@$b->recCreTime / 1000);
	} else {
		$timestampA = strtotime(@$a->recCreDate) + (@$a->createdAt / 1000);
		$timestampB = strtotime(@$b->recCreDate) + (@$b->createdAt / 1000);
	}

	if ($timestampA == $timestampB) {
		return 0;
	}
	return ($timestampA > $timestampB) ? -1 : 1;
}
function checkForYesValue($array)
{
	foreach ($array as $value) {
		if ($value === "YES") {
			return 'YES';
		}
	}
	return 'NO';
}


function replaceSingleQuotesWithBackticks($inputString)
{
	// Use str_replace to replace single quotes with backticks
	$outputString = str_replace("'", "`", $inputString);
	return $outputString;
}


function RegardingTypes()
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\":    {      \"moduleName\": \"Master Data Management\",      \"productID\":\"" . ApiBaseUrl()['productID'] . "\",      \"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",      \"aspectType\":\"Regardingtypes\",      \"query\": {        \"aspectType\": \"Regardingtypes\"      },  \"skip\": 0,      \"next\": 700    }    }");

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response->data;
}

function getGeneralCouncilMembers()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	$componentConfig = array(
		"moduleName" => "General Council Members",
		"productID" => ApiBaseUrl()['productID'],
		"clientID" => ApiBaseUrl()['clientID'],
		"aspectType" => "generalCouncilMembers",
		"query" => array(
			"aspectType" => "generalCouncilMembers"
		),
		"skip" => 0,
		"next" => 1024
	);

	$requestData = array(
		"componentConfig" => $componentConfig
	);

	$jsonData = json_encode($requestData);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response;
}



function getMasterData($aspectType)
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	// Define the data as an associative array
	$data = [
		'componentConfig' => [
			'moduleName' => 'Master Data Management',
			'productID' => ApiBaseUrl()['productID'],
			'clientID' => ApiBaseUrl()['clientID'],
			'aspectType' => $aspectType,
			'query' => [
				'aspectType' => $aspectType
			],
			'skip' => 0,
			'next' => 700
		]
	];

	// Convert the array to a JSON string
	$jsonData = json_encode($data);

	// Set the CURLOPT_POSTFIELDS using the variable
	curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);


	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return $response['data'];
}


function getWebSyncsData($moduleName, $aspectType, $status = '')
{

	if ($status != '') {
		$query = [
			'aspectType' => $aspectType,
			'status' => $status,
		];
	} else {
		$query =  ['aspectType' => $aspectType];
	}

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$productID = ApiBaseUrl()['productID'];
	$clientID = ApiBaseUrl()['clientID'];
	$post_data = [
		'componentConfig' => [
			'moduleName' => $moduleName,
			'aspectType' => $aspectType,
			'query' => $query,
			'productID' => $productID,
			'clientID' => $clientID,
			'skip' => 0,
			'next' => 1220,
		],
	];
	$dataJson = json_encode($post_data);

	// var_dump($dataJson);
	// die();
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return isset($response['data']) ?  $response['data'] : array();
}


function getServiceRequestData($filter)
{
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	// Constructing the data array
	$postData = array(
		"componentConfig" => array(
			"query" => $filter['query'], // Using the provided query parameter
			"moduleName" => "Temple Services",
			"aspectType" => "ServiceSetup",
			"collectionType" => "Business",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		)
	);

	// Encode the data array into JSON
	$postDataJson = json_encode($postData);
	// var_dump($postDataJson);
	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	// var_dump( $response['data']);die();
	return isset($response['data']) ?  $response['data'] : array();
}


function myServiceRequest()
{
	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');



	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Service Inquiry\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"Request Form\",     
		\"query\": {   \"aspectType\": \"Request Form\", \"serviceStatus\":\"NEW\",\"memberId\": \"" . $CI->session->userdata('id') . "\"     },   
		\"userName\": \"" . $userName . "\",     
		\"skip\": 0,    
		\"next\": 1020} 
	}");

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);


	// print_r($response);


	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	if ($response->statusCode == 1) {


		usort($response->data, 'sortByTimestampDesc');

		$data['myServiceRequests_data'] = $response->data;


		return $data;
	} else {
		$data['myServiceRequests_data'] = [];
	}
}

function MyPayments()
{
	$CI = &get_instance();
	$email = $CI->session->userdata('email');
	$userName = $CI->session->userdata('refDataName');

	$data = [];
	$data['payments_data'] = [];
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Payments\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"Payments\",     
		\"query\": {   \"aspectType\": \"Payments\", \"memberId\":\"" . $CI->session->userdata('id') . "\" ,\"paymentStatus\":\"COMPLETED\"   },   
		\"userName\": \"" . $userName . "\",     
		\"skip\": 0,    
		\"next\": 1020} 
	}");

	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);




	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	// echo '<pre>';	
	// print_r($response->data);
	// die;

	if ($response->statusCode == 1) {


		usort($response->data, 'sortByTimestampDesc');
		$data['payments_data'] = $response->data;
	}
	return $data;
}

function MyDonations()
{
	$CI = &get_instance();
	$data['page'] = 'MY-DONATIONS';
	$data['title'] = 'MY DONATIONS';
	$data['header'] = 'MY DONATIONS';

	$userName = $CI->session->userdata('refDataName');
	$email = $CI->session->userdata('email');


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	// Create an associative array to represent the data structure
	$postdata = array(
		"componentConfig" => array(
			"moduleName" => "Calendar",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"aspectType" => "Service Schedules",
			"query" => array(
				"aspectType" => "serviceBooking",
				"paymentStatus" => "COMPLETED",
				"memberId" => $CI->session->userdata('id'),
				"serviceCategoryTypes" => "DONATIONS"
			),
			"userName" => $userName,
			"skip" => 0,
			"next" => 1020
		)
	);

	$jsonData = json_encode($postdata);

	curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	usort($response->data, 'sortByTimestampDesc');

	$data['donations_data']  = !empty($response->data) ? json_decode(json_encode($response->data), true) : [];
	return $data;
}

function FilterBookingData($serviceCategoryTypes = '')
{
	$CI = &get_instance();
	$serviceCategoryTypes = !empty($serviceCategoryTypes) ? $serviceCategoryTypes : 'IN-TEMPLE';
	$data['page'] =  'MY-BOOKINGS';
	$data['header'] =  'MY BOOKINGS';
	$data['booking_data'] =  [];

	$userName = $CI->session->userdata('refDataName');
	$email = $CI->session->userdata('email');


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\": {   
		\"moduleName\": \"Calendar\",  
		\"productID\": \"" . ApiBaseUrl()['productID'] . "\",   
		\"clientID\": \"" . ApiBaseUrl()['clientID'] . "\",       
		\"aspectType\": \"Service Schedules\",     
		\"query\": {        \"aspectType\": \"serviceBooking\", \"paymentStatus\": \"COMPLETED\", \"memberId\":\"" . $CI->session->userdata('id') . "\" ,\"serviceCategoryTypes\":\"" . $serviceCategoryTypes . "\"      },   
		\"userName\": \"" . $userName . "\",     
		\"skip\": 0,    \"next\": 1020    } }");
	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);


	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$html = '';
	if ($response != '') {

		usort($response->data, 'sortByTimestampDesc');
		$data['booking_data']  = !empty($response->data) ? json_decode(json_encode($response->data), true) : [];
	}
	return $data;
}

function getYear()
{
	$currentYear = date('Y');
	$years = range($currentYear, 2023);

	return $years;
}

function getCouponSettingsUrl()
{
	$data = array(
		'url' => "api/bookingService/getCouponSettings"
	);
	return $data;
}

function getCouponSettings($service_name, $start_date, $discountApplyTo = '')
{



	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt_array($curl, array(
		CURLOPT_URL => ApiBaseUrl()['url'] . getCouponSettingsUrl()['url'],
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS => "{
   \"clientId\":\"" . ApiBaseUrl()['clientID'] . "\",
    \"startDate\":\"" . $start_date . "\",
    \"ServiceName\":\"" . $service_name . "\",
    \"discountApplyTo\":\"" . $discountApplyTo . "\"
}"
	));
	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($curl);
	if (curl_errno($curl)) {
		echo 'Error:' . curl_error($curl);
	}
	curl_close($curl);


	return @json_decode($result, true)['data'][0];
}


// Function to convert Y-m format to m/d/Y
function MYtoDMY($dateString)
{
	$date = DateTime::createFromFormat('Y-m', $dateString);
	if (!$date) {
		return "Invalid date format"; // Handle error or return a default value
	}
	return $date->format('m/d/Y');
}

// Function to convert Y format to m/d/Y
function YtoDMY($dateString)
{
	$date = DateTime::createFromFormat('Y', $dateString);
	if (!$date) {
		return "Invalid date format"; // Handle error or return a default value
	}
	return $date->format('m/d/Y');
}

// Get the first day of a given month/year in m/d/Y format
function monthFirstDate($dateString)
{
	$date = DateTime::createFromFormat('Y-m', $dateString);
	if (!$date) {
		return "Invalid date format"; // Handle error or return a default value
	}
	$firstDate = $date->modify('first day of this month');
	return $firstDate->format('m/d/Y');
}

// Get the last day of a given month/year in m/d/Y format
function monthLastDate($dateString)
{
	$date = DateTime::createFromFormat('Y-m', $dateString);
	if (!$date) {
		return "Invalid date format"; // Handle error or return a default value
	}
	$lastDate = $date->modify('last day of this month');
	return $lastDate->format('m/d/Y');
}

function updateMobileNumber()
{
	$data = array(
		'url' => "api/auth/changeMobileNumber"
	);
	return $data;
}

function maskEmail($email)
{
	$atPos = strpos($email, '@');

	if ($atPos === false) {
		return $email;
	}

	$namePart = substr($email, 0, $atPos);
	$domainPart = substr($email, $atPos + 1);

	$firstThreeChars = substr($namePart, 0, 3);
	$lastTwoChars = substr($namePart, -2);
	$maskedNamePart = $firstThreeChars . str_repeat('*', max(strlen($namePart) - 5, 0)) . $lastTwoChars;

	$firstDomainChar = substr($domainPart, 0, 1);
	$domainExtension = strrchr($domainPart, '.');
	$maskedDomainPart = $firstDomainChar . str_repeat('*', strlen($domainPart) - strlen($domainExtension) - 1) . $domainExtension;

	return $maskedNamePart . '@' . $domainPart;
}

function getFacilityRequestByTokenNoURL()
{
	$data = array(
		'url' => "api/bookingService/getFacilityRequestByTokenNo"
	);
	return $data;
}

function getFacilityRequestByTokenNo($tokenNo)
{
	$CI = &get_instance();

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt_array($curl, array(
		CURLOPT_URL => ApiBaseUrl()['url'] . getFacilityRequestByTokenNoURL()['url'],
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS => "{
    \"productId\":\"" . ApiBaseUrl()["productID"] . "\",
    \"clientId\":\"" . ApiBaseUrl()["clientID"] . "\",
    \"tokenNo\":  $tokenNo 
	}"
	));



	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($curl);
	$response = json_decode($result);


	// print_r($response);


	if (curl_errno($curl)) {
		echo 'Error:' . curl_error($curl);
	}
	curl_close($curl);
	return $response;
}


function updateFacilityTransactionStatus()
{

	$data = array(
		'url' => "api/bookingService/updateFacilityTransactionStatus"
	);
	return $data;
}

function Religious()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/home/getCalendar');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	$currentYear = date('Y');
	$endYear = $currentYear + 1;
	// $postfield = array(

	// 	'clientId' => ApiBaseUrl()['clientID'],
	// 	'year' => date('Y')

	// );
	$postfield = array(
		'clientId' => ApiBaseUrl()['clientID'],
		'year' => array(
			'$gte' => $currentYear,
			'$lte' => (string)$endYear
		)
	);

	$postfield = json_encode($postfield);
	// var_dump($postfield);die();
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postfield);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	// var_dump($response);die();
	return $response;
}

function getCalenderServices()
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);



	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
		"componentConfig" => [
			"query" => [
				"aspectType" => "ServiceSetup",
				"serviceCategoryTypes" => [
					'$in' => ["IN-TEMPLE", "EVENTS", "SPONSORSHIP"]
				],
				"sourceTypes" => "WEBSITE",
				"status" => "ACTIVE",
				"showInCalendar" => "YES"
			],
			"moduleName" => "Temple Services",
			"aspectType" => "ServiceSetup",
			"collectionType" => "Business",
			"productID" => ApiBaseUrl()['productID'],
			"clientID" => ApiBaseUrl()['clientID'],
			"skip" => 0,
			"next" => 1024
		]
	]));
	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	return $response;
}

function getWeekdayOccurrence($date)
{
	// Convert the date to timestamp
	$timestamp = strtotime($date);

	// Find the weekday (0 = Sunday, 1 = Monday, ..., 6 = Saturday)
	$weekday = date('w', $timestamp);

	// Get the day of the month
	$dayOfMonth = date('j', $timestamp);

	// Calculate the occurrence of the weekday in the month
	$occurrence = ceil($dayOfMonth / 7);

	$weekdayNames = ['SUNDAY', 'MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY', 'SATURDAY'];
	$occurrences = ['', 'FIRST', 'SECOND', 'THIRD', 'FOURTH', 'FIFTH', 'SIXTH'];


	return $occurrences[$occurrence] . " " . $weekdayNames[$weekday];
}


function getWeekday($date)
{
	// Convert the date to timestamp
	$timestamp = strtotime($date);

	// Find the weekday (0 = Sunday, 1 = Monday, ..., 6 = Saturday)
	$weekday = date('w', $timestamp);

	// Get the day of the month
	$dayOfMonth = date('j', $timestamp);

	// Calculate the occurrence of the weekday in the month
	$occurrence = ceil($dayOfMonth / 7);

	$weekdayNames = ['SUNDAY', 'MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY', 'SATURDAY'];


	return $weekdayNames[$weekday];
}

function getThithis($dayTypes)
{
	$datesArray = getThithiNext90Days($dayTypes);
	// $datesArray = [];


	if (!empty($datesArray['data'])) {
		$dates = array();
		foreach ($datesArray['data'] as $key => $value) {

			$newDate = str_replace("T00:00:00.000Z", "", $value['startDate']);

			array_push($dates, $newDate);
			// $dates =  $newDate;
		}
		return $dates;
	} else {
		return [];
		// return ["2024-12-17","2024-12-03","2025-01-02","2025-01-16","2025-01-31","2025-02-15","2025-03-02","2025-03-17","2025-04-29","2025-03-31","2025-05-29","2025-04-15","2025-07-13","2025-05-15","2025-08-25","2025-09-09","2025-06-14","2025-09-24","2025-10-09","2025-10-24","2025-06-27","2025-07-27","2025-08-11","2025-11-07"];

	}
}

function postUpdateProfileAPI()
{
	$data = array(
		'url' => "api/appgen/postUpdateProfileAPI"
	);
	return $data;
}



function addServiceRequestWithPayment()
{
	$data = array(
		'url' => "api/bookingService/addServiceRequestWithPayment"
	);
	return $data;
}

function getfacilityAvailbility($serviceDate, $targetTime, $facilityId = '', $session_data = [], $participant = '')
{
	$CI = &get_instance();


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/facility/getfacilityAvailbility');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$data = [

		"clientId" => ApiBaseUrl()['clientID'],
		"serviceDate" => $serviceDate,
		"targetTime" => $targetTime,
		"facilityId" => $facilityId,
		"participant" => $participant
	];

	$postData = json_encode($data);
	// var_dump($postData);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$response = json_decode($result, true);

	// var_dump($response);
	$rentals = $response['data'];
	$rentals = sortBySequenceId($rentals);

	$currency = getCurrencySymbol();
	$html = '';
	// echo '<pre>';
	// print_r($rentals); die();

	if ($rentals != array()) {
		if (empty($session_data)) {
			$session_data['ids'] = [];
		}

		foreach ($rentals as $key => $item) {




			$isValid = filterValidData($item);
			// if ($isValid == 1) {
			$availability = 1;
			if (isset($item['availability']) && $item['availability'] == 'Not Available') {
				$bgColor = '#7b7b7b';
				$color = '#fff';
				$availability = 0;
			} else {
				$bgColor = 'var(--main-color-new-theme)';
				$color = '#fff';
			}

			$priceType = '';

			if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


				$priceTypeString = $item['priceType'];


				$priceTypeArray = json_decode($priceTypeString, true);

				if ($priceTypeArray != array()) {

					$priceType .= '<select id="booking_type' . $item['_id'] . '" class="price_types p-2 mt-2 ' . (!$availability || $availability == 0 ? 'd-none' : '') . '" style="padding: 4px; border-radius: 5px; margin-bottom: 10px;"  onchange="showSection(this, `' . $item['_id'] . '`)">';

					$priceType .=  '<option value=" " selected disabled>Select Type</option>';

					foreach ($priceTypeArray as $index => $option) {

						$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['initial_amt_hourly'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . '</option>';
					}

					$priceType .= '</select>';
				}
			}


			if (@$item['qtyCounter'] == 'YES') {
				$quantityContainer_display = 'inline-flex';
			} else {
				$quantityContainer_display = 'none';
			}



			if (isset($item['image']) && !empty($item['image'])) {
				$src = ApiBaseUrl()['url'] . $item['image'];
			} else {
				$src = base_url('assets/img/') . "logo.png";
			}



			if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

				if ($item['bookingType'] == 'PAY NOW'  &&  @$item['costPerUnit'] > 0) {

					$bookingType = 'PAY NOW';
				} else if ($item['bookingType'] == 'PAY LATER'  &&  @$item['costPerUnit'] > 0) {
					$bookingType = 'PAY LATER';
				} else if ($item['bookingType'] == 'OPTIONAL'  &&  @$item['costPerUnit'] > 0) {
					$bookingType = 'OPTIONAL';
				} else {
					$bookingType = 'PAY NOW';
				}
			} else {
				$bookingType = 'PAY NOW';
			}


			$pageLength = $key + 1;

			if (isset($item['costPerUnit']) && @$item['costPerUnit'] != 0) {



				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						}
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  @$item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  @$item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					}
				}

				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  disabled' . $disable_input_field . '>';
				} else {
					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
				}

				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
					$timeDisplay = 'd-none';
					if ((in_array($item['_id'], @$session_data['ids'])) && (isset(($session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])) || isset(($session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])))) {
						$timeDisplay = 'd-block';
					}
					$dateTimeCode = '';
					$dateTimeCode .= '<div class="row m-0 pt-1">
										<div class="col-md-4 m-0 p-0">
											<div class="input-group">
												' . @$priceType . '

						
											</div>
										</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: white!important;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . $timeDisplay . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" type="text" class="time_picker_start hasTimepicker start" readonly onchange="getfacilityAvailbilityEndStatus(this.value,\'' . $item['_id'] . '\');CheckAValibilityTime(\'' . $item['_id'] . '\')" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" onchange="CheckAValibilityTime(\'' . $item['_id'] . '\')" readonly type="text" class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>
						
						</div>';
				} else {
					$dateTimeCode = '';
				}

				if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
					$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
				} else {
					$descriptionWithEyeIcon = '';
				}




				if (!$availability || $availability == 0) {
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				}



				$html .= '<div class="text-end d-none align-middle" style="background-color:' . $bgColor . ';color:' . $color . '!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format(@$item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:' . $bgColor . ';color:' . $color . '">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:' . $bgColor . '!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
				
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
						<p class="p-0 m-0 d-none text-danger" id="avlDiv' . $item['_id'] . '" style="font-size: 18px !important;"><b>&nbsp;&nbsp;Servce not available for selected date and time.</b></p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format(@$item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
			} else {


				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$availability = 1;
				if (isset($item['availability']) && $item['availability'] == 'Not Available') {
					$bgColor = '#7b7b7b';
					$color = '#fff';
					$availability = 0;
				} else {
					$bgColor = 'var(--main-color-new-theme)';
					$color = '#fff';
				}
				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						}
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  @$item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  @$item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					}
				}

				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
				} else {
					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
				}
				$dateTimeCode = '';
				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {

					$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">

						

						' . @$priceType . '

						
						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: #eec932!important;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "HOURLY" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "MORNING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "EVENING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "AFTERNOON" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "FULL DAY" ? '' : 'd-none')  : 'd-none') . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" readonly type="text" class="time_picker_start hasTimepicker start" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" type="text" readonly class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>

						</div>';
				} else {
					$dateTimeCode = '';
				}

				if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
					$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
				} else {
					$descriptionWithEyeIcon = '';
				}









				$html .= '<div class="text-end d-none align-middle" style="background-color:' . $bgColor . ';color:' . $color . '!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format(@$item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:' . $bgColor . ';color:' . $color . '">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:127%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:' . $bgColor . '!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
					<p class="p-0 m-0 d-none text-danger" id="avlDiv' . $item['_id'] . '" style="font-size: 18px !important;"><b>&nbsp;&nbsp;Servce not available for selected date and time.</b></p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format(@$item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					';
			}
			// }
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}

function getfacilityAvailbility2($serviceDate, $targetTime, $facilityId = '', $session_data = [], $participant = '')
{
	$CI = &get_instance();


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/facility/getfacilityAvailbility');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$data = [

		"clientId" => ApiBaseUrl()['clientID'],
		"serviceDate" => $serviceDate,
		"targetTime" => $targetTime,
		"facilityId" => $facilityId,
		"participant" => $participant
	];

	$postData = json_encode($data);
	// var_dump($postData);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$response = json_decode($result, true);

	// var_dump($response);
	$rentals = $response['data'];
	$rentals = sortBySequenceId($rentals);

	$currency = getCurrencySymbol();
	$html = '';
	// echo '<pre>';
	// print_r($rentals); die();

	if ($rentals != array()) {
		if (empty($session_data)) {
			$session_data['ids'] = [];
		}

		foreach ($rentals as $key => $item) {




			$isValid = filterValidData($item);
			// if ($isValid == 1) {
			$availability = 1;
			if (isset($item['availability']) && $item['availability'] == 'Not Available') {
				$bgColor = '#7b7b7b';
				$color = '#fff';
				$availability = 0;
				$avlDivMsg = isset($item['availabilityMessage']) && !empty($item['availabilityMessage']) ? $item['availabilityMessage'] : "Servce not available for selected date and time.";
				$avlDivDisplay = "d-block";
			} else {
				$bgColor = 'var(--main-color-new-theme)';
				$color = '#fff';
				$avlDivMsg = "Servce not available for selected date and time.";
				$avlDivDisplay = "d-none";
			}

			$priceType = '';

			if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


				$priceTypeString = $item['priceType'];


				$priceTypeArray = json_decode($priceTypeString, true);

				if ($priceTypeArray != array()) {

					$priceType = '<select id="booking_type' . $item['_id'] . '" class="price_types p-2 mt-2 ' . (!$availability || $availability == 0 ? 'd-none' : '') . '" style="padding: 4px; border-radius: 5px; margin-bottom: 10px;"  onchange="showSection(this, `' . $item['_id'] . '`)">';

					$priceType .=  '<option value=" " selected disabled>Select Type</option>';

					foreach ($priceTypeArray as $index => $option) {

						$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['initial_amt_hourly'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . '</option>';
					}

					$priceType .= '</select>';
				}
			}


			if (@$item['qtyCounter'] == 'YES') {
				$quantityContainer_display = 'inline-flex';
			} else {
				$quantityContainer_display = 'none';
			}



			if (isset($item['image']) && !empty($item['image'])) {
				$src = ApiBaseUrl()['url'] . $item['image'];
			} else {
				$src = base_url('assets/img/') . "logo.png";
			}



			if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

				if ($item['bookingType'] == 'PAY NOW'  &&  $item['costPerUnit'] > 0) {

					$bookingType = 'PAY NOW';
				} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['costPerUnit'] > 0) {
					$bookingType = 'PAY LATER';
				} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['costPerUnit'] > 0) {
					$bookingType = 'OPTIONAL';
				} else {
					$bookingType = 'PAY NOW';
				}
			} else {
				$bookingType = 'PAY NOW';
			}


			$pageLength = $key + 1;

			if (isset($item['costPerUnit']) && $item['costPerUnit'] != 0) {



				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						}
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  $item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  $item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					}
				}

				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  disabled' . $disable_input_field . '>';
				} else {
					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff!important;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly disabled dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
				}

				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
					$timeDisplay = 'd-none';
					if ((in_array($item['_id'], @$session_data['ids'])) && (isset(($session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])) || isset(($session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])))) {
						$timeDisplay = 'd-block';
					}
					$dateTimeCode = '';
					$dateTimeCode .= '<div class="row m-0 pt-1">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">

						

						' . @$priceType . '

						
						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: #eaaf25!important;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . $timeDisplay . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" type="text" class="time_picker_start hasTimepicker start" readonly onchange="getfacilityAvailbilityEndStatus(this.value,\'' . $item['_id'] . '\');CheckAValibilityTime(\'' . $item['_id'] . '\')" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" onchange="CheckAValibilityTime(\'' . $item['_id'] . '\')" readonly type="text" class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>
						
						</div>';
				} else {
					$dateTimeCode = '';
				}

				if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
					$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
				} else {
					$descriptionWithEyeIcon = '';
				}




				if (!$availability || $availability == 0) {
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				}



				$html .= '<div class="text-end d-none align-middle" style="background-color:' . $bgColor . ';color:' . $color . '!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:' . $bgColor . ';color:' . $color . '">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:' . $bgColor . '!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
				
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
						<p class="p-0 m-0 ' . $avlDivDisplay . ' text-danger" id="avlDiv' . $item['_id'] . '" style="font-size: 18px !important;"><b>&nbsp;&nbsp;' . $avlDivMsg . '</b></p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format($item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					<input type="hidden" value="' . $pageLength . '" id="pageLength">';
			} else {


				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$availability = 1;
				if (isset($item['availability']) && $item['availability'] == 'Not Available') {
					$bgColor = '#7b7b7b';
					$color = '#fff';
					$availability = 0;
				} else {
					$bgColor = 'var(--main-color-new-theme)';
					$color = '#fff';
				}
				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						} else {
							$available_count_design = ' <a href="javaScript:void(0)">
								<div class="mask">
								<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
								<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
								</div>
								</div>
								<div class="hover-overlay">
								<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
								</div>
								</a>';
						}
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input"  id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  $item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {
						if (!$availability || $availability == 0) {
							$filter_color = 'filter: grayscale(1);';
							$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
							$disable_input_field = 'disabled readonly';
						} else {
							$checkbox = '<div class="form-check"  style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['rentalCategory'] . '" data-service-type="' . $item['refDataCode'] . '" data-start-time="' . @$item['startTime'] . '" data-start-date="' . @$item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])  :  $item['costPerUnit']) . '" data-end-date="' . @$item['endDate'] . '" data-end-time="' . @$item['endTime'] . '" data-description="' . replaceSingleQuotesWithBackticks($item['shortDescription']) . '" data-image="' . @$item['image'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart(this)" name="services_id[]" available_count="' . @$item['AvailableCount'] . '" style="padding:14px!important" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   @$session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '">
							</div>';
						}
					}
				}

				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . '>';
				} else {
					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : '') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . ' >';
				}

				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {
					$dateTimeCode = '';
					$dateTimeCode = '<div class="row m-0 pt-3">
						<div class="col-md-4 m-0 p-0">
						<div class="input-group">

						

						' . @$priceType . '

						
						</div>
						</div>


						<div class="col-md-4 m-0 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] != "" ? '' : 'd-none')  : 'd-none') . '" id="date_section_' . $item['_id'] . '">
						<div class="input-group">

						<span class="input-group-text" style="color: white!important;background-color: #e9ecef00;border: 1px solid #ced4da00;" id="basic-addon1"><i class="fa fa-calendar"></i></span>

						' . $limitPerdayFeature . '
						</div>
						</div>

						<div class="col-md-4 p-0 ' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "HOURLY" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "MORNING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "EVENING" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "AFTERNOON" || @$session_data['service_desc'][array_search($item['_id'], @$session_data['ids'])] == "FULL DAY" ? '' : 'd-none')  : 'd-none') . '" id="time_section_' . $item['_id'] . '">

						<div class="input-group">
						

						<table class="table-inputs mb-2"> 
						<tbody>
						<tr>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="start_time' . $item['_id'] . '" name="start_time' . $item['_id'] . '" readonly type="text" class="time_picker_start hasTimepicker start" placeholder="From Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['start_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						<td style="width:33.33%">
						<div class="input-group" style="padding: 5px;">
						<input  id="end_time' . $item['_id'] . '" name="end_time' . $item['_id'] . '" type="text" readonly class="time_picker_end hasTimepicker end" placeholder="To Time" autocomplete="off" value="' . ((in_array($item['_id'], @$session_data['ids'])) ?  (@$session_data['end_time'][array_search($item['_id'], @$session_data['ids'])])  : '') . '" data-id="' . @$item['_id'] . '" initial-hourly-amt="" data-hourFrom="" data-hourTo="">
						</div>
						</td>
						</tr>
						</tbody>
						</table>


						</div>

						</div>

						</div>';
				} else {
					$dateTimeCode = '';
				}

				if (isset($item['shortDescription']) && $item['shortDescription'] != '') {
					$descriptionWithEyeIcon = '<style>
						.collapse.in { display: inline !important; }
						</style>

						<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="padding-left: 13px;">
						' . $item['shortDescription'] . '
						</span> 
						<span>
						<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false" style="padding-left: 13px;"><i class="fa fa-eye" style="color:yellow"></i></a>
						</span>';
				} else {
					$descriptionWithEyeIcon = '';
				}









				$html .= '<div class="text-end d-none align-middle" style="background-color:' . $bgColor . ';color:' . $color . '!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . $currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['costPerUnit'], 2)) . '</span>
					</div>
					<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
					<div class="col-md-12 col-xl-12 px-0">
					<div class="card shadow-0 border rounded-3 px-0">
					<div class="card-body p-0 m-0">
					<div class="row" id="searchHere" style="background-color:' . $bgColor . ';color:' . $color . '">

					<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0">
					<div class="bg-image hover-zoom ripple rounded ripple-surface">

					<div class="crop-center img-responsive bg-light" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 120px;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>

					<a href="#!">
					<div class="hover-overlay">
					<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);">
					</div>
					</div>
					</a>
					</div>
					</div>



					<div class="col-md-6 col-lg-6 col-xl-6" style="background-color:' . $bgColor . '!important;display: flex; flex-direction: row; align-items: center;">
					<div class="row text-start">
					<label class="pt-2" style="padding-left: 12px;font-size:20px!important;text-shadow:1px 1px 0px black!important;">' . replaceSingleQuotesWithBackticks($item['refDataName']) . '</label> <br> 
					<p style="color: white!important; font-size: 13px!important;letter-spacing:0px;text-align: justify; padding: 0px 14px; line-height: inherit;">' . @$item['shortDescription'] . '</p>
					<p class="p-0 m-0 ' . $avlDivDisplay . ' text-danger" id="avlDiv' . $item['_id'] . '" style="font-size: 18px !important;"><b>&nbsp;&nbsp;' . $avlDivMsg . '</b></p>
					' . $dateTimeCode . '
					</div>
					</div>


					<div class="col-md-6 col-lg-2 col-xl-2" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: stretch;padding: 0px;"> 


					<div class="quantity-container" style="display:' . $quantityContainer_display . '">

					<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

					<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly ' . $disable_input_field . '>

					<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: ' . $bgColor . ';color:' . $color . '" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

					</div>
					</div>

					</div>

					<div class="col-md-6 col-lg-3 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">

					<div class="res-amount" style="display: flex!important; flex-direction: row; justify-content: space-around; align-items: center;padding: 0px;border-left:1px solid white;font-weight:bold"> 


					<span id="Totalprice_' . $item['_id'] . '" style="font-size:20px!important">' . $currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(((float)($session_data['qty'][array_search($item['_id'], $session_data['ids'])]) * (float)($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])])), 2)  :  price_format($item['costPerUnit'], 2)) . '</span>
					' . $checkbox . '
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					</div>
					';
			}
			// }
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}


	return $html;
}


function getfacilityAvailbilityStatus2($serviceDate, $targetTime, $facilityId, $targetEndTime)
{
	$CI = &get_instance();


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/facility/getfacilityAvailbility');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$data = [

		"clientId" => ApiBaseUrl()['clientID'],
		"serviceDate" => $serviceDate,
		"targetTime" => $targetTime,
		"targetEndTime" => $targetEndTime,
		"facilityId" => $facilityId
	];

	$postData = json_encode($data);
	// var_dump($postData);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$response = json_decode($result, true);

	// var_dump($response);
	$rentals = $response['data'];
	$rentals = sortBySequenceId($rentals);

	$currency = getCurrencySymbol();
	$status = json_encode(0);

	if ($rentals != array()) {
		$rentals = $rentals[0];
		if (isset($rentals['availability']) && $rentals['availability'] == 'Available') {
			$status = json_encode(1);
		}
	}


	return $status;
}

function getfacilityAvailbilityStatus($serviceDate, $targetTime, $facilityId, $targetEndTime, $participant = '')
{
	$CI = &get_instance();


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/facility/getfacilityAvailbility');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$data = [

		"clientId" => ApiBaseUrl()['clientID'],
		"serviceDate" => $serviceDate,
		"targetTime" => $targetTime,
		"targetEndTime" => $targetEndTime,
		"facilityId" => $facilityId,
		"participant" => $participant
	];

	$postData = json_encode($data);
	// var_dump($postData);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);


	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$response = json_decode($result, true);

	// var_dump($response);
	$rentals = $response['data'];
	$rentals = sortBySequenceId($rentals);

	$currency = getCurrencySymbol();
	$status = json_encode(0);

	if ($rentals != array()) {
		$rentals = $rentals[0];
		if (isset($rentals['availability']) && $rentals['availability'] == 'Available') {
			$status = json_encode(1);
		}
	}


	return $status;
}

function membershipStatusCheck()
{
	$CI = &get_instance();
	if ($CI->session->userdata('logged_in') == 1) {
		$userDetails =  getUserDetails()->data[0];
		// var_dump($userDetails);
		// $data["membershipStatus"] = "INACTIVE";
		$data["membershipStatus"] = @$userDetails->membershipStatus;
		$data["membershipName"] = @$userDetails->membershipName;
		$data["memberShipExpiryDate"] = @$userDetails->memberShipExpiryDate;
		$data["membershipType"] = @$userDetails->membershipType;
		$data["membershipStartDate"] = @$userDetails->membershipStartDate;
		$data["membershipPaymentStatus"] = @$userDetails->membershipPaymentStatus;
		$data["membershipId"] = @$userDetails->membershipId;
		$data["membershipId"] = @$userDetails->membershipId;
		$data['membershipDesc'] = @$userDetails->membershipDetail;
		$data['benefit'] = @$userDetails->benefit;

		if ((isset($userDetails->memberShipExpiryDate) && !empty($userDetails->memberShipExpiryDate))) {
			$today = date("m/d/Y");


			$targetDate = date("m/d/Y", strtotime($userDetails->memberShipExpiryDate));

			if ((strtotime($today) < strtotime($targetDate)) && $data["membershipPaymentStatus"] == "COMPLETED" && $data["membershipStatus"] == "ACTIVE") {
				$data["membershipStatus"] = "ACTIVE";
			} else if ((strtotime($today) > strtotime($targetDate)) && $data["membershipPaymentStatus"] == "COMPLETED" && $data["membershipStatus"] == "ACTIVE") {
				$data["membershipStatus"] = "EXPIRED";
			} else {
				$data["membershipStatus"] = "INACTIVE";
			}
		} else {
			if ($data["membershipPaymentStatus"] == "COMPLETED" && $data["membershipStatus"] == "ACTIVE") {
				$data["membershipStatus"] = "ACTIVE";
			} else {
				$data["membershipStatus"] = "INACTIVE";
			}
		}
	} else {
		$data["membershipStatus"] = "";
		$data["membershipName"] = "";
		$data["memberShipExpiryDate"] = "";
		$data["membershipType"] = "";
		$data["membershipStartDate"] = "";
		$data["membershipPaymentStatus"] = "";
		$data["membershipId"] = "";
		$data["membershipId"] = "";
		$data['membershipDesc'] = "";
	}
	return $data;
}

function CheckoutDonationSettings()
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . settings()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"action\": \"getClientSetting\",   
		\"productId\":\"" . ApiBaseUrl()['productID'] . "\",
		\"clientId\":\"" . ApiBaseUrl()['clientID'] . "\"
	}");

	// $token = $this->session->userdata('token');
	$headers = array();
	// $headers[] = 'Authorization: Bearer '.$token.'';
	$headers[] = 'Content-Type: application/json';



	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);


	$printerSettings = @$response['result']['data'][0]['checkoutpageKioskSettings']['printerUrl2'] ?? [];

	$websiteSetting = array_filter($printerSettings, function ($item) {
		return isset($item['register']) && $item['register'] === "WEBSITE";
	});

	$websiteSetting = reset($websiteSetting); // Pehla matching element
	if (!isset($websiteSetting['DonationDisplayTitle']) || empty($websiteSetting['DonationDisplayTitle'])) {
		$websiteSetting['DonationDisplayTitle'] = "General Donation Amount";
	}

	if (!isset($websiteSetting['AsDisplayTitle']) || empty($websiteSetting['AsDisplayTitle'])) {
		$websiteSetting['AsDisplayTitle'] = "Acharya Sanbhavana Amount";
	}
	return $websiteSetting;
}

function getCartSessiondata()
{
	$CI = &get_instance();


	$service_cart_items = @$CI->session->userdata('service_cart');
	$sponser_cart_items = @$CI->session->userdata('sponsorship_cart');
	$event_cart_items = @$CI->session->userdata('events_cart');
	$donation_cart_items = @$CI->session->userdata('donations_cart');




	$dataWithAmount = array();
	if (!empty($service_cart_items)) {
		for ($i = 0; $i < count($service_cart_items['ids']); $i++) {

			$payment_type_check = $service_cart_items['bookingtype'][$i];

			if (isset($service_cart_items['startDate'][$i]) && !empty($service_cart_items['startDate'][$i])) {
				$startDateArray = explode(", ", $service_cart_items['startDate'][$i]);

				foreach ($startDateArray as $startDate) {

					$dataWithAmount[] = array(
						"_id" => $service_cart_items['ids'][$i],
						"ServiceId" => $service_cart_items['ids'][$i],
						"serviceName" => $service_cart_items['serviceName'][$i],
						"serviceCategory" => $service_cart_items['ctg'][$i],
						"serviceType" => $service_cart_items['serviceTypes'][$i],
						"serviceAmount" => $service_cart_items['serviceAmount'][$i],
						"startDate" => $startDate,
						"qty" => $service_cart_items['qty'][$i],
						"time" => @$service_cart_items['startTime'][$i],
						"bookingType" => @$payment_type_check,
						"day" => "",
						"serviceAddress" => "",
						"cartCreDate" => date("m/d/Y"),
						"cartCreTime" => date("h:i A"),
						"isServicePaid" => @$service_cart_items['isServicePaid'][$i],
						"serviceDesc" => @$service_cart_items['service_desc'][$i],
						"serviceOccurrencesNo" => @$service_cart_items['serviceOccurrencesNo'][$i],
						"oldServiceAmount" => isset($service_cart_items['oldServiceAmount'][$i]) && $service_cart_items['oldServiceAmount'][$i] > 0 ? $service_cart_items['oldServiceAmount'][$i] : $service_cart_items['serviceAmount'][$i],
						"discountedAmount" => isset($service_cart_items['discountedAmount'][$i]) && $service_cart_items['discountedAmount'][$i] > 0 ? $service_cart_items['discountedAmount'][$i] : 0,
						"fullPackage" => @$service_cart_items['fullPackage'][$i]
					);
				}
			} else {

				$dataWithAmount[] = array(
					"_id" => $service_cart_items['ids'][$i],
					"ServiceId" => $service_cart_items['ids'][$i],
					"serviceName" => $service_cart_items['serviceName'][$i],
					"serviceCategory" => $service_cart_items['ctg'][$i],
					"serviceType" => $service_cart_items['serviceTypes'][$i],
					"serviceAmount" => $service_cart_items['serviceAmount'][$i],
					"startDate" => '',
					"qty" => $service_cart_items['qty'][$i],
					"time" => @$service_cart_items['startTime'][$i],
					"bookingType" => @$payment_type_check,
					"day" => "",
					"serviceAddress" => "",
					"cartCreDate" => date("m/d/Y"),
					"cartCreTime" => date("h:i A"),
					"isServicePaid" => @$service_cart_items['isServicePaid'][$i],
					"serviceDesc" => @$service_cart_items['service_desc'][$i],
					"serviceOccurrencesNo" => @$service_cart_items['serviceOccurrencesNo'][$i],
					"fullPackage" => @$service_cart_items['fullPackage'][$i],
					"oldServiceAmount" => isset($service_cart_items['oldServiceAmount'][$i]) && $service_cart_items['oldServiceAmount'][$i] > 0 ? $service_cart_items['oldServiceAmount'][$i] : $service_cart_items['serviceAmount'][$i],
					"discountedAmount" => isset($service_cart_items['discountedAmount'][$i]) && $service_cart_items['discountedAmount'][$i] > 0 ? $service_cart_items['discountedAmount'][$i] : 0,
				);
			}
		}
	}

	if (!empty($sponser_cart_items)) {
		for ($i = 0; $i < count($sponser_cart_items['ids']); $i++) {

			if (isset($sponser_cart_items['startDate'][$i]) && !empty($sponser_cart_items['startDate'][$i])) {
				$startDateArray = explode(", ", $sponser_cart_items['startDate'][$i]);
				foreach ($startDateArray as $startDate) {

					$dataWithAmount[] = array(
						"_id" => $sponser_cart_items['ids'][$i],
						"ServiceId" => $sponser_cart_items['ids'][$i],
						"serviceName" => $sponser_cart_items['serviceName'][$i],
						"serviceCategory" => $sponser_cart_items['ctg'][$i],
						"serviceType" => $sponser_cart_items['serviceTypes'][$i],
						"serviceAmount" => $sponser_cart_items['serviceAmount'][$i],
						"startDate" => $startDate,
						"qty" => $sponser_cart_items['qty'][$i],
						"time" => @$sponser_cart_items['startTime'][$i],
						"day" => "",
						"serviceAddress" => "",
						"serviceDesc" => @$sponser_cart_items['service_desc'][$i],
						"serviceOccurrencesNo" => @$sponser_cart_items['serviceOccurrencesNo'][$i],
						"fullPackage" => @$sponser_cart_items['fullPackage'][$i],
						"oldServiceAmount" => isset($sponser_cart_items['oldServiceAmount'][$i]) && $sponser_cart_items['oldServiceAmount'][$i] > 0 ? $sponser_cart_items['oldServiceAmount'][$i] : $sponser_cart_items['serviceAmount'][$i],
						"discountedAmount" => isset($sponser_cart_items['discountedAmount'][$i]) && $sponser_cart_items['discountedAmount'][$i] > 0 ? $sponser_cart_items['discountedAmount'][$i] : 0,
					);
				}
			} else {

				$dataWithAmount[] = array(
					"_id" => $sponser_cart_items['ids'][$i],
					"ServiceId" => $sponser_cart_items['ids'][$i],
					"serviceName" => $sponser_cart_items['serviceName'][$i],
					"serviceCategory" => $sponser_cart_items['ctg'][$i],
					"serviceType" => $sponser_cart_items['serviceTypes'][$i],
					"serviceAmount" => $sponser_cart_items['serviceAmount'][$i],
					"startDate" => '',
					"qty" => $sponser_cart_items['qty'][$i],
					"time" => @$sponser_cart_items['startTime'][$i],
					"day" => "",
					"serviceAddress" => "",
					"serviceDesc" => @$sponser_cart_items['service_desc'][$i],
					"serviceOccurrencesNo" => @$sponser_cart_items['serviceOccurrencesNo'][$i],
					"fullPackage" => @$sponser_cart_items['fullPackage'][$i],
					"oldServiceAmount" => isset($sponser_cart_items['oldServiceAmount'][$i]) && $sponser_cart_items['oldServiceAmount'][$i] > 0 ? $sponser_cart_items['oldServiceAmount'][$i] : $sponser_cart_items['serviceAmount'][$i],
					"discountedAmount" => isset($sponser_cart_items['discountedAmount'][$i]) && $sponser_cart_items['discountedAmount'][$i] > 0 ? $sponser_cart_items['discountedAmount'][$i] : 0,
				);
			}
		}
	}


	if (!empty($donation_cart_items)) {
		for ($i = 0; $i < count($donation_cart_items['ids']); $i++) {

			$dataWithAmount[] = array(
				"_id" => $donation_cart_items['ids'][$i],
				"ServiceId" => $donation_cart_items['ids'][$i],
				"serviceName" => $donation_cart_items['serviceName'][$i],
				"ServiceId" => $donation_cart_items['ids'][$i],
				"serviceCategory" => $donation_cart_items['ctg'][$i],
				"serviceType" => $donation_cart_items['serviceTypes'][$i],
				"serviceAmount" => $donation_cart_items['serviceAmount'][$i],
				"qty" => $donation_cart_items['qty'][$i],
				"day" => "",
				"serviceAddress" => "",
				"cartCreDate" => date("m/d/Y"),
				"cartCreTime" => date("h:i A")
			);
		}
	}

	if (!empty($event_cart_items)) {
		for ($i = 0; $i < count($event_cart_items['ids']); $i++) {

			if (isset($event_cart_items['startDate'][$i]) && !empty($event_cart_items['startDate'][$i])) {
				$startDateArray = explode(", ", $event_cart_items['startDate'][$i]);
				foreach ($startDateArray as $startDate) {

					$dataWithAmount[] = array(
						"_id" => $event_cart_items['ids'][$i],
						"ServiceId" => $event_cart_items['ids'][$i],
						"serviceName" => $event_cart_items['serviceName'][$i],
						"serviceCategory" => $event_cart_items['ctg'][$i],
						"serviceType" => $event_cart_items['serviceTypes'][$i],
						"serviceAmount" => $event_cart_items['serviceAmount'][$i],
						"startDate" => $startDate,
						"qty" => $event_cart_items['qty'][$i],
						"time" => @$event_cart_items['startTime'][$i],
						"day" => "",
						"serviceAddress" => "",
						"serviceDesc" => @$event_cart_items['service_desc'][$i],
						"serviceOccurrencesNo" => @$event_cart_items['serviceOccurrencesNo'][$i],
						"fullPackage" => @$event_cart_items['fullPackage'][$i],
						"oldServiceAmount" => isset($event_cart_items['oldServiceAmount'][$i]) && $event_cart_items['oldServiceAmount'][$i] > 0 ? $event_cart_items['oldServiceAmount'][$i] : $event_cart_items['serviceAmount'][$i],
						"discountedAmount" => isset($event_cart_items['discountedAmount'][$i]) && $event_cart_items['discountedAmount'][$i] > 0 ? $event_cart_items['discountedAmount'][$i] : 0,
					);
				}
			} else {

				$dataWithAmount[] = array(
					"_id" => $event_cart_items['ids'][$i],
					"ServiceId" => $event_cart_items['ids'][$i],
					"serviceName" => $event_cart_items['serviceName'][$i],
					"serviceCategory" => $event_cart_items['ctg'][$i],
					"serviceType" => $event_cart_items['serviceTypes'][$i],
					"serviceAmount" => $event_cart_items['serviceAmount'][$i],
					"startDate" => '',
					"qty" => $event_cart_items['qty'][$i],
					"time" => @$event_cart_items['startTime'][$i],
					"day" => "",
					"serviceAddress" => "",
					"serviceDesc" => @$event_cart_items['service_desc'][$i],
					"serviceOccurrencesNo" => @$event_cart_items['serviceOccurrencesNo'][$i],
					"fullPackage" => @$event_cart_items['fullPackage'][$i],
					"oldServiceAmount" => isset($event_cart_items['oldServiceAmount'][$i]) && $event_cart_items['oldServiceAmount'][$i] > 0 ? $event_cart_items['oldServiceAmount'][$i] : $event_cart_items['serviceAmount'][$i],
					"discountedAmount" => isset($event_cart_items['discountedAmount'][$i]) && $event_cart_items['discountedAmount'][$i] > 0 ? $event_cart_items['discountedAmount'][$i] : 0,
				);
			}
		}
	}
	return $dataWithAmount;
}

/*=====Recurring Donation===*/

function encryptMd5($value)
{
	return md5($value);
}

function detectCardType($number)
{
	$re = [
		"ELECTRON" => "/^(4026|417500|4405|4508|4844|4913|4917)\d+$/",
		"MAESTRO" => "/^(5018|5020|5038|5612|5893|6304|6759|6761|6762|6763|0604|6390)\d+$/",
		"DANKORT" => "/^(5019)\d+$/",
		"INTERPAYMENT" => "/^(636)\d+$/",
		"UNIONPAY" => "/^(62|88)\d+$/",
		"VISA" => "/^4[0-9]{12}(?:[0-9]{3})?$/",
		"MASTERCARD" => "/^5[1-5][0-9]{14}$/",
		"AMEX" => "/^3[47][0-9]{13}$/",
		"DINERS" => "/^3(?:0[0-5]|[68][0-9])[0-9]{11}$/",
		"DISCOVER" => "/^6(?:011|5[0-9]{2})[0-9]{12}$/",
		"JCB" => "/^(?:2131|1800|35\d{3})\d{11}$/"
	];

	foreach ($re as $key => $pattern) {
		if (preg_match($pattern, $number)) {
			return $key;
		}
	}
	return "UNKNOWN CARD TYPE";
}

function checkSideCart()
{
	$CI   = &get_instance();
	$cart_items = $CI->session->userdata('service_cart');

	$htmlList = '';
	if (!empty(@$cart_items['ids'])) {
		$htmlList = '  <div class="row">
		<div style="margin-bottom: 10px; padding: 0px!important;font-size: x-small;">
		<div class="form-check form-check-inline  mt-3" style="padding: 0px!important;margin-right: 0rem;    margin-left: 6px;">
		<input class="form-check-input" type="checkbox" id="InTempleCheckbox" name="InTempleCheckbox" style="border-radius: 5px; padding: 6px; font-size: 4px; border: 2px solid #ffc107; margin-right: 0;">
		<label class=" pt-0 fw-bold" style="font-size: small;margin-left: 4px;" for="InTempleCheckbox">PAY NOW</label>
		</div>

		<div class="form-check form-check-inline " style="margin-right: 0rem; padding-left: 0.9em;">
		<input class="form-check-input" type="checkbox" id="AtHomeCheckbox" name="AtHomeCheckbox" style="border-radius: 5px; padding: 6px; font-size: 4px; border: 2px solid #ffc107; margin-right: 0;">
		<label class=" pt-0 fw-bold" style="font-size: small;margin-left: 4px;" for="AtHomeCheckbox">PAY LATER</label>
		</div>

		<div class="form-check form-check-inline " style="margin-right: 0rem; padding-left: 0.9em;">
		<input class="form-check-input" type="checkbox" id="RequestService" name="RequestService" style="border-radius: 5px; padding: 6px; font-size: 4px; border: 2px solid #ffc107; margin-right: 0;">
		<label class=" pt-0 fw-bold" style="font-size: small;margin-left: 4px;" for="RequestService">SERVICE REQUEST</label>
		</div>
		</div>
		</div>';


		$htmlList .= '  <div class="row">';

		if (!empty(@$cart_items['ids'])) {
			foreach (@$cart_items['ids'] as $key => $value) {
				$selectedCartDats = array();
				if (!empty($cart_items['startDate'][$key])) {
					$selectedCartDats = explode(',', $cart_items['startDate'][$key]);
				}

				foreach ($selectedCartDats as $dateKey => $selectedCatVal) {

					$servicesAmount = $cart_items['serviceAmount'][$key];

					$htmlList .= ' <div class="card mt-1 scartTr' . $cart_items['ids'][$key] . '  servicesTr ' . $cart_items['payment_btn_check'][$key] . '">
					<div class="card-body px-0 m-0">
					<small>
					<h5 class="card-title m-0">' . $cart_items['serviceName'][$key] . '</h5>
					<p class="card-text">
					<a href="" class="text-primary">Price: ' . getCurrencySymbol() . ' ' . price_format($servicesAmount, 2) . ' </a>
					<a href="" class="ml-1 text-danger">Qty: ' . $cart_items['qty'][$key] . '</a>

					<span class="p-1" style="float: right; background: bisque; line-height: normal;">
					' . getCurrencySymbol() . ' ' . price_format(($cart_items['serviceAmount'][$key] * $cart_items['qty'][$key]), 2) . '
					&nbsp;
					<a href="javascript:void(0);"  class="text-danger delete-row" data-row-id="' . $cart_items['ids'][$key] . '" data-selected-date="' . $selectedCatVal . '" > <i class="fa fa-trash-o"></i></a>
					</span>
					</p>
					</small>
					</div>
					</div>';
				}
			}
		}

		$htmlList .= '  </div>';


		$htmlList .= '<span >
		<hr class="mb-1">  
		<div class="text-end">Total Amount: ' . getCurrencySymbol() . ' <span class="allPrice"> ' . price_format($cart_items['totalPrice'], 2) . '</span></div>
		<hr class="mt-1">
		<a href="javascript:void(0)" class="btn btn-success col-md-12" onclick="CartCheckLogin(' . "'" . 'services' . "'" . ');" style="background-color: #ffc107;color: #15102e;border-radius: 6px!important;border: 0px!important;"> Confirm Order </a>
		</span>';
	}

	return $htmlList;
}

/*=====Recurring Donation===*/

function getFilterData($json_data)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);



	curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	if (!empty($response) && $response->statusCode == 1 && isset($response->data)) {
		return $response->data;
	} else {
		return [];
	}
}

function getFacilitySessionData()
{
	$CI   = &get_instance();
	$facilitySettings = SettingsApi()['result']['data'][0]['facilitySettings'];
	$facilities_shift = $facilitySettings['shift'];

	$cart_data = $CI->session->userdata('facilities_cart');


	$facilitiesData = array();

	for ($i = 0; $i < count($cart_data['ids']); $i++) {

		$startTime = '';
		$endTime = '';
		foreach ($facilities_shift as $shift) {


			if ($shift['name'] === @$cart_data['bookingTypes'][$i]) {
				$startTime = @$shift['startTime'];
				$endTime = @$shift['endTime'];
				// Break the loop once matching shift is found
				break;
			} else {
				$startTime =  @$cart_data['start_time'][$i];
				$endTime  = @$cart_data['end_time'][$i];
			}
		}


		$facilitiesData[] = array(
			"_id" => $cart_data['ids'][$i],
			"ServiceId" => $cart_data['ids'][$i],
			"serviceName" => $cart_data['serviceName'][$i],
			"serviceCategory" => $cart_data['ctg'][$i],
			// "serviceCategory" => "IN-TEMPLE",
			"serviceType" => $cart_data['serviceTypes'][$i],
			"serviceAmount" => $cart_data['serviceAmount'][$i],
			"costPerDay" => $cart_data['serviceAmount'][$i],
			"startDate" => @$cart_data['startDate'][$i],
			"qty" => $cart_data['qty'][$i],
			"time" => @$cart_data['startTime'][$i],
			"day" => "",
			"bookingTypes" => @$cart_data['bookingTypes'][$i],
			"oldServiceAmount" => @$cart_data['oldServiceAmount'][$i],
			"discountedAmount" => @$cart_data['discountedAmount'][$i],
			"couponCode" => @$cart_data['couponCode'][$i],
			"couponId" => @$cart_data['couponId'][$i],
			"startTime" => @$startTime,
			"endTime" => @$endTime,
			"cartType" => "FACILITY REQUEST",
		);
	}

	return $facilitiesData;
}
function getPujaList($service_name, $service_id)
{

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	if (empty($service_name)) {
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{
		\"componentConfig\":{
			\"moduleName\":\"Pooja List\",
			\"aspectType\":\"poojaList\",
			\"productID\":\"" . ApiBaseUrl()['productID'] . "\",
			\"clientID\":\"" . ApiBaseUrl()['clientID'] . "\",
			\"query\":{
				\"aspectType\":\"poojaList\",
				
				\"serviceId\":\"" . $service_id . "\"
				},
				\"skip\":0,
				\"next\":1400
			}}");
	} else {
		curl_setopt($ch, CURLOPT_POSTFIELDS, '{
    "componentConfig": {
        "moduleName": "Pooja List",
        "aspectType": "poojaList",
        "productID": "' . ApiBaseUrl()['productID'] . '",
        "clientID": "' . ApiBaseUrl()['clientID'] . '",
        "query": {
            "aspectType": "poojaList",
            "$or": [
                {"serviceId": "' . $service_id . '"},
                {"serviceName": "' . $service_name . '"}
            ]
        },
        "skip": 0,
        "next": 1400
    }
}');
	}



	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return @json_decode($result, true)['data'][0];
}


function getShowInSplEvnt()
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . filterAPI()['url']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$productID = ApiBaseUrl()['productID'];
	$clientID = ApiBaseUrl()['clientID'];
	$post_data = [
		'componentConfig' => [
			'moduleName' => "Temple Services",
			'aspectType' => "ServiceSetup",
			'query' => [
				"aspectType" => "ServiceSetup",
				"serviceCategoryTypes" => "EVENTS",
				"sourceTypes" => "WEBSITE",
				"status" => "ACTIVE",
				"showInSplEvnt" => "YES"
			],
			'productID' => $productID,
			'clientID' => $clientID,
			'skip' => 0,
			'next' => 1220,
		],
	];
	$dataJson = json_encode($post_data);

	// var_dump($dataJson);
	// die();
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	return isset($response['data']) ?  $response['data'] : array();
}


function getPartisipentEvnt($id = '')
{


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . "api/puja/getParticipateEventList");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$productID = ApiBaseUrl()['productID'];
	$clientID = ApiBaseUrl()['clientID'];
	$post_data = [
		'dataJson' => [
			"startDate" => date('mm/dd/YYYY'),
			"endDate" => date('mm/dd/YYYY')
		],
		'clientId' => $clientID
	];
	$dataJson = json_encode($post_data);

	// var_dump($dataJson);
	// die();
	curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

	$headers = array();

	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);

	$response = json_decode($result, true);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	if (!empty($id)) {
		$matchedItem = null;
		foreach ($response['data'] as $item) {
			if ($item['_id'] === $id) {
				$matchedItem = $item;
				break;
			}
		}
		return $matchedItem;
	} else {
		return isset($response['data']) ?  $response['data'] : array();
	}
}


function ReturnDataFilterByID($target_id, $DataArray)
{

	$matchedData = null;

	foreach ($DataArray as $item) {
		if ($item['_id'] === $target_id) {
			$matchedData = $item;
			break; // Stop once matched
		}
	}
	return $matchedData;
}


function getDailyMenuDevotee()
{
	$CI = &get_instance();

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt_array($curl, array(
		CURLOPT_URL => ApiBaseUrl()['url'] . "api/dailyMenuServices/getDailyMenuDevotee",
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS => "{
    \"productId\":\"" . ApiBaseUrl()["productID"] . "\",
    \"clientId\":\"" . ApiBaseUrl()["clientID"] . "\",
    \"userName\":  \"pra3230\" ,
	 \"query\": {}
	}"
	));



	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';

	$headers[] = 'Content-Type: application/json';
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($curl);
	$response = json_decode($result);


	// print_r($response);


	if (curl_errno($curl)) {
		echo 'Error:' . curl_error($curl);
	}
	curl_close($curl);
	if (isset($response->data)) {
		$data = $response->data;
	} else {
		$data = [];
	}
	return $data;
}




function ValidatePrasadamCheckout()
{
	$CI = &get_instance();
	$session_data = $CI->session->userdata('prasadam_cart');
	 
	$returnStatus = false;
	$TotalAmt = 0;
	if (!empty($session_data['ids'])) {
		foreach ($session_data['ids'] as $i => $id) {
			$TotalAmt += (float)$session_data['serviceAmount'][$i] *(float)$session_data['qty'][$i];
			if ($TotalAmt >= 10) {
				$returnStatus = true;
				break;
			}
		}
	}

	return $returnStatus;
}

function ValidateAkshayaPatraCheckout()
{
	$CI = &get_instance();
	$session_data = $CI->session->userdata('akshaya_patra_cart');
	 
	$returnStatus = false;
	$TotalAmt = 0;
	if (!empty($session_data['ids'])) {
		foreach ($session_data['ids'] as $i => $id) {
			$TotalAmt += (float)$session_data['serviceAmount'][$i] *(float)$session_data['qty'][$i];
			if ($TotalAmt >= 10) {
				$returnStatus = true;
				break;
			}
		}
	}

	return $returnStatus;
}

function getBookingTimes()
{
	return array(
		'startTime' => '09:00 AM',
		'endTime' => '09:00 PM'
	);
}
function getQRSetting()
{
	return array(
		// "login"=>"WITHOUTOTP",
		"login" => "WITHOTP",
	);
}
function getSponsorTypesServicesByServiceQR($session_data)
{


	$CI = &get_instance();

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/auth/getCurrentService');

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, "{
	\"date\": \"" . date('Y-m-d') . "\", 
	\"time\": \"" . date('h:i A') . "\", 
	\"filterBy\": \"\", 
	\"deityName\": \"\",   
	\"clientId\": \"" . ApiBaseUrl()['clientID'] . "\"
	}");


	$token = $CI->session->userdata('token');
	$headers = array();
	$headers[] = 'Authorization: Bearer ' . $token . '';
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}

	curl_close($ch);
	$services = json_decode(json_encode($response->data), true);
	$services = sortBySequenceId($services);

	$currency = getCurrencySymbol();

	$html = '';

	// var_dump($services);



	if ($services != array()) {
		$deities_data = getWebSyncsData('Master Data Management', 'deity', '');
		foreach ($services as $key => $item) {




			$isValid = filterValidData($item);
			if ($isValid == 1) {


				$cartDateCount = 1;
				if (in_array($item['_id'], $session_data['ids'])) {
					$newQty   = ($session_data['qty'][array_search($item['_id'], $session_data['ids'])]);
					$cartDate = (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]);

					if (!empty($cartDate)) {
						$cartDateCount = count(explode(',', $cartDate));
					}
				}

				if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo']) && $item['serviceOccurrencesNo'] > 1) {
					$item['qtyCounter'] = 'NO';
				}

				if ($item['qtyCounter'] == 'YES') {
					$quantityContainer_display = 'inline-flex';
				} else {
					$quantityContainer_display = 'none';
				}



				if (isset($item['Image']) && !empty($item['Image'])) {
					$src = ApiBaseUrl()['url'] . $item['Image'];
				} else {
					$src = base_url('assets/img/') . "logo.png";
				}



				if (isset($item['bookingType']) && CheckEmptyNullVar($item['bookingType']) != '') {

					if ($item['bookingType'] == 'PAY NOW'  &&  $item['serviceAmount'] > 0) {

						$bookingType = 'PAY NOW';
					} else if ($item['bookingType'] == 'PAY LATER'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'PAY LATER';
					} else if ($item['bookingType'] == 'OPTIONAL'  &&  $item['serviceAmount'] > 0) {
						$bookingType = 'OPTIONAL';
					} else {
						$bookingType = 'PAY NOW';
					}
				} else {
					$bookingType = 'PAY NOW';
				}

				if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
					$serviceOccurrencesNo = $item['serviceOccurrencesNo'];
				} else {
					$serviceOccurrencesNo = '';
				}


				if (!isset($item['isDTVisible']) && !isset($item['isdtVisible'])) {
					$item['isDTVisible'] = 'NO';
				} else {
					$item['isDTVisible'] = isset($item['isDTVisible']) ? $item['isDTVisible'] : $item['isdtVisible'];
				}



				$is_availibility_check = checkServiceAvailability(@$item['isAvailable'], $item);

				$available_count_design = '';
				$filter_color = '';
				$available_count = '';
				$disable_input_field = '';

				if ($is_availibility_check == 1) {
					$available_count_design = '';
					$filter_color = 'filter: grayscale(1);';
					$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
					$disable_input_field = 'disabled readonly';
				} else {

					if ($is_availibility_check == 3) {
						if (isset($item['AvailableCount']) && $item['AvailableCount'] > 0) {
							$available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-success mt-2 ms-1" style="font-size: 15px!important;">Avl. ' . $item['AvailableCount'] . '</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						} else {
							$available_count_design = ' <a href="javascript:void(0)">
							<div class="mask">
							<div class="d-flex justify-content-start align-items-end h-100" style="top: 57%; position: fixed;">
							<h5 style="font-size: 15px!important;margin-top:70px"><span class="badge bg-danger mt-2 ms-1" style="font-size: 15px!important;">Avl. 0</span></h5>
							</div>
							</div>
							<div class="hover-overlay">
							<div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
							</div>
							</a>';
						}

						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
						<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . htmlspecialchars(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" isTimeVisible="' . @$item['isTimeVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc=""  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '"  isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
						</div>';
					} else if ($is_availibility_check == 2) {
						$filter_color = 'filter: grayscale(1);';
						$checkbox = '<i class="fa fa-ban fa-2x text-danger"></i>';
						$disable_input_field = 'disabled readonly';
					} else {


						$checkbox = '<div class="form-check" style="justify-content: center; display: flex;">
							<input type="checkbox" class="form-check-input" id="checkbox_' . $item['_id'] . '" value="' . $item['_id'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ? 'checked' : '') . '  data-id="' . $item['_id'] . '" data-category="' . $item['serviceCategoryTypes'] . '" cart_category="' . ($item['serviceAmount'] != '' || $item['serviceAmount'] != 0 ? $item['serviceCategoryTypes'] : 'SERVICE-REQUEST') . '" data-service-type="' . $item['serviceTypes'] . '" data-start-time="' . $item['startTime'] . '" data-start-date="' . $item['startDate'] . '"  data-service-name="' . $item['refDataName'] . '" data-price="' . $item['serviceAmount'] . '" data-end-date="' . $item['endDate'] . '" data-end-time="' . $item['endTime'] . '" data-description="' . htmlspecialchars(trim($item['description'])) . '" data-image="' . $item['Image'] . '"  isDateTime="' . @$item['isDTVisible'] . '" isTimeVisible="' . @$item['isTimeVisible'] . '" data-BookingLimitPerDay="' . @$BookingLimitPerDay . '" onchange="addTocart()" name="sponsorships_id[]" style="padding:14px!important" is_date_required="' . $item['isDTVisible'] . '" data-servicedesc="' . (in_array($item['_id'], $session_data['ids']) ?   $session_data['service_desc'][array_search($item['_id'], $session_data['ids'])]  :  '') . '"  data-serviceOccurrencesNo="' . $serviceOccurrencesNo . '" is_membership_discount="' . @$item['membershipDiscount'] . '"  membership_discount_amt="' . @$item['membershipAmount'] . '"  isDietySelected="' . @$item['isDietySelected'] . '"  disclaimerText="' . @$item['disclaimerText'] . '">
							</div>';
					}
				}



				$limitPerdayFeature = '';
				$BookingLimitPerDay  = CheckEmptyNullVar(@$item['BookingLimitPerDay']);
				$BookingLimitPerDay = $BookingLimitPerDay ? $BookingLimitPerDay : 0;

				if ($BookingLimitPerDay > 0) {

					$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class=" form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . ($session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly ' . $disable_input_field . ' start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" data-isDietySelected="' . @$item['isDietySelected'] . '"   _id="' . $item['_id'] . '">';
				} else {

					// if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {



					// 	if (!empty($item['dayTypes'])) {

					// 		$date_value = 'value=""';
					// 	} else {
					// 		$date_value = 'value="' . date('m/d/Y') . '"';
					// 	}
					// } else if (isset($item['startDate']) && $item['startDate']) {
					// 	$date_value = 'value="' . $item['startDate'] . '" disabled';
					// } else {

					// 	if (in_array($item['_id'], $session_data['ids'])) {
					// 		$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
					// 	} else {
					// 		// $date_value = 'value="' . date('m/d/Y') . '"';
					// 		$date_value = 'value=""';
					// 	}
					// }

					if (isset($item['startDate']) && $item['startDate'] && isset($item['endDate']) && $item['endDate']) {

						if ($item['startDate'] == $item['endDate']) {
							$date_value = 'value="' . $item['startDate'] . '" disabled';
							$date_value1 = 'value="' . $item['startDate'] . '" disabled';
						} else {

							if (!empty($item['dayTypes'])) {
								if (in_array($item['_id'], $session_data['ids'])) {
									if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
										$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
										if (!empty($selectedDate) && is_string($selectedDate)) {
											$date_value = 'value="' . ($selectedDate) . '"';
											$selectedDate = explode(", ", $selectedDate);
											$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
											$date_value1 = 'value="' . ($selectedDate1) . '"';
										} else {
											$date_value1 = 'value="' . ($selectedDate) . '"';
											$date_value = 'value="' . ($selectedDate) . '"';
										}
									} else {
										$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
										$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
									}
								} else {

									$date_value = 'value=""';
									$date_value1 = 'value=""';
								}
							} else {
								$date_value = 'value="' . date('m/d/Y') . '"';
								$date_value1 = 'value="' . date('m/d/Y') . '"';
							}
						}
					} else if (isset($item['startDate']) && $item['startDate']) {
						$date_value = 'value="' . $item['startDate'] . '" disabled';
						$date_value1 = 'value="' . $item['startDate'] . '" disabled';
					} else {

						if (in_array($item['_id'], $session_data['ids'])) {
							if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
								$selectedDate = @$session_data['startDate'][array_search($item['_id'], $session_data['ids'])];
								if (!empty($selectedDate) && is_string($selectedDate)) {
									$date_value = 'value="' . ($selectedDate) . '"';
									$selectedDate = explode(", ", $selectedDate);
									$selectedDate1 = $selectedDate[0] . ' - ' . end($selectedDate);
									$date_value1 = 'value="' . ($selectedDate1) . '"';
								} else {
									$date_value1 = 'value="' . ($selectedDate) . '"';
									$date_value = 'value="' . ($selectedDate) . '"';
								}
							} else {
								$date_value = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
								$date_value1 = 'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"';
							}
						} else {
							// $date_value = 'value="' . date('m/d/Y') . '"';
							$date_value = 'value=""';
							$date_value1 = 'value=""';
						}
					}

					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo']) && $item['serviceOccurrencesNo'] > 0) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="d-none datepicker-services1 form-control form-control-sm date-time-placeholder" style="color:#000000;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '" data-isDietySelected="' . @$item['isDietySelected'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker1_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color:#000000;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 30px;width: -webkit-fill-available; margin-top: -29px;" placeholder="Start Date" ' . $date_value1 . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '" _id="' . $item['_id'] . '" data-isDietySelected="' . @$item['isDietySelected'] . '" >';
					} else {
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder1" style="color:#000000;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; margin-left: 31px; width: -webkit-fill-available; margin-top: -29px; " placeholder="Select Date" ' . $date_value . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" ' . $disable_input_field . '  select_date="' . @$item['selectDate'] . '" start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '"   _id="' . $item['_id'] . '" data-isDietySelected="' . @$item['isDietySelected'] . '" >';
					}
				}

				$limitPerdayFeature .= '<span  id="datepickerCount_' . $item['_id'] . '" style="color:var(--main-color-new-theme)!important;"></span>';
				/*if ($BookingLimitPerDay > 0) {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '" onclick="availabelServiceList(' . "'" . $item['_id'] . "'" . ');"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '" readonly  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				} else {
					if (isset($item['serviceOccurrencesNo']) && !empty($item['serviceOccurrencesNo'])) {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services1 form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Start Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  serviceOccurrencesNo="' . $item['serviceOccurrencesNo'] . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '">';
					} else {
						// $limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date" ' . (isset($item['startDate']) && $item['startDate'] != '' ? 'value="' . $item['startDate'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ?  'value="' . (@$session_data['startDate'][array_search($item['_id'], $session_data['ids'])]) . '"'  : 'value="' . date('m/d/Y') . '"') . '') . ' readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
						$limitPerdayFeature 	.= '<input type="text"  id="datepicker_' . $item['_id'] . '"  class="datepicker-services form-control form-control-sm date-time-placeholder" style="color: #ffffff;background-color: #ffffff00;opacity: 1;border: 0;padding:0px!important; " placeholder="Select Date"  readonly dayType="' . (isset($item['dayTypes']) && !empty($item['dayTypes']) ? $item['dayTypes'] : '') . '"  start_date="' . @$item['startDate'] . '" end_date="' . @$item['endDate'] . '" >';
					}
				}*/

				$deities_html = '';
				if (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES') {
					$deities_html .= '<div class="col-sm-4">
					<select class="form-control" id="dietyName_' . $item['_id'] . '" style="font-size: .875rem;" onchange="addTocart();">
					<option value="" selected disabled>--select diety--</option>';
					foreach ($deities_data as $deity) {
						$selected = '';
						if (!empty($session_data['ids']) && !empty($session_data['dietyName'])) {
							$index = array_search($item['_id'], $session_data['ids']);
							if ($index !== false && isset($session_data['dietyName'][$index]) && $session_data['dietyName'][$index] == $deity['refDataName']) {
								$selected = 'selected';
							}
						}

						$deities_html .= '<option value="' . $deity['refDataName'] . '" ' . $selected . '  data-daytype="' . @$deity['day'] . '">' . htmlspecialchars($deity['refDataName']) . '</option>';
					}


					$deities_html .= '</select>
					</div>';
				}

				$dateTimeCode = '';
				$dateCode = '';

				if (isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') {

					$dateCode = '
						<!-- Date Section (8 columns) -->
						<div class="col-sm-4 col-md-4 m-0 p-0 date-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:#000000!important; background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-calendar"></i>
								</span>
								' . $limitPerdayFeature . '
							</div>
						</div>';
				}


				$TimeCode = '';
				if (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') {

					$TimeCode = '
						<!-- Time Section (4 columns) -->
						<div class="col-sm-4 col-md-4 p-0 time-col-div">
							<div class="input-group">
								<span class="input-group-text" style="color:#000000!important; background-color: #e9ecef00; border: 1px solid #ced4da00;" id="basic-addon1">
									<i class="fa fa-clock-o"></i>
								</span>
								<input type="text" id="timepicker_' . $item['_id'] . '" _id="' . $item['_id'] . '" data-dt-visible="' . (isset($item['isDTVisible']) ? $item['isDTVisible'] : 'NO') . '"  class="form-control form-control-sm timepicker-services date-time-placeholder1" style="color:#000000; background-color: #ffffff00; opacity: 1; border: 0; padding: 0px!important;" '
						. (isset($item['startTime']) && $item['startTime'] != '' ? 'value="' . $item['startTime'] . '" disabled' : '' . ((in_array($item['_id'], $session_data['ids'])) ? 'value="' . ($session_data['startTime'][array_search($item['_id'], $session_data['ids'])]) . '"' : ''))
						. ' placeholder="--:--" ' . $disable_input_field . '>
							</div>
						</div>';
				}

				if ((isset($item['isDTVisible']) && $item['isDTVisible'] == 'YES') || (isset($item['isTimeVisible']) && $item['isTimeVisible'] == 'YES') || (isset($item['isDietySelected']) && $item['isDietySelected'] == 'YES')) {
					$dateTimeCode = '<div class="row m-0 pt-3" style="margin-top: -14px !important;">' . $deities_html . $dateCode . $TimeCode . '</div>';
				}



				if (isset($item['description']) && $item['description'] != '') {
					$descriptionEyeIcon = '<style>
					.collapse.in { display: inline !important; }
					</style>

					&nbsp;<a href="#more' . $item['_id'] . '" data-toggle="collapse" class="eye-toggle" aria-expanded="false"><i class="fa fa-eye" style="color: #000000;font-size: 17px;margin-top: -3px;width: fit-content;"></i></a>
					';
					$descriptionWithEyeIcon = '
					<span class="collapse fw-normal" id="more' . $item['_id'] . '" data-item-id="' . $item['_id'] . '" style="color:var(--main-color-new-theme);">
					' . $item['description'] . '
					</span> 
					';
				} else {
					$descriptionEyeIcon = '';
					$descriptionWithEyeIcon = '';
				}



				$pageLength = $key + 1;



				$priceType = '';

				if (isset($item['priceType']) && !empty($item['priceType']) && $item['priceType'] != array()) {


					$priceTypeString = $item['priceType'];


					$priceTypeArray = json_decode($priceTypeString, true);

					if ($priceTypeArray != array()) {

						$priceType = '<select id="' . $item['_id'] . '" class="price_types" class="p-2 mt-2" style="font-size:22px;margin-left: 13px; margin-top: 13px;">';


						foreach ($priceTypeArray as $index => $option) {

							$priceType .= '<option value="' . $option['value'] . '" ' . ((in_array($item['_id'], $session_data['ids'])) ?  (@$session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])] == $option['value'] ? 'selected' : '')  : '') . ' key="' . $option['key'] . '">' . $option['key'] . ' (' . $currency . ' ' . price_format($option['value'], 2) . ')</option>';
						}

						$priceType .= '</select>';
					}
				}



				if ($item['serviceAmount'] != 0 && $item['serviceAmount'] != '') {



					if ($quantityContainer_display == 'none') {

						$amountSection = '<span style="font-size:20px!important;font-weight:bold;margin-right: 25px;margin-top:5px;" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
					} else {
						$amountSection = '<span style="font-size:20px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . @$currency . '&nbsp;' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format(($session_data['qty'][array_search($item['_id'], $session_data['ids'])] * ($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])]) * $cartDateCount), 2)  :  price_format($item['serviceAmount'], 2)) . '</span>';
					}
				} else {

					$item['serviceAmount'] = 1;
					if ($quantityContainer_display == 'none') {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
					<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
					</div>


					<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important;margin-right: 25px;">
					' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
					</div>';
					} else {
						$amountSection = '<div class="input-group pb-2" style="padding-right: 10px;padding-left: 10px;"><span class="input-group-text" style="border-radius: 0.375rem rem ; padding-right: 5px;color: #808080;border:0;padding-right:10px;font-weight:bold">$</span>
						<input id="anyAmtEvent' . $item['_id'] . '" service-id="' . $item['_id'] . '" type="number" class="anyamt form-control amount-input" placeholder="0.00"  minlength="1" pattern="[1-9]\d*" style="background: transparent; color: white; font-size: 14px; font-weight: bold;" value="' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  "") . '" ' . $disable_input_field . ' ' . $disable_input_field . '>
						</div>
	
	
						<div class="d-none col-md-12" style="padding: 0px 30px;font-size:14px!important">
						' . @getCurrencySymbol() . '&nbsp;<span style="font-size:14px!important;font-weight:bold" id="Totalprice_' . $item['_id'] . '">' . ((in_array($item['_id'], $session_data['ids'])) ?   price_format($session_data['serviceAmount'][array_search($item['_id'], $session_data['ids'])], 2)  :  price_format($item['serviceAmount'], 2)) . '</span>
						</div>';
					}
				}



				$html .= '<div class="text-end d-none align-middle" style="background-color:var(--main-color-new-theme)!important;color:#fff!important;font-weight:bold;font-size:18px!important;padding: 5px 5px!important;" width="1%">' . @$currency . '&nbsp;<span  id="price_' . $item['_id'] . '">' . (price_format($item['serviceAmount'], 2)) . '</span>
				</div>
				<div class="row justify-content-center serviceSearch mb-1" style="' . $filter_color . '">
				<div class="col-md-12 col-xl-12 px-0">
				<div class="card shadow-0 border rounded-3 px-0" style="margin-bottom:5px!important;">
				<div class="card-body p-0 m-0">
				<div class="row" id="searchHere" style="background-color:var(--main-color-new-theme)!important;color:white;border-radius: 8px;">
				<div class="col-md-12 col-lg-1 col-xl-1 mb-4 mb-lg-0 px-0 service-col-img">
				<div class="bg-image hover-zoom ripple rounded ripple-surface">
				<div class="crop-center img-responsive bg-light services-thumb" style="background-image: url(' . $src . ');border-radius: 9px 0px 0px 9px;box-shadow: 2px 2px 10px #00000030; height: 100px!important;width:100%;background-size: cover; background-repeat: no-repeat;"> ' . $available_count_design . '</div>
				<a href="#!">
				<div class="hover-overlay">
				<div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
				</div>
				</a>
				</div>
				</div>
				<div class="col-md-6 col-lg-6 col-xl-8 service-col-scontent" style="background-color:white!important; display: flex; flex-direction: column; align-items: flex-start;">
				<div style="width: 100%;">
					<label class="pt-2" style="font-size:20px!important; margin-bottom:0;color:var(--main-color-new-theme);display:inline-flex;width: -webkit-fill-available;">
													' . replaceSingleQuotesWithBackticks($item['refDataName'])  . $descriptionEyeIcon . '
												</label>
												' . $descriptionWithEyeIcon . '
				' . $dateTimeCode . '
				' . $priceType . '
				</div>
				</div>';
				if ($quantityContainer_display == 'none') {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 25px">
				<div class="res-amount" style="display: flex!important; flex-direction: row;justify-content: end !important; align-items: stretch;padding: 0px;"> ';
				} else {
					$html .= '<div class="col-md-6 col-lg-5 col-xl-3" style="display: flex; flex-direction: column; justify-content: center; padding:0px 10px 0px 25px">
			<div class="res-amount" style=""> ';
				}
				$html .= '

				<div class="quantity-container" style="display:' . $quantityContainer_display . '">

				<button class="minus-btn" id="minus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityMinusFunction(' . "'" . $item["_id"] . "'" . ')">-</button>

				<input type="number" value="' . ((in_array($item['_id'], $session_data['ids'])) ?  ($session_data['qty'][array_search($item['_id'], $session_data['ids'])])  : '1') . '" min="1" class="quantity-input" id="quantity-input' . $item['_id'] . '" readonly>

				<button class="plus-btn" id="plus-btn' . $item['_id'] . '" type="button" style="background-color: var(--main-color-new-theme)!important;color:white;padding: 11px 17px 12px 17px;height:30px;width:30px;" onclick="quantityPlusFunction(' . "'" . $item["_id"] . "'" . ')">+</button>

				</div>




				' . $amountSection . '
				' . $checkbox . '
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				</div>
				<input type="hidden" value="' . $pageLength . '" id="pageLength">';
			}
		}
		$html .= '</tbody>

		</table><input type="hidden" value="' . $pageLength . '" id="pageLength">';
	} else {
		$html .= '<div class="text-center text-danger my-5">There are no Services in this category.</div>';
	}

	return $html;
}

// get dynamic table 
function getParticipantsData($memberId, $eventId, $source)
{
	// Hit an API request
	$data = array(
		'dataJson' => array(
			'memberId' => $memberId,
			'eventId' => $eventId
		),
		'clientId' => ApiBaseUrl()['clientID'],
	);

	// Initialize curl
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . 'api/puja/getParticipateEventByMember');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

	$response = curl_exec($ch);

	if (curl_errno($ch)) {
		$error = curl_error($ch);
		curl_close($ch);
		return "Curl Error: " . $error;
	}

	curl_close($ch);

	$participant = json_decode($response, true);
	$html = '';
	// $html .= '<script>console.log(' . json_encode($participant) . ');</script>';
	$index = 0; // This should be passed in or set based on outer loop if used dynamically

	$html .= '<tr id="subtable-' . $index . '" class="subtable" style="display: none;">';
	$html .= '<td colspan="7" style="padding: 0;">';
	$html .= '<table class="table table-bordered">';
	$html .= '<thead>';
	$html .= '<tr>';
	$html .= '<th>Cart Creation Date</th>';
	$html .= '<th>Cart Creation Time</th>';
	$html .= '<th>Event Name</th>';
	$html .= '</tr>';
	$html .= '</thead>';
	$html .= '<tbody>';

	if (
		isset($participant['data'][0]['Datas']) &&
		is_array($participant['data'][0]['Datas']) &&
		count($participant['data'][0]['Datas']) > 0
	) {
		$counter = 0;
		foreach ($participant['data'][0]['Datas'] as $dataItem) {
			if ($counter >= 5) break;

			$cartCreDate = $dataItem['cartCreDate'] ?? 'N/A';
			$cartCreTime = $dataItem['cartCreTime'] ?? 'N/A';
			$eventName = $dataItem['eventName'] ?? 'N/A';

			$html .= '<tr>';
			$html .= '<td>' . htmlspecialchars($cartCreDate) . '</td>';
			$html .= '<td>' . htmlspecialchars($cartCreTime) . '</td>';
			$html .= '<td>' . htmlspecialchars($eventName) . '</td>';
			$html .= '</tr>';

			$counter++;
		}
	} else {
		$html .= '<tr>';
		$html .= '<td colspan="4">No data available</td>';
		$html .= '</tr>';
	}

	$html .= '</tbody>';
	$html .= '</table>';
	$html .= '</td>';
	$html .= '</tr>';


	if ($source === 'subtable') {
		return $html;
	} else {
		$participant = json_decode($response);

		if (!is_object($participant)) {
			return "<span class='text-muted' style='color: black !important;'>0</span>";
		}

		if (!isset($participant->data) || !is_array($participant->data) || count($participant->data) === 0) {
			return "<span class='text-muted' style='color: black !important;'>0</span>";
		}

		// Now safe to access
		return "<span class='text-muted' style='color: black !important;'>" . json_encode($participant->data[0]->sum) . "</span>";
	}
}


function getDailyMenu($json_data)
{

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'] . "api/dailyMenuServices/getDailyMenuDevotee");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);



	curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
	$headers = array();
	$headers[] = 'Content-Type: application/json';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	$response = json_decode($result);

	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);
	if (!empty($response) && $response->statusCode == 1 && isset($response->data)) {
		return $response->data;
	} else {
		return [];
	}
}